/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata.sql;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.apache.sis.internal.metadata.sql.Dialect;
import org.apache.sis.internal.metadata.sql.Syntax;
import org.apache.sis.internal.metadata.sql.TypeMapper;
import org.apache.sis.util.CharSequences;

public class SQLBuilder
extends Syntax {
    public static final String SELECT = "SELECT ";
    protected final StringBuilder buffer = new StringBuilder(200);

    public SQLBuilder(DatabaseMetaData databaseMetaData, boolean bl) throws SQLException {
        super(databaseMetaData, bl);
    }

    public SQLBuilder(Syntax syntax) {
        super(syntax);
    }

    public final boolean isEmpty() {
        return this.buffer.length() == 0;
    }

    public final SQLBuilder clear() {
        this.buffer.setLength(0);
        return this;
    }

    public final SQLBuilder append(int n) {
        this.buffer.append(n);
        return this;
    }

    public final SQLBuilder append(long l) {
        this.buffer.append(l);
        return this;
    }

    public final SQLBuilder append(char c) {
        this.buffer.append(c);
        return this;
    }

    public final SQLBuilder append(String string) {
        this.buffer.append(string);
        return this;
    }

    public final SQLBuilder appendIdentifier(String string) {
        this.buffer.append(this.quote).append(string).append(this.quote);
        return this;
    }

    public final SQLBuilder appendIdentifier(String string, String string2) {
        if (string != null && !string.isEmpty()) {
            if (this.quoteSchema) {
                this.appendIdentifier(string);
            } else {
                this.buffer.append(string);
            }
            this.buffer.append('.');
        }
        return this.appendIdentifier(string2);
    }

    public final SQLBuilder appendIdentifier(String string, String string2, String string3) {
        if (string != null && !string.isEmpty()) {
            this.appendIdentifier(string);
            this.buffer.append('.');
            if (string2 == null) {
                this.buffer.append(this.quote).append(this.quote).append('.');
            }
        }
        return this.appendIdentifier(string2, string3);
    }

    public final SQLBuilder appendEqualsValue(Object object) {
        if (object == null) {
            this.buffer.append(" IS NULL");
            return this;
        }
        this.buffer.append('=');
        return this.appendValue(object);
    }

    public final SQLBuilder appendValue(String string) {
        if (string == null) {
            this.buffer.append("NULL");
        } else {
            this.buffer.append('\'').append(string.replace("'", "''")).append('\'');
        }
        return this;
    }

    public final SQLBuilder appendValue(Object object) {
        if (object instanceof Number) {
            this.buffer.append(object);
        } else if (object instanceof Boolean) {
            this.buffer.append((Boolean)object != false ? "TRUE" : "FALSE");
        } else {
            return this.appendValue(object != null ? object.toString() : (String)null);
        }
        return this;
    }

    public final SQLBuilder appendWildcardEscaped(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_%", true);
        while (stringTokenizer.hasMoreTokens()) {
            this.buffer.append(stringTokenizer.nextToken());
            if (!stringTokenizer.hasMoreTokens()) break;
            this.buffer.append(this.escape).append(stringTokenizer.nextToken());
        }
        return this;
    }

    public final SQLBuilder appendFetchPage(long l, long l2) {
        if (l > 0L) {
            this.buffer.append(" OFFSET ").append(l).append(" ROW");
            if (l > 1L) {
                this.buffer.append('S');
            }
        }
        if (l2 > 0L) {
            this.buffer.append(" FETCH ").append(l <= 0L ? "FIRST" : "NEXT").append(' ').append(l2).append(" ROW");
            if (l2 > 1L) {
                this.buffer.append('S');
            }
            this.buffer.append(" ONLY");
        }
        return this;
    }

    public final SQLBuilder insertDistinctAfterSelect() {
        assert (CharSequences.startsWith((CharSequence)this.buffer, (CharSequence)SELECT, (boolean)false)) : this.buffer;
        this.buffer.insert(SELECT.length(), "DISTINCT ");
        return this;
    }

    public final String createColumn(String string, String string2, String string3, Class<?> clazz, int n) {
        this.clear().append("ALTER TABLE ").appendIdentifier(string, string2).append(" ADD COLUMN ").appendIdentifier(string3).append(' ');
        String string4 = TypeMapper.keywordFor(clazz);
        if (string4 != null) {
            this.append(string4);
        } else {
            this.append("VARCHAR(").append(n).append(')');
        }
        return this.toString();
    }

    public final String createForeignKey(String string, String string2, String string3, String string4, String string5, boolean bl) {
        if (this.dialect == Dialect.DERBY) {
            bl = false;
        }
        this.buffer.setLength(0);
        String string6 = this.buffer.append(string2).append('_').append(string3).append("_fkey").toString();
        return this.clear().append("ALTER TABLE ").appendIdentifier(string, string2).append(" ADD CONSTRAINT ").appendIdentifier(string6).append(" FOREIGN KEY(").appendIdentifier(string3).append(") REFERENCES ").appendIdentifier(string, string4).append(" (").appendIdentifier(string5).append(") ON UPDATE ").append(bl ? "CASCADE" : "RESTRICT").append(" ON DELETE RESTRICT").toString();
    }

    public final String toString() {
        return this.buffer.toString();
    }
}

