/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.awt.image.RasterFormatException;
import java.math.RoundingMode;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.measure.AngleFormat;
import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.storage.AbstractResource;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.NoSuchDataException;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.logging.PerformanceLevel;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public abstract class AbstractGridCoverageResource
extends AbstractResource
implements GridCoverageResource {
    protected AbstractGridCoverageResource(StoreListeners storeListeners, boolean bl) {
        super(storeListeners, bl);
    }

    @Override
    public Optional<Envelope> getEnvelope() throws DataStoreException {
        GridGeometry gridGeometry = this.getGridGeometry();
        if (gridGeometry != null && gridGeometry.isDefined(2)) {
            return Optional.of(gridGeometry.getEnvelope());
        }
        return Optional.empty();
    }

    @Override
    protected Metadata createMetadata() throws DataStoreException {
        MetadataBuilder metadataBuilder = new MetadataBuilder();
        metadataBuilder.addDefaultMetadata(this, this.listeners);
        return metadataBuilder.build();
    }

    protected DataStoreException canNotRead(String string, GridGeometry gridGeometry, Throwable object) {
        Object object2;
        int n = 0;
        Envelope envelope = null;
        if (object instanceof DisjointExtentException) {
            n = 1;
            if (gridGeometry != null && gridGeometry.isDefined(2)) {
                envelope = gridGeometry.getEnvelope();
            }
        } else if (object instanceof RuntimeException) {
            object2 = ((Throwable)object).getCause();
            if (AbstractGridCoverageResource.isReferencing((Throwable)object2)) {
                n = 2;
                object = object2;
            } else if (object instanceof ArithmeticException || object instanceof RasterFormatException) {
                n = 3;
            }
        } else if (AbstractGridCoverageResource.isReferencing((Throwable)object)) {
            n = 2;
        }
        object2 = this.createExceptionMessage(string, envelope);
        switch (n) {
            case 1: {
                return new NoSuchDataException((String)object2, (Throwable)object);
            }
            case 2: {
                return new DataStoreReferencingException((String)object2, (Throwable)object);
            }
            case 3: {
                return new DataStoreContentException((String)object2, (Throwable)object);
            }
        }
        return new DataStoreException((String)object2, (Throwable)object);
    }

    private static boolean isReferencing(Throwable throwable) {
        return throwable instanceof FactoryException || throwable instanceof TransformException;
    }

    protected void logReadOperation(Object object, GridGeometry gridGeometry, long l) {
        long l2;
        Level level;
        Logger logger = this.listeners.getLogger();
        if (logger.isLoggable(level = PerformanceLevel.forDuration((long)(l2 = System.nanoTime() - l), (TimeUnit)TimeUnit.NANOSECONDS))) {
            Locale locale = this.listeners.getLocale();
            Object[] objectArray = new Object[6];
            objectArray[0] = IOUtilities.filename(object != null ? object : this.listeners.getSourceName());
            objectArray[5] = (double)l2 / 1.0E9;
            JDK9.ifPresentOrElse((Optional)gridGeometry.getGeographicExtent(), geographicBoundingBox -> {
                AngleFormat angleFormat = new AngleFormat(locale);
                double d = geographicBoundingBox.getSouthBoundLatitude();
                double d2 = geographicBoundingBox.getNorthBoundLatitude();
                angleFormat.setPrecision(d2 - d, true);
                angleFormat.setRoundingMode(RoundingMode.FLOOR);
                objectArray[1] = angleFormat.format((Object)new Latitude(d));
                angleFormat.setRoundingMode(RoundingMode.CEILING);
                objectArray[2] = angleFormat.format((Object)new Latitude(d2));
                d = geographicBoundingBox.getWestBoundLongitude();
                d2 = geographicBoundingBox.getEastBoundLongitude();
                angleFormat.setPrecision(d2 - d, true);
                angleFormat.setRoundingMode(RoundingMode.FLOOR);
                objectArray[3] = angleFormat.format((Object)new Longitude(d));
                angleFormat.setRoundingMode(RoundingMode.CEILING);
                objectArray[4] = angleFormat.format((Object)new Longitude(d2));
            }, () -> {
                block3: {
                    block2: {
                        if (!gridGeometry.isDefined(2)) break block2;
                        Envelope envelope = gridGeometry.getEnvelope();
                        int n = Math.min(envelope.getDimension(), 2);
                        int n2 = 1;
                        for (int i = 0; i < n; ++i) {
                            objectArray[n2++] = envelope.getMinimum(i);
                            objectArray[n2++] = envelope.getMaximum(i);
                        }
                        break block3;
                    }
                    if (!gridGeometry.isDefined(4)) break block3;
                    GridExtent gridExtent = gridGeometry.getExtent();
                    int n = Math.min(gridExtent.getDimension(), 2);
                    int n3 = 1;
                    for (int i = 0; i < n; ++i) {
                        objectArray[n3++] = gridExtent.getLow(i);
                        objectArray[n3++] = gridExtent.getHigh(i);
                    }
                }
            });
            LogRecord logRecord = Resources.forLocale(locale).getLogRecord(level, (short)59, objectArray);
            logRecord.setSourceClassName(GridCoverageResource.class.getName());
            logRecord.setSourceMethodName("read");
            logRecord.setLoggerName(logger.getName());
            logger.log(logRecord);
        }
    }
}

