/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.sql.SQLException;
import javax.jcr.RepositoryException;
import javax.sql.DataSource;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.GenericCQConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.PostgreMultiDbJDBCConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.PostgreSingleDbJDBCConnection;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;

public class PostgreConnectionFactory
extends GenericCQConnectionFactory {
    public PostgreConnectionFactory(DataSource dbDataSource, JDBCDataContainerConfig containerConfig) {
        super(dbDataSource, containerConfig);
    }

    @Override
    public WorkspaceStorageConnection openConnection(boolean readOnly) throws RepositoryException {
        try {
            if (this.containerConfig.dbStructureType.isMultiDatabase()) {
                return new PostgreMultiDbJDBCConnection(this.getJdbcConnection(readOnly), readOnly, this.containerConfig);
            }
            return new PostgreSingleDbJDBCConnection(this.getJdbcConnection(readOnly), readOnly, this.containerConfig);
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public boolean isReindexingSupported() {
        return true;
    }
}

