/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.converter;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.sis.internal.converter.ArrayConverter;
import org.apache.sis.internal.converter.ClassPair;
import org.apache.sis.internal.converter.Column;
import org.apache.sis.internal.converter.FallbackConverter;
import org.apache.sis.internal.converter.IdentityConverter;
import org.apache.sis.internal.converter.SystemConverter;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Errors;

public class ConverterRegistry {
    private final Map<ClassPair<?, ?>, ObjectConverter<?, ?>> converters = new LinkedHashMap();
    private boolean isInitialized;

    protected void initialize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<ClassPair<?, ?>, ObjectConverter<?, ?>> map = this.converters;
        synchronized (map) {
            this.converters.clear();
            this.isInitialized = false;
        }
    }

    private <S, T> ObjectConverter<? super S, ? extends T> get(ClassPair<S, T> classPair) {
        assert (Thread.holdsLock(this.converters));
        return classPair.cast(this.converters.get(classPair));
    }

    private <S, T> void put(ClassPair<S, T> systemConverter, ObjectConverter<? super S, ? extends T> objectConverter) {
        assert (systemConverter.getClass() == ClassPair.class);
        assert (systemConverter.cast(objectConverter) != null) : objectConverter;
        assert (Thread.holdsLock(this.converters));
        if (objectConverter instanceof SystemConverter && objectConverter.getSourceClass() == systemConverter.sourceClass && objectConverter.getTargetClass() == systemConverter.targetClass) {
            this.converters.remove(systemConverter);
            systemConverter = (SystemConverter)objectConverter;
        }
        this.converters.put(systemConverter, objectConverter);
    }

    private static <S, T> ObjectConverter<S, T> findEquals(ObjectConverter<S, T> objectConverter, ObjectConverter<S, ? extends T> objectConverter2) {
        if (objectConverter instanceof FallbackConverter) {
            FallbackConverter fallbackConverter = (FallbackConverter)objectConverter;
            if ((objectConverter = ConverterRegistry.findEquals(fallbackConverter, fallbackConverter.primary)) == null) {
                objectConverter = ConverterRegistry.findEquals(fallbackConverter, fallbackConverter.fallback);
            }
        } else {
            objectConverter = objectConverter.equals(objectConverter2) ? objectConverter2 : null;
        }
        return objectConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <S, T> ObjectConverter<S, T> findEquals(SystemConverter<S, T> systemConverter) {
        ObjectConverter<S, T> objectConverter;
        Map<ClassPair<?, ?>, ObjectConverter<?, ?>> map = this.converters;
        synchronized (map) {
            objectConverter = this.get(systemConverter);
        }
        if (objectConverter != null && objectConverter.getSourceClass() == systemConverter.getSourceClass()) {
            return ConverterRegistry.findEquals(systemConverter, objectConverter);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public <S, T> void register(ObjectConverter<S, T> objectConverter) {
        ArgumentChecks.ensureNonNull("converter", objectConverter);
        if (objectConverter instanceof FallbackConverter) {
            FallbackConverter fallbackConverter = (FallbackConverter)objectConverter;
            this.register(fallbackConverter.primary);
            this.register(fallbackConverter.fallback);
            return;
        }
        Class<S> clazz = objectConverter.getSourceClass();
        Class<T> classArray = objectConverter.getTargetClass();
        Class<?> clazz2 = Classes.findCommonClass(clazz, classArray);
        ArgumentChecks.ensureNonNull("sourceClass", clazz);
        ArgumentChecks.ensureNonNull("targetClass", classArray);
        Map<ClassPair<?, ?>, ObjectConverter<?, ?>> map = this.converters;
        synchronized (map) {
            void var6_8;
            if (!this.isInitialized) {
                this.isInitialized = true;
                this.initialize();
            }
            Class<T> object = classArray;
            while (var6_8 != null && var6_8 != clazz2) {
                this.register(new ClassPair(clazz, var6_8), objectConverter);
                Class clazz3 = var6_8.getSuperclass();
            }
            for (Class<T> clazz4 : Classes.getAllInterfaces(classArray)) {
                if (clazz4.isAssignableFrom(clazz) || clazz4.getName().startsWith("java.lang.constant") || Cloneable.class.isAssignableFrom(clazz4) || clazz == Number.class && Comparable.class.isAssignableFrom(clazz4) || clazz == String.class && Iterable.class.isAssignableFrom(clazz4) || clazz4.isAssignableFrom(clazz)) continue;
                this.register(new ClassPair<S, T>(clazz, clazz4), objectConverter);
            }
        }
    }

    private <S, T> void register(ClassPair<S, T> classPair, ObjectConverter<S, ? extends T> objectConverter) {
        ObjectConverter<S, T> objectConverter2 = this.get(classPair);
        if (objectConverter2 != null) {
            if (objectConverter2.equals(objectConverter)) {
                return;
            }
            assert (objectConverter.getSourceClass() == classPair.sourceClass);
            if (objectConverter2.getSourceClass() == classPair.sourceClass) {
                boolean bl;
                boolean bl2 = ConverterRegistry.isExactlyFor(objectConverter2, classPair.targetClass);
                if (bl2 & !(bl = ConverterRegistry.isExactlyFor(objectConverter, classPair.targetClass))) {
                    return;
                }
                if (bl == bl2) {
                    objectConverter = FallbackConverter.merge(objectConverter2, objectConverter);
                    assert (classPair.targetClass.isAssignableFrom(objectConverter.getTargetClass())) : objectConverter;
                }
            }
        }
        this.put(classPair, objectConverter);
    }

    private static boolean isExactlyFor(ObjectConverter<?, ?> objectConverter, Class<?> clazz) {
        if (objectConverter.getTargetClass() != clazz) {
            return false;
        }
        if (objectConverter instanceof FallbackConverter) {
            FallbackConverter fallbackConverter = (FallbackConverter)objectConverter;
            return ConverterRegistry.isExactlyFor(fallbackConverter.primary, clazz) && ConverterRegistry.isExactlyFor(fallbackConverter.fallback, clazz);
        }
        return true;
    }

    public <S, T> ObjectConverter<S, T> findExact(Class<S> clazz, Class<T> clazz2) throws UnconvertibleObjectException {
        ObjectConverter<S, T> objectConverter = this.find(clazz, clazz2);
        if (objectConverter.getSourceClass() == clazz && objectConverter.getTargetClass() == clazz2) {
            return objectConverter;
        }
        throw new UnconvertibleObjectException(Errors.format((short)7, clazz, clazz2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S, T> ObjectConverter<? super S, ? extends T> find(Class<S> clazz, Class<T> clazz2) throws UnconvertibleObjectException {
        ClassPair<S, T> classPair = new ClassPair<S, T>(clazz, clazz2);
        Map<ClassPair<?, ?>, ObjectConverter<?, ?>> map = this.converters;
        synchronized (map) {
            Class<?> clazz3;
            ObjectConverter<S, T> objectConverter = this.get(classPair);
            if (objectConverter != null) {
                return objectConverter;
            }
            if (!this.isInitialized) {
                this.isInitialized = true;
                this.initialize();
                objectConverter = this.get(classPair);
                if (objectConverter != null) {
                    return objectConverter;
                }
            }
            ClassPair<S, T> classPair2 = classPair;
            while ((classPair2 = classPair2.parentSource()) != null) {
                objectConverter = this.get(classPair2);
                if (objectConverter == null) continue;
                this.put(classPair, objectConverter);
                return objectConverter;
            }
            if (!clazz.isInterface()) {
                for (Class<S> clazz4 : Classes.getAllInterfaces(clazz)) {
                    ObjectConverter<S, T> objectConverter2 = this.get(new ClassPair<S, T>(clazz4, clazz2));
                    if (objectConverter2 == null) continue;
                    if (objectConverter != null) {
                        Class<S> clazz5 = objectConverter.getSourceClass();
                        if (clazz4.isAssignableFrom(clazz5)) continue;
                        if (!clazz5.isAssignableFrom(clazz4)) {
                            objectConverter = null;
                            break;
                        }
                    }
                    objectConverter = objectConverter2;
                }
                if (objectConverter != null) {
                    this.put(classPair, objectConverter);
                    return objectConverter;
                }
            }
            if ((objectConverter = this.createConverter(clazz, clazz2)) != null) {
                this.put(classPair, objectConverter);
                return objectConverter;
            }
            Class<?> clazz6 = clazz.getComponentType();
            if (clazz6 != null && (clazz3 = clazz2.getComponentType()) != null) {
                objectConverter = new ArrayConverter<S, T>(clazz, clazz2, this.find(Numbers.primitiveToWrapper(clazz6), Numbers.primitiveToWrapper(clazz3)));
                this.put(classPair, objectConverter);
                return objectConverter;
            }
        }
        throw new UnconvertibleObjectException(Errors.format((short)7, clazz, clazz2));
    }

    protected <S, T> ObjectConverter<S, T> createConverter(Class<S> clazz, Class<T> clazz2) {
        if (clazz2.isAssignableFrom(clazz)) {
            return new IdentityConverter<S, T>(clazz, clazz2, null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        TreeTable treeTable = Column.createTable();
        TreeTable.Node node = treeTable.getRoot();
        node.setValue(Column.TARGET, this.getClass());
        Map<ClassPair<?, ?>, ObjectConverter<?, ?>> map = this.converters;
        synchronized (map) {
            for (Map.Entry<ClassPair<?, ?>, ObjectConverter<?, ?>> entry : this.converters.entrySet()) {
                TreeTable.Node node2 = node;
                ClassPair<?, ?> classPair = entry.getKey();
                ObjectConverter<?, ?> objectConverter = entry.getValue();
                if (objectConverter.getSourceClass() != classPair.sourceClass || objectConverter.getTargetClass() != classPair.targetClass) {
                    node2 = node2.newChild();
                    node2.setValue(Column.SOURCE, classPair.sourceClass);
                    node2.setValue(Column.TARGET, classPair.targetClass);
                }
                if (objectConverter instanceof FallbackConverter) {
                    ((FallbackConverter)objectConverter).toTree(node2.newChild(), true);
                    continue;
                }
                Column.toTree(objectConverter, node2);
            }
        }
        return Column.format(treeTable);
    }
}

