/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.util.jdbc;

import java.io.IOException;
import java.io.InputStream;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.database.utils.JDBCUtils;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCWorkspaceDataContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DBInitializerHelper {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.DBInitializerHelper");
    public static final String JCR_TABLE_PREFIX = "JCR_";

    public static String prepareScripts(JDBCDataContainerConfig containerConfig) throws IOException {
        String itemTableSuffix = DBInitializerHelper.getItemTableSuffix(containerConfig);
        String valueTableSuffix = DBInitializerHelper.getValueTableSuffix(containerConfig);
        String refTableSuffix = DBInitializerHelper.getRefTableSuffix(containerConfig);
        boolean isolatedDB = containerConfig.dbStructureType == JDBCDataContainerConfig.DatabaseStructureType.ISOLATED;
        return DBInitializerHelper.prepareScripts(containerConfig.initScriptPath, itemTableSuffix, valueTableSuffix, refTableSuffix, isolatedDB);
    }

    public static String prepareScripts(WorkspaceEntry wsEntry, String dialect) throws IOException, RepositoryConfigurationException {
        String itemTableSuffix = DBInitializerHelper.getItemTableSuffix(wsEntry);
        String valueTableSuffix = DBInitializerHelper.getValueTableSuffix(wsEntry);
        String refTableSuffix = DBInitializerHelper.getRefTableSuffix(wsEntry);
        JDBCDataContainerConfig.DatabaseStructureType dbType = DBInitializerHelper.getDatabaseType(wsEntry);
        boolean isolatedDB = dbType == JDBCDataContainerConfig.DatabaseStructureType.ISOLATED;
        String initScriptPath = DBInitializerHelper.scriptPath(dialect, dbType.isMultiDatabase());
        return DBInitializerHelper.prepareScripts(initScriptPath, itemTableSuffix, valueTableSuffix, refTableSuffix, isolatedDB);
    }

    private static String prepareScripts(String initScriptPath, String itemTableSuffix, String valueTableSuffix, String refTableSuffix, boolean isolatedDB) throws IOException {
        String scripts = IOUtil.getStreamContentAsString((InputStream)PrivilegedFileHelper.getResourceAsStream((String)initScriptPath));
        if (isolatedDB) {
            scripts = scripts.replace("MITEM", itemTableSuffix).replace("MVALUE", valueTableSuffix).replace("MREF", refTableSuffix);
        }
        return scripts;
    }

    public static String scriptPath(String dbDialect, boolean multiDb) {
        String suffix = multiDb ? "m" : "s";
        String sqlPath = null;
        sqlPath = dbDialect.startsWith("ORACLE") ? "/conf/storage/jcr-" + suffix + "jdbc.ora.sql" : (dbDialect.startsWith("PGSQL") ? "/conf/storage/jcr-" + suffix + "jdbc.pgsql.sql" : (dbDialect.equals("MYSQL") ? "/conf/storage/jcr-" + suffix + "jdbc.mysql.sql" : (dbDialect.equals("MYSQL-NDB") ? "/conf/storage/jcr-" + suffix + "jdbc.mysql-ndb.sql" : (dbDialect.equals("MYSQL-NDB-UTF8") ? "/conf/storage/jcr-" + suffix + "jdbc.mysql-ndb-utf8.sql" : (dbDialect.equals("MYSQL-MyISAM") ? "/conf/storage/jcr-" + suffix + "jdbc.mysql-myisam.sql" : (dbDialect.equals("MYSQL-UTF8") ? "/conf/storage/jcr-" + suffix + "jdbc.mysql-utf8.sql" : (dbDialect.equals("MYSQL-MyISAM-UTF8") ? "/conf/storage/jcr-" + suffix + "jdbc.mysql-myisam-utf8.sql" : (dbDialect.startsWith("MSSQL") ? "/conf/storage/jcr-" + suffix + "jdbc.mssql.sql" : (dbDialect.startsWith("DERBY") ? "/conf/storage/jcr-" + suffix + "jdbc.derby.sql" : (dbDialect.equals("DB2V8") ? "/conf/storage/jcr-" + suffix + "jdbc.db2v8.sql" : (dbDialect.startsWith("DB2") ? "/conf/storage/jcr-" + suffix + "jdbc.db2.sql" : (dbDialect.startsWith("SYBASE") ? "/conf/storage/jcr-" + suffix + "jdbc.sybase.sql" : (dbDialect.startsWith("INGRES") ? "/conf/storage/jcr-" + suffix + "jdbc.ingres.sql" : (dbDialect.startsWith("H2") ? "/conf/storage/jcr-" + suffix + "jdbc.h2.sql" : (dbDialect.startsWith("HSQLDB") ? "/conf/storage/jcr-" + suffix + "jdbc.sql" : "/conf/storage/jcr-" + suffix + "jdbc.sql")))))))))))))));
        return sqlPath;
    }

    public static String getRootNodeInitializeScript(JDBCDataContainerConfig containerConfig) {
        boolean multiDb = containerConfig.dbStructureType.isMultiDatabase();
        String itemTableName = DBInitializerHelper.getItemTableName(containerConfig);
        return DBInitializerHelper.getRootNodeInitializeScript(itemTableName, multiDb);
    }

    public static String getRootNodeInitializeScript(String itemTableName, boolean multiDb) {
        String singeDbScript = "insert into " + itemTableName + "(ID, PARENT_ID, NAME, CONTAINER_NAME, VERSION, I_CLASS, I_INDEX, N_ORDER_NUM) VALUES('" + Constants.ROOT_PARENT_UUID + "', '" + Constants.ROOT_PARENT_UUID + "', '__root_parent', '__root_parent_container', 0, 0, 0, 0)";
        String multiDbScript = "insert into " + itemTableName + "(ID, PARENT_ID, NAME, VERSION, I_CLASS, I_INDEX, N_ORDER_NUM) VALUES('" + Constants.ROOT_PARENT_UUID + "', '" + Constants.ROOT_PARENT_UUID + "', '__root_parent', 0, 0, 0, 0)";
        return multiDb ? multiDbScript : singeDbScript;
    }

    public static String getItemTableSuffix(WorkspaceEntry wsConfig) throws RepositoryConfigurationException {
        return DBInitializerHelper.getTableSuffix(DBInitializerHelper.getDatabaseType(wsConfig), DBInitializerHelper.getDBTableSuffix(wsConfig), "ITEM");
    }

    public static String getValueTableSuffix(WorkspaceEntry wsConfig) throws RepositoryConfigurationException {
        return DBInitializerHelper.getTableSuffix(DBInitializerHelper.getDatabaseType(wsConfig), DBInitializerHelper.getDBTableSuffix(wsConfig), "VALUE");
    }

    public static String getRefTableSuffix(WorkspaceEntry wsConfig) throws RepositoryConfigurationException {
        return DBInitializerHelper.getTableSuffix(DBInitializerHelper.getDatabaseType(wsConfig), DBInitializerHelper.getDBTableSuffix(wsConfig), "REF");
    }

    public static String getItemTableName(WorkspaceEntry wsConfig) throws RepositoryConfigurationException {
        return JCR_TABLE_PREFIX + DBInitializerHelper.getTableSuffix(DBInitializerHelper.getDatabaseType(wsConfig), DBInitializerHelper.getDBTableSuffix(wsConfig), "ITEM");
    }

    public static String getValueTableName(WorkspaceEntry wsConfig) throws RepositoryConfigurationException {
        return JCR_TABLE_PREFIX + DBInitializerHelper.getTableSuffix(DBInitializerHelper.getDatabaseType(wsConfig), DBInitializerHelper.getDBTableSuffix(wsConfig), "VALUE");
    }

    public static String getRefTableName(WorkspaceEntry wsConfig) throws RepositoryConfigurationException {
        return JCR_TABLE_PREFIX + DBInitializerHelper.getTableSuffix(DBInitializerHelper.getDatabaseType(wsConfig), DBInitializerHelper.getDBTableSuffix(wsConfig), "REF");
    }

    public static String getItemTableSuffix(JDBCDataContainerConfig containerConfig) {
        return DBInitializerHelper.getTableSuffix(containerConfig.dbStructureType, containerConfig.dbTableSuffix, "ITEM");
    }

    public static String getValueTableSuffix(JDBCDataContainerConfig containerConfig) {
        return DBInitializerHelper.getTableSuffix(containerConfig.dbStructureType, containerConfig.dbTableSuffix, "VALUE");
    }

    public static String getRefTableSuffix(JDBCDataContainerConfig containerConfig) {
        return DBInitializerHelper.getTableSuffix(containerConfig.dbStructureType, containerConfig.dbTableSuffix, "REF");
    }

    public static String getItemTableName(JDBCDataContainerConfig containerConfig) {
        return JCR_TABLE_PREFIX + DBInitializerHelper.getTableSuffix(containerConfig.dbStructureType, containerConfig.dbTableSuffix, "ITEM");
    }

    public static String getValueTableName(JDBCDataContainerConfig containerConfig) {
        return JCR_TABLE_PREFIX + DBInitializerHelper.getTableSuffix(containerConfig.dbStructureType, containerConfig.dbTableSuffix, "VALUE");
    }

    public static String getRefTableName(JDBCDataContainerConfig containerConfig) {
        return JCR_TABLE_PREFIX + DBInitializerHelper.getTableSuffix(containerConfig.dbStructureType, containerConfig.dbTableSuffix, "REF");
    }

    private static String getTableSuffix(JDBCDataContainerConfig.DatabaseStructureType dbType, String dbTableSuffix, String forTable) {
        Object tableSuffix = "";
        switch (dbType) {
            case MULTI: {
                tableSuffix = "M" + forTable;
                break;
            }
            case SINGLE: {
                tableSuffix = "S" + forTable;
                break;
            }
            case ISOLATED: {
                tableSuffix = forTable.substring(0, 1) + dbTableSuffix;
            }
        }
        return tableSuffix;
    }

    public static String getObjectScript(String objectName, boolean multiDb, String dialect, WorkspaceEntry wsEntry) throws RepositoryConfigurationException, IOException {
        String scripts = DBInitializerHelper.prepareScripts(wsEntry, dialect);
        String sql = null;
        for (String query : JDBCUtils.splitWithSQLDelimiter((String)scripts)) {
            String q = JDBCUtils.cleanWhitespaces((String)query);
            if (!q.contains(objectName)) continue;
            if (sql != null) {
                throw new RepositoryConfigurationException("Can't find unique script for object creation. Object name: " + objectName);
            }
            sql = q;
        }
        if (sql != null) {
            return sql;
        }
        throw new RepositoryConfigurationException("Script for object creation is not found. Object name: " + objectName);
    }

    public static JDBCDataContainerConfig.DatabaseStructureType getDatabaseType(WorkspaceEntry wsConfig) throws RepositoryConfigurationException {
        try {
            if (wsConfig.getContainer().getParameterBoolean("multi-db").booleanValue()) {
                return JDBCDataContainerConfig.DatabaseStructureType.MULTI;
            }
            return JDBCDataContainerConfig.DatabaseStructureType.SINGLE;
        }
        catch (Exception e) {
            String dbStructureType = wsConfig.getContainer().getParameterValue("db-structure-type").toUpperCase();
            return JDBCDataContainerConfig.DatabaseStructureType.valueOf(dbStructureType);
        }
    }

    public static String getDBTableSuffix(WorkspaceEntry wsConfig) {
        String defaultSuffix = DBInitializerHelper.replaceIncorrectChars(wsConfig.getName());
        String suffix = wsConfig.getContainer().getParameterValue("db-tablename-suffix", defaultSuffix);
        return suffix;
    }

    private static String replaceIncorrectChars(String workspaceName) {
        return workspaceName.replaceAll("[^A-Za-z_0-9]", "").toUpperCase();
    }

    public static String getDatabaseDialect(WorkspaceEntry wsConfig) {
        String dialect = wsConfig.getContainer().getParameterValue("dialect", "AUTO");
        return dialect.toUpperCase();
    }

    public static boolean useSequenceForOrderNumber(WorkspaceEntry wsConfig, String dbDialect) throws RepositoryConfigurationException {
        try {
            if (wsConfig.getContainer().getParameterValue("use-sequence-for-order-number", "auto").equalsIgnoreCase("auto")) {
                return JDBCWorkspaceDataContainer.useSequenceDefaultValue();
            }
            return wsConfig.getContainer().getParameterBoolean("use-sequence-for-order-number");
        }
        catch (RepositoryConfigurationException e) {
            return JDBCWorkspaceDataContainer.useSequenceDefaultValue();
        }
    }
}

