/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype.registration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataImpl;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionData;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.AbstractItemDefinitionAccessProvider;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.NodeDefinitionAccessProvider;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.NodeTypeReadException;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.PropertyDefinitionAccessProvider;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;

public class NodeTypeDefinitionAccessProvider
extends AbstractItemDefinitionAccessProvider {
    private PropertyDefinitionAccessProvider propertyDefinitionAccessProvider;
    private NodeDefinitionAccessProvider nodeDefinitionAccessProvider;

    public NodeTypeDefinitionAccessProvider(DataManager dataManager) {
        super(dataManager);
        this.propertyDefinitionAccessProvider = new PropertyDefinitionAccessProvider(dataManager);
        this.nodeDefinitionAccessProvider = new NodeDefinitionAccessProvider(dataManager);
    }

    public NodeTypeData read(NodeData nodeData) throws RepositoryException {
        return this.readNow(nodeData);
    }

    public NodeTypeData readNow(NodeData nodeData) throws RepositoryException {
        List<PropertyData> props = this.dataManager.getChildPropertiesData(nodeData);
        HashMap<InternalQName, PropertyData> mapProps = new HashMap<InternalQName, PropertyData>();
        for (PropertyData propertyData : props) {
            mapProps.put(propertyData.getQPath().getName(), propertyData);
        }
        InternalQName name = this.readMandatoryName(nodeData, (PropertyData)mapProps.get((Object)Constants.JCR_NODETYPENAME), Constants.JCR_NODETYPENAME);
        InternalQName primaryItemName = this.readName(nodeData, (PropertyData)mapProps.get((Object)Constants.JCR_PRIMARYITEMNAME), Constants.JCR_PRIMARYITEMNAME);
        boolean mixin = this.readMandatoryBoolean(nodeData, (PropertyData)mapProps.get((Object)Constants.JCR_ISMIXIN), Constants.JCR_ISMIXIN);
        boolean hasOrderableChildNodes = this.readMandatoryBoolean(nodeData, (PropertyData)mapProps.get((Object)Constants.JCR_HASORDERABLECHILDNODES), Constants.JCR_HASORDERABLECHILDNODES);
        InternalQName[] declaredSupertypeNames = this.readNames(nodeData, (PropertyData)mapProps.get((Object)Constants.JCR_SUPERTYPES), Constants.JCR_SUPERTYPES);
        ArrayList<PropertyDefinitionData> propertyDefinitionDataList = new ArrayList<PropertyDefinitionData>();
        ArrayList<NodeDefinitionData> nodeDefinitionDataList = new ArrayList<NodeDefinitionData>();
        List<NodeData> childDefinitions = this.dataManager.getChildNodesData(nodeData);
        for (NodeData childDefinition : childDefinitions) {
            List<PropertyData> childrenProps = this.dataManager.getChildPropertiesData(childDefinition);
            if (Constants.NT_PROPERTYDEFINITION.equals((Object)childDefinition.getPrimaryTypeName())) {
                propertyDefinitionDataList.add(this.propertyDefinitionAccessProvider.read(childDefinition, childrenProps, name));
                continue;
            }
            if (!Constants.NT_CHILDNODEDEFINITION.equals((Object)childDefinition.getPrimaryTypeName())) continue;
            nodeDefinitionDataList.add(this.nodeDefinitionAccessProvider.read(childDefinition, childrenProps, name));
        }
        return new NodeTypeDataImpl(name, primaryItemName, mixin, hasOrderableChildNodes, declaredSupertypeNames, propertyDefinitionDataList.toArray(new PropertyDefinitionData[propertyDefinitionDataList.size()]), nodeDefinitionDataList.toArray(new NodeDefinitionData[nodeDefinitionDataList.size()]));
    }

    public NodeDefinitionData[] readNodeDefinitions(NodeData nodeData) throws NodeTypeReadException, RepositoryException {
        InternalQName name = null;
        List<NodeData> childDefinitions = this.dataManager.getChildNodesData(nodeData);
        if (childDefinitions.size() <= 0) {
            return new NodeDefinitionData[0];
        }
        name = this.readMandatoryName(nodeData, null, Constants.JCR_NODETYPENAME);
        ArrayList<NodeDefinitionData> nodeDefinitionDataList = new ArrayList<NodeDefinitionData>();
        for (NodeData childDefinition : childDefinitions) {
            if (!Constants.NT_CHILDNODEDEFINITION.equals((Object)childDefinition.getPrimaryTypeName())) continue;
            nodeDefinitionDataList.add(this.nodeDefinitionAccessProvider.read(childDefinition, name));
        }
        return nodeDefinitionDataList.toArray(new NodeDefinitionData[nodeDefinitionDataList.size()]);
    }

    public PropertyDefinitionData[] readPropertyDefinitions(NodeData nodeData) throws NodeTypeReadException, RepositoryException {
        List<NodeData> childDefinitions = this.dataManager.getChildNodesData(nodeData);
        InternalQName name = null;
        if (childDefinitions.size() <= 0) {
            return new PropertyDefinitionData[0];
        }
        name = this.readMandatoryName(nodeData, null, Constants.JCR_NODETYPENAME);
        ArrayList<PropertyDefinitionData> propertyDefinitionDataList = new ArrayList<PropertyDefinitionData>();
        for (NodeData childDefinition : childDefinitions) {
            if (!Constants.NT_PROPERTYDEFINITION.equals((Object)childDefinition.getPrimaryTypeName())) continue;
            propertyDefinitionDataList.add(this.propertyDefinitionAccessProvider.read(childDefinition, name));
        }
        return propertyDefinitionDataList.toArray(new PropertyDefinitionData[propertyDefinitionDataList.size()]);
    }

    public void write(PlainChangesLog changesLog, NodeData nodeTypeStorageRoot, NodeTypeData nodeType) throws NodeTypeReadException, RepositoryException {
        int i;
        TransientNodeData ntNode = TransientNodeData.createNodeData(nodeTypeStorageRoot, nodeType.getName(), Constants.NT_NODETYPE);
        changesLog.add(ItemState.createAddedState(ntNode));
        this.writeName(changesLog, ntNode, Constants.JCR_PRIMARYTYPE, ntNode.getPrimaryTypeName());
        this.writeName(changesLog, ntNode, Constants.JCR_NODETYPENAME, nodeType.getName());
        this.writeBoolean(changesLog, ntNode, Constants.JCR_ISMIXIN, nodeType.isMixin());
        this.writeBoolean(changesLog, ntNode, Constants.JCR_HASORDERABLECHILDNODES, nodeType.hasOrderableChildNodes());
        if (nodeType.getPrimaryItemName() != null) {
            this.writeName(changesLog, ntNode, Constants.JCR_PRIMARYITEMNAME, nodeType.getPrimaryItemName());
        }
        if (nodeType.getDeclaredSupertypeNames() != null && nodeType.getDeclaredSupertypeNames().length > 0) {
            this.writeNames(changesLog, ntNode, Constants.JCR_SUPERTYPES, nodeType.getDeclaredSupertypeNames());
        }
        for (i = 0; i < nodeType.getDeclaredPropertyDefinitions().length; ++i) {
            this.propertyDefinitionAccessProvider.write(changesLog, ntNode, nodeType.getDeclaredPropertyDefinitions()[i], i + 1);
        }
        for (i = 0; i < nodeType.getDeclaredChildNodeDefinitions().length; ++i) {
            this.nodeDefinitionAccessProvider.write(changesLog, ntNode, nodeType.getDeclaredChildNodeDefinitions()[i], i + 1);
        }
    }
}

