/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;

public final class ScoreNode {
    private final String id;
    private final float score;
    private final int doc;

    public ScoreNode(String id, float score) {
        this(id, score, -1);
    }

    public ScoreNode(String id, float score, int doc) {
        this.id = id;
        this.score = score;
        this.doc = doc;
    }

    public String getNodeId() {
        return this.id;
    }

    public float getScore() {
        return this.score;
    }

    public int getDoc(IndexReader reader) throws IOException {
        if (this.doc == -1) {
            try (TermDocs docs = reader.termDocs(new Term(FieldNames.UUID, this.id.toString()));){
                if (docs.next()) {
                    int n = docs.doc();
                    return n;
                }
                throw new IOException("Node with id " + this.id + " not found in index");
            }
        }
        return this.doc;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.id.toString());
        sb.append("(");
        if (this.doc != -1) {
            sb.append(this.doc);
        } else {
            sb.append("?");
        }
        sb.append(")");
        return sb.toString();
    }
}

