/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.storage.value;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;
import org.exoplatform.services.jcr.storage.value.ValueStorageURLConnection;

public class ValueStorageURLStreamHandler
extends URLStreamHandler {
    private static Pattern PATH_SYNTAX = Pattern.compile("/([^/]+)/([^/]+)/([^/]+)/(.*)");
    public static final String PROTOCOL = "vs";
    public static final ValueStorageURLStreamHandler INSTANCE = new ValueStorageURLStreamHandler();

    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        if (!u.getProtocol().equals(PROTOCOL)) {
            throw new MalformedURLException("Only the protocol vs is supported");
        }
        if (u.getHost() != null) {
            throw new MalformedURLException("The host will be automatically defined, so it is not expected");
        }
        String file = u.getFile();
        Matcher m = PATH_SYNTAX.matcher(file);
        if (!m.matches()) {
            throw new MalformedURLException("The syntax of the path of the value storage URL doesn't match with the expected syntax which is '/{repository}/{workspace}/{value-storage-id}/{resource-id}'");
        }
        ValueStorageURLConnection connection = this.createURLConnection(u, m.group(1), m.group(2), m.group(3));
        connection.setIdResource(m.group(4));
        return connection;
    }

    protected ValueStorageURLConnection createURLConnection(URL u, String repository, String workspace, String valueStorageId) throws IOException {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        if (repositoryService == null) {
            throw new IOException("Could not find the repository service");
        }
        try {
            ManageableRepository repo = repositoryService.getRepository(repository);
            WorkspaceContainerFacade workspaceContainer = repo.getWorkspaceContainer(workspace);
            ValueStoragePluginProvider provider = (ValueStoragePluginProvider)workspaceContainer.getComponent(ValueStoragePluginProvider.class);
            if (provider == null) {
                throw new IOException("Could not find the ValueStoragePluginProvider for " + repository + "/" + workspace);
            }
            return provider.createURLConnection(valueStorageId, u);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Could not get ValueStorageURLConnection from the value storage " + repository + "/" + workspace + "/" + valueStorageId, e);
        }
    }

    @Override
    protected void parseURL(URL u, String spec, int start, int limit) {
        this.setURL(u, PROTOCOL, null, -1, null, null, spec.substring(start, limit), null, null);
    }
}

