/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import java.util.List;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.NestedPointFeatureCollection;
import ucar.nc2.ft.NestedPointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.StationProfileFeature;
import ucar.nc2.ft.StationProfileFeatureCollection;
import ucar.nc2.ft.point.MultipleNestedPointCollectionImpl;
import ucar.nc2.ft.point.NestedPointCollectionIteratorFiltered;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.StationHelper;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

public abstract class StationProfileCollectionImpl
extends MultipleNestedPointCollectionImpl
implements StationProfileFeatureCollection {
    private volatile StationHelper stationHelper;
    protected NestedPointFeatureCollectionIterator localIterator;

    public StationProfileCollectionImpl(String name, DateUnit timeUnit, String altUnits) {
        super(name, timeUnit, altUnits, FeatureType.STATION_PROFILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StationHelper getStationHelper() {
        if (this.stationHelper == null) {
            StationProfileCollectionImpl stationProfileCollectionImpl = this;
            synchronized (stationProfileCollectionImpl) {
                if (this.stationHelper == null) {
                    try {
                        this.stationHelper = this.createStationHelper();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        assert (this.stationHelper != null) : "We screwed this up.";
        return this.stationHelper;
    }

    protected abstract StationHelper createStationHelper() throws IOException;

    @Override
    public List<StationFeature> getStationFeatures() throws IOException {
        return this.getStationHelper().getStationFeatures();
    }

    @Override
    public List<Station> getStations() {
        return this.getStationHelper().getStations();
    }

    @Override
    public List<Station> getStations(List<String> stnNames) {
        return this.getStationHelper().getStations(stnNames);
    }

    @Override
    public List<Station> getStations(LatLonRect boundingBox) throws IOException {
        return this.getStationHelper().getStations(boundingBox);
    }

    @Override
    public Station getStation(String name) {
        return this.getStationHelper().getStation(name);
    }

    @Override
    public LatLonRect getBoundingBox() {
        return this.getStationHelper().getBoundingBox();
    }

    @Override
    public StationProfileCollectionImpl subset(List<Station> stations) throws IOException {
        if (stations == null) {
            return this;
        }
        return new StationProfileFeatureCollectionSubset(this, stations);
    }

    @Override
    public StationProfileCollectionImpl subset(LatLonRect boundingBox) throws IOException {
        return this.subset((List)this.getStations(boundingBox));
    }

    @Override
    public StationProfileFeature getStationProfileFeature(Station s) throws IOException {
        return (StationProfileFeature)s;
    }

    @Override
    public PointFeatureCollectionIterator getPointFeatureCollectionIterator(int bufferSize) throws IOException {
        throw new UnsupportedOperationException("StationProfileFeatureCollection does not implement getPointFeatureCollectionIterator()");
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.localIterator == null) {
            this.resetIteration();
        }
        return this.localIterator.hasNext();
    }

    @Override
    public StationProfileFeature next() throws IOException {
        return (StationProfileFeature)this.localIterator.next();
    }

    @Override
    public void resetIteration() throws IOException {
        this.localIterator = this.getNestedPointFeatureCollectionIterator(-1);
    }

    public int compareTo(Station so) {
        return this.name.compareTo(so.getName());
    }

    private static class StationProfileFeatureCollectionSubset
    extends StationProfileCollectionImpl {
        private final StationProfileCollectionImpl from;
        private final List<Station> stations;

        StationProfileFeatureCollectionSubset(StationProfileCollectionImpl from, List<Station> stations) throws IOException {
            super(from.getName(), from.getTimeUnit(), from.getAltUnits());
            this.from = from;
            this.stations = stations;
        }

        @Override
        protected StationHelper createStationHelper() throws IOException {
            return this.from.getStationHelper().subset(this.stations);
        }

        @Override
        public NestedPointFeatureCollectionIterator getNestedPointFeatureCollectionIterator(int bufferSize) throws IOException {
            return new NestedPointCollectionIteratorFiltered(this.from.getNestedPointFeatureCollectionIterator(bufferSize), new Filter());
        }

        private class Filter
        implements NestedPointFeatureCollectionIterator.Filter {
            private Filter() {
            }

            @Override
            public boolean filter(NestedPointFeatureCollection pointFeatureCollection) {
                StationProfileFeature stationFeature = (StationProfileFeature)pointFeatureCollection;
                return StationProfileFeatureCollectionSubset.this.getStationHelper().getStation(stationFeature.getName()) != null;
            }
        }
    }
}

