/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.config;

import java.util.List;
import org.exoplatform.services.jcr.config.MappedParametrizedObjectEntry;
import org.exoplatform.services.jcr.config.SimpleParameterEntry;
import org.exoplatform.services.jcr.config.SystemParameterUpdater;
import org.exoplatform.services.jcr.config.SystemParametersPersistenceConfigurator;
import org.exoplatform.services.jcr.config.WorkspaceEntry;

public abstract class ExtendedMappedParametrizedObjectEntry
extends MappedParametrizedObjectEntry {
    private SystemParameterUpdater systemParameterUpdater;
    private String componentName;

    public ExtendedMappedParametrizedObjectEntry(String componentName) {
        this.componentName = componentName;
    }

    public ExtendedMappedParametrizedObjectEntry(String type, List<SimpleParameterEntry> parameters, String componentName) {
        super(type, parameters);
        this.componentName = componentName;
    }

    public void initSystemParameterUpdater(WorkspaceEntry workspaceEntry, SystemParametersPersistenceConfigurator sppc) {
        this.systemParameterUpdater = new SystemParameterUpdater(this, sppc, this.componentName, workspaceEntry);
        this.systemParameterUpdater.updateSystemParameters();
    }

    public SystemParameterUpdater getSystemParameterUpdater() {
        return this.systemParameterUpdater;
    }

    @Override
    public void setParameters(List<SimpleParameterEntry> parameters) {
        super.setParameters(parameters);
        if (this.systemParameterUpdater != null) {
            this.systemParameterUpdater.setParameters(this);
        }
    }

    @Override
    public void putParameterValue(String name, String value) {
        if (this.systemParameterUpdater != null && this.systemParameterUpdater.isAlreadyUpdated(name)) {
            return;
        }
        super.putParameterValue(name, value);
    }
}

