/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import org.apache.sis.internal.referencing.Formulas;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.AuthalicConversion;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;

public class LambertAzimuthalEqualArea
extends AuthalicConversion {
    private static final long serialVersionUID = 7419101460426922558L;
    private final double sin\u03b20;
    private final double cos\u03b20;
    private final boolean polar;

    public LambertAzimuthalEqualArea(OperationMethod operationMethod, Parameters parameters) {
        this(LambertAzimuthalEqualArea.initializer(operationMethod, parameters));
    }

    private static Initializer initializer(OperationMethod operationMethod, Parameters parameters) {
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> enumMap = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        enumMap.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, org.apache.sis.internal.referencing.provider.LambertAzimuthalEqualArea.LONGITUDE_OF_ORIGIN);
        enumMap.put(NormalizedProjection.ParameterRole.FALSE_EASTING, org.apache.sis.internal.referencing.provider.LambertAzimuthalEqualArea.FALSE_EASTING);
        enumMap.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, org.apache.sis.internal.referencing.provider.LambertAzimuthalEqualArea.FALSE_NORTHING);
        return new Initializer(operationMethod, parameters, enumMap, null);
    }

    private LambertAzimuthalEqualArea(Initializer initializer) {
        super(initializer, null);
        double d = Math.toRadians(initializer.getAndStore(org.apache.sis.internal.referencing.provider.LambertAzimuthalEqualArea.LATITUDE_OF_ORIGIN));
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        this.polar = Math.abs(d2) == 1.0;
        this.sin\u03b20 = this.sin\u03b2(d2);
        this.cos\u03b20 = Math.sqrt(1.0 - this.sin\u03b20 * this.sin\u03b20);
        MatrixSIS matrixSIS = this.getContextualParameters().getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        if (this.polar) {
            DoubleDouble doubleDouble = initializer.axisLengthRatio();
            matrixSIS.convertBefore(0, (Number)doubleDouble, null);
            matrixSIS.convertBefore(1, (Number)doubleDouble, null);
            if (d > 0.0) {
                MatrixSIS matrixSIS2 = this.getContextualParameters().getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
                matrixSIS2.convertBefore(1, -1, null);
                matrixSIS.convertBefore(1, -1, null);
            }
        } else {
            double d4 = d3 / (Math.sqrt(1.0 - this.eccentricitySquared * (d2 * d2)) * this.cos\u03b20);
            double d5 = (1.0 - this.eccentricitySquared) * this.qmPolar / 2.0;
            matrixSIS.convertBefore(0, d4, null);
            matrixSIS.convertBefore(1, d5 / d4, null);
        }
    }

    LambertAzimuthalEqualArea(LambertAzimuthalEqualArea lambertAzimuthalEqualArea) {
        super(lambertAzimuthalEqualArea);
        this.sin\u03b20 = lambertAzimuthalEqualArea.sin\u03b20;
        this.cos\u03b20 = lambertAzimuthalEqualArea.cos\u03b20;
        this.polar = lambertAzimuthalEqualArea.polar;
    }

    @Override
    final String[] getInternalParameterNames() {
        return new String[]{"\u03b2\u2080"};
    }

    @Override
    final double[] getInternalParameterValues() {
        return new double[]{Math.asin(this.sin\u03b20)};
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = Math.sin(d);
        double d4 = Math.cos(d);
        double d5 = Math.sin(d2);
        if (!this.polar) {
            double d6;
            double d7 = this.sin\u03b2(d5);
            double d8 = this.sin\u03b20 * d7 + this.cos\u03b20 * (d6 = Math.sqrt(1.0 - d7 * d7)) * d4 + 1.0;
            double d9 = Math.sqrt(2.0 / d8);
            if (d9 == Double.POSITIVE_INFINITY) {
                d9 = Double.NaN;
            }
            double d10 = d6 * d3;
            double d11 = this.cos\u03b20 * d7 - this.sin\u03b20 * d6 * d4;
            if (dArray2 != null) {
                dArray2[n2] = d9 * d10;
                dArray2[n2 + 1] = d9 * d11;
            }
            if (!bl) {
                return null;
            }
            double d12 = this.dqm_d\u03c6(d5, Math.cos(d2)) / this.qmPolar;
            double d13 = -d12 * (d7 / d6);
            double d14 = d13 * d4;
            double d15 = this.sin\u03b20 * d10;
            double d16 = this.cos\u03b20 * d10 / (2.0 * d8);
            double d17 = this.cos\u03b20 * d12 - this.sin\u03b20 * d14;
            double d18 = -(this.sin\u03b20 * d12 + this.cos\u03b20 * d14) / (2.0 * d8);
            return new Matrix2(d9 * (d4 + d16 * d3) * d6, d9 * (d13 + d18 * d6) * d3, d9 * (d15 + d16 * d11), d9 * (d17 + d18 * d11));
        }
        double d19 = Math.sqrt(this.qmPolar + this.qm(d5));
        if (d5 == 1.0) {
            d19 = Double.NaN;
        }
        double d20 = d19 * d3;
        double d21 = d19 * d4;
        if (dArray2 != null) {
            dArray2[n2] = d20;
            dArray2[n2 + 1] = d21;
        }
        if (!bl) {
            return null;
        }
        double d22 = this.dqm_d\u03c6(d5, Math.cos(d2)) / (2.0 * d19);
        return new Matrix2(d21, d22 * d3, -d20, d22 * d4);
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d;
        double d2 = dArray[n];
        double d3 = dArray[n + 1];
        if (this.polar) {
            d = (d2 * d2 + d3 * d3) / this.qmPolar - 1.0;
        } else {
            double d4 = Formulas.fastHypot(d2, d3);
            double d5 = 2.0 * Math.asin(d4 / 2.0);
            double d6 = Math.cos(d5);
            double d7 = Math.sin(d5);
            double d8 = d3 * d7;
            d = d6 * this.sin\u03b20;
            if (d6 != 1.0) {
                d += d8 * this.cos\u03b20 / d4;
            }
            d3 = d4 * d6 * this.cos\u03b20 - d8 * this.sin\u03b20;
            d2 *= d7;
        }
        dArray2[n2] = Math.atan2(d2, d3);
        dArray2[n2 + 1] = this.isSpherical ? Math.asin(d) : this.\u03c6(d);
    }
}

