/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.query.lucene.AbstractFieldComparator;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldComparatorBase;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldSelectors;
import org.exoplatform.services.jcr.impl.core.query.lucene.NamespaceMappings;
import org.exoplatform.services.jcr.impl.core.query.lucene.SharedFieldCache;
import org.exoplatform.services.jcr.impl.core.query.lucene.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class SharedFieldComparatorSource
extends FieldComparatorSource {
    protected static Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.SharedFieldSortComparator");
    private static final long serialVersionUID = -5803240954874585429L;
    protected final String field;
    protected final ItemDataConsumer ism;
    protected final LocationFactory locationFactory;
    protected final NamespaceMappings nsMappings;

    public SharedFieldComparatorSource(String fieldname, ItemDataConsumer ism, NamespaceMappings nsMappings) {
        this.field = fieldname;
        this.ism = ism;
        this.locationFactory = new LocationFactory(nsMappings);
        this.nsMappings = nsMappings;
    }

    public FieldComparator<?> newComparator(String propertyName, int numHits, int sortPos, boolean reversed) throws IOException {
        try {
            QPath path = this.locationFactory.parseJCRPath(propertyName).getInternalPath();
            SimpleFieldComparator simple = (SimpleFieldComparator)this.createSimpleComparator(numHits, path);
            if (path.getEntries().length == 1) {
                return simple;
            }
            return this.createCompoundComparator(numHits, path, simple);
        }
        catch (IllegalNameException e) {
            throw Util.createIOException(e);
        }
        catch (RepositoryException e) {
            throw Util.createIOException(e);
        }
    }

    protected FieldComparator<?> createCompoundComparator(int numHits, QPath path, SimpleFieldComparator simple) {
        return new CompoundScoreFieldComparator(new FieldComparator[]{simple, new RelPathFieldComparator(path, numHits)}, numHits);
    }

    protected FieldComparator<?> createSimpleComparator(int numHits, QPath path) throws IllegalNameException {
        return new SimpleFieldComparator(this.nsMappings.translatePath(path), this.field, numHits);
    }

    private ItemData getItemData(NodeData parent, QPathEntry name, ItemType itemType) throws RepositoryException {
        if (name.getName().equals("..") && name.getNamespace().equals("")) {
            if (parent.getIdentifier().equals("00exo0jcr0root0uuid0000000000000")) {
                return null;
            }
            return this.ism.getItemData(parent.getParentIdentifier());
        }
        return this.ism.getItemData(parent, name, itemType);
    }

    private ItemData getItemData(NodeData parent, QPath relPath, ItemType itemType) throws RepositoryException {
        QPathEntry[] relPathEntries = relPath.getEntries();
        ItemData item = parent;
        for (int i = 0; i < relPathEntries.length && (item = i == relPathEntries.length - 1 ? this.getItemData(parent, relPathEntries[i], itemType) : this.getItemData(parent, relPathEntries[i], ItemType.UNKNOWN)) != null; ++i) {
            if (item.isNode()) {
                parent = (NodeData)item;
                continue;
            }
            if (i >= relPathEntries.length - 1) continue;
            throw new IllegalPathException("Path can not contains a property as the intermediate element");
        }
        return item;
    }

    static class SimpleFieldComparator
    extends AbstractFieldComparator {
        protected SharedFieldCache.ValueIndex[] indexes;
        private final String propertyName;
        private final String fieldName;

        public SimpleFieldComparator(String propertyName, String fieldName, int numHits) {
            super(numHits);
            this.propertyName = propertyName;
            this.fieldName = fieldName;
        }

        @Override
        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            super.setNextReader(reader, docBase);
            this.indexes = new SharedFieldCache.ValueIndex[this.readers.size()];
            String namedValue = FieldNames.createNamedValue(this.propertyName, "");
            for (int i = 0; i < this.readers.size(); ++i) {
                IndexReader r = (IndexReader)this.readers.get(i);
                this.indexes[i] = SharedFieldCache.INSTANCE.getValueIndex(r, this.fieldName, namedValue);
            }
        }

        @Override
        protected Comparable<?> sortValue(int doc) {
            int idx = this.readerIndex(doc);
            return this.indexes[idx].getValue(doc - this.starts[idx]);
        }
    }

    static class CompoundScoreFieldComparator
    extends AbstractFieldComparator {
        private final FieldComparator<?>[] fieldComparators;

        public CompoundScoreFieldComparator(FieldComparator<?>[] fieldComparators, int numHits) {
            super(numHits);
            this.fieldComparators = fieldComparators;
        }

        @Override
        public Comparable<?> sortValue(int doc) {
            for (FieldComparator<?> fieldComparator : this.fieldComparators) {
                Comparable<?> c;
                if (!(fieldComparator instanceof FieldComparatorBase) || (c = ((FieldComparatorBase)fieldComparator).sortValue(doc)) == null) continue;
                return c;
            }
            return null;
        }

        @Override
        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            for (FieldComparator<?> fieldComparator : this.fieldComparators) {
                fieldComparator.setNextReader(reader, docBase);
            }
        }
    }

    final class RelPathFieldComparator
    extends AbstractFieldComparator {
        private final QPath relPath;

        public RelPathFieldComparator(QPath relPath, int numHits) {
            super(numHits);
            this.relPath = relPath;
        }

        @Override
        protected Comparable<?> sortValue(int doc) {
            try {
                int idx = this.readerIndex(doc);
                IndexReader reader = (IndexReader)this.readers.get(idx);
                Document document = reader.document(doc - this.starts[idx], FieldSelectors.UUID);
                String uuid = document.get(FieldNames.UUID);
                ItemData parent = SharedFieldComparatorSource.this.ism.getItemData(uuid);
                if (!parent.isNode()) {
                    throw new InvalidItemStateException();
                }
                ItemData property = SharedFieldComparatorSource.this.getItemData((NodeData)parent, this.relPath, ItemType.PROPERTY);
                if (property != null) {
                    if (property.isNode()) {
                        throw new InvalidItemStateException();
                    }
                    PropertyData propertyData = (PropertyData)property;
                    List<ValueData> values = propertyData.getValues();
                    if (values.size() > 0) {
                        return Util.getComparable(values.get(0), propertyData.getType());
                    }
                }
                return null;
            }
            catch (RepositoryException ignore) {
                LOG.error((Object)ignore.getLocalizedMessage(), (Throwable)ignore);
            }
            catch (CorruptIndexException ignore) {
                LOG.error((Object)ignore.getLocalizedMessage(), (Throwable)ignore);
            }
            catch (IOException ignore) {
                LOG.error((Object)ignore.getLocalizedMessage(), (Throwable)ignore);
            }
            catch (IllegalStateException ignore) {
                LOG.error((Object)ignore.getLocalizedMessage(), (Throwable)ignore);
            }
            catch (IllegalNameException ignore) {
                LOG.error((Object)ignore.getLocalizedMessage(), (Throwable)ignore);
            }
            return null;
        }
    }
}

