/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage.j2d;

import java.awt.Color;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.apache.sis.coverage.Category;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.opengis.util.InternationalString;

final class ColorsForRange
implements Comparable<ColorsForRange> {
    final CharSequence name;
    NumberRange<?> sampleRange;
    private final Color[] colors;
    final boolean isData;

    ColorsForRange(Category category, Function<Category, Color[]> function) {
        InternationalString internationalString = category.getName();
        this.name = internationalString != null ? internationalString : this.sampleRange.toString();
        this.sampleRange = category.getSampleRange();
        this.colors = function.apply(category);
        this.isData = category.isQuantitative();
    }

    ColorsForRange(CharSequence charSequence, NumberRange<?> numberRange, Color[] colorArray, boolean bl) {
        ArgumentChecks.ensureNonNull((String)"sampleRange", numberRange);
        this.name = charSequence != null ? charSequence : numberRange.toString();
        this.sampleRange = numberRange;
        this.colors = colorArray;
        this.isData = bl;
    }

    static ColorsForRange[] list(Collection<Map.Entry<NumberRange<?>, Color[]>> collection) {
        Object[] objectArray = new ColorsForRange[collection.size()];
        int n = 0;
        for (Map.Entry<NumberRange<?>, Color[]> entry : collection) {
            objectArray[n++] = new ColorsForRange(null, entry.getKey(), entry.getValue(), true);
        }
        return (ColorsForRange[])ArraysExt.resize((Object[])objectArray, (int)n);
    }

    public String toString() {
        return this.name.toString();
    }

    @Override
    public int compareTo(ColorsForRange colorsForRange) {
        return this.getAlpha() - colorsForRange.getAlpha();
    }

    private int getAlpha() {
        int n = 0;
        if (this.colors != null) {
            for (int i = 0; i < this.colors.length; ++i) {
                int n2 = this.colors[i].getAlpha();
                if (n2 <= n) continue;
                if (n2 >= 255) {
                    return 255;
                }
                n = n2;
            }
        }
        return n;
    }

    final int[] toARGB() {
        if (this.colors != null) {
            int n = 0;
            int[] nArray = new int[this.colors.length];
            for (int i = 0; i < nArray.length; ++i) {
                Color color = this.colors[i];
                if (color == null) continue;
                int n2 = color.getRGB();
                n |= n2;
                nArray[i] = n2;
            }
            if ((n & 0xFF000000) != 0) {
                return nArray;
            }
        }
        return ArraysExt.EMPTY_INT;
    }
}

