/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lemmatizer;

import opennlp.tools.lemmatizer.DefaultLemmatizerContextGenerator;
import opennlp.tools.lemmatizer.DefaultLemmatizerSequenceValidator;
import opennlp.tools.lemmatizer.LemmatizerContextGenerator;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.SequenceValidator;
import opennlp.tools.util.ext.ExtensionLoader;

public class LemmatizerFactory
extends BaseToolFactory {
    public static LemmatizerFactory create(String subclassName) throws InvalidFormatException {
        if (subclassName == null) {
            return new LemmatizerFactory();
        }
        try {
            return ExtensionLoader.instantiateExtension(LemmatizerFactory.class, subclassName);
        }
        catch (Exception e) {
            String msg = "Could not instantiate the " + subclassName + ". The initialization throw an exception.";
            System.err.println(msg);
            e.printStackTrace();
            throw new InvalidFormatException(msg, e);
        }
    }

    @Override
    public void validateArtifactMap() throws InvalidFormatException {
    }

    public SequenceValidator<String> getSequenceValidator() {
        return new DefaultLemmatizerSequenceValidator();
    }

    public LemmatizerContextGenerator getContextGenerator() {
        return new DefaultLemmatizerContextGenerator();
    }
}

