/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.misc;

import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.QPath;

public class MatchResult {
    private final int pathLength;
    private int matchPos;
    private final int matchLength;

    MatchResult(QPath path, int length) {
        this(path, 0, length);
    }

    MatchResult(QPath path, int pos, int length) {
        this.matchPos = pos;
        this.matchLength = length;
        this.pathLength = path.getEntries().length;
    }

    public QPath getRemainder() {
        if (this.matchPos + this.matchLength >= this.pathLength) {
            return null;
        }
        try {
            throw new RepositoryException("Not implemented");
        }
        catch (RepositoryException e) {
            throw (IllegalStateException)new IllegalStateException("Path not normalized").initCause(e);
        }
    }

    public QPath getMatch() {
        if (this.matchLength == 0) {
            return null;
        }
        try {
            throw new RepositoryException("Not implemented");
        }
        catch (RepositoryException e) {
            throw (IllegalStateException)new IllegalStateException("Path not normalized").initCause(e);
        }
    }

    public int getMatchPos() {
        return this.matchPos;
    }

    public int getMatchLength() {
        return this.matchLength;
    }

    public boolean isMatch() {
        return this.matchLength > 0;
    }

    public boolean isFullMatch() {
        return this.pathLength == this.matchLength;
    }

    MatchResult setPos(int matchPos) {
        this.matchPos = matchPos;
        return this;
    }
}

