/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml.importing;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemDataKeeper;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.xml.importing.ContentImporter;
import org.exoplatform.services.jcr.impl.xml.importing.NeutralImporter;
import org.exoplatform.services.jcr.impl.xml.importing.RawDataImporter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;

public class StreamImporter
implements RawDataImporter {
    private final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.StreamImporter");
    private final ContentImporter importer;
    private boolean namespacesRegistered = false;
    private final ItemDataKeeper dataKeeper;

    public StreamImporter(NodeData parent, int uuidBehavior, ItemDataKeeper dataKeeper, ItemDataConsumer dataConsumer, NodeTypeDataManager ntManager, LocationFactory locationFactory, ValueFactoryImpl valueFactory, NamespaceRegistry namespaceRegistry, AccessManager accessManager, ConversationState userState, Map<String, Object> context, RepositoryImpl repository, String currentWorkspaceName) {
        this.dataKeeper = dataKeeper;
        this.importer = this.createContentImporter(parent, uuidBehavior, dataConsumer, ntManager, locationFactory, valueFactory, namespaceRegistry, accessManager, userState, context, repository, currentWorkspaceName);
    }

    @Override
    public ContentImporter createContentImporter(NodeData parent, int uuidBehavior, ItemDataConsumer dataConsumer, NodeTypeDataManager ntManager, LocationFactory locationFactory, ValueFactoryImpl valueFactory, NamespaceRegistry namespaceRegistry, AccessManager accessManager, ConversationState userState, Map<String, Object> context, RepositoryImpl repository, String currentWorkspaceName) {
        return new NeutralImporter(parent, parent.getQPath(), uuidBehavior, dataConsumer, ntManager, locationFactory, valueFactory, namespaceRegistry, accessManager, userState, context, repository, currentWorkspaceName);
    }

    public void importStream(InputStream stream) throws RepositoryException {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("FACTORY: " + String.valueOf(factory)));
            }
            XMLEventReader reader = factory.createXMLEventReader(stream);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Start event handling");
            }
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                switch (event.getEventType()) {
                    case 1: {
                        StartElement element = event.asStartElement();
                        if (!this.namespacesRegistered) {
                            this.namespacesRegistered = true;
                            this.registerNamespaces(element);
                        }
                        Iterator<Attribute> attributes = element.getAttributes();
                        HashMap<String, String> attr = new HashMap<String, String>();
                        while (attributes.hasNext()) {
                            Attribute attribute = attributes.next();
                            attr.put(attribute.getName().getPrefix() + ":" + attribute.getName().getLocalPart(), attribute.getValue());
                        }
                        QName name = element.getName();
                        this.importer.startElement(name.getNamespaceURI(), name.getLocalPart(), name.getPrefix() + ":" + name.getLocalPart(), attr);
                        break;
                    }
                    case 2: {
                        EndElement endElement = event.asEndElement();
                        this.importer.endElement(endElement.getName().getNamespaceURI(), endElement.getName().getLocalPart(), endElement.getName().getPrefix() + ":" + endElement.getName().getLocalPart());
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        String chars = event.asCharacters().getData();
                        this.importer.characters(chars.toCharArray(), 0, chars.length());
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 8: {
                        this.dataKeeper.save(this.importer.getChanges());
                        break;
                    }
                    case 9: {
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 11: {
                        break;
                    }
                    case 12: {
                        break;
                    }
                    case 6: {
                        break;
                    }
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Event handling finished");
            }
        }
        catch (XMLStreamException e) {
            throw new InvalidSerializedDataException("ImportXML failed", (Throwable)e);
        }
    }

    private void registerNamespaces(StartElement event) {
        Iterator<Namespace> iter = event.getNamespaces();
        while (iter.hasNext()) {
            Namespace namespace = iter.next();
            this.importer.registerNamespace(namespace.getPrefix(), namespace.getNamespaceURI());
        }
    }
}

