/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.BitSet;
import org.exoplatform.services.jcr.impl.core.query.lucene.ForeignSegmentDocId;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiIndexReader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

abstract class DocId {
    static final int[] EMPTY = new int[0];
    private static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.DocId");
    private static final PlainDocId[] LOW_DOC_IDS = new PlainDocId[Short.MAX_VALUE];
    static final DocId NULL;

    DocId() {
    }

    abstract int[] getDocumentNumbers(MultiIndexReader var1, int[] var2) throws IOException;

    abstract DocId applyOffset(int var1);

    abstract boolean isValid(BitSet var1);

    static DocId create(int docNumber) {
        if (docNumber < Short.MAX_VALUE) {
            return LOW_DOC_IDS[docNumber];
        }
        return new PlainDocId(docNumber);
    }

    static DocId create(String uuid) {
        return new UUIDDocId(uuid);
    }

    static DocId create(String[] uuids) {
        return new MultiUUIDDocId(uuids);
    }

    static {
        for (int i = 0; i < LOW_DOC_IDS.length; ++i) {
            DocId.LOW_DOC_IDS[i] = new PlainDocId(i);
        }
        NULL = new DocId(){

            @Override
            final int[] getDocumentNumbers(MultiIndexReader reader, int[] docNumbers) {
                return EMPTY;
            }

            @Override
            final DocId applyOffset(int offset) {
                return this;
            }

            @Override
            final boolean isValid(BitSet deleted) {
                return true;
            }
        };
    }

    private static final class PlainDocId
    extends DocId {
        private final int docNumber;

        PlainDocId(int docNumber) {
            this.docNumber = docNumber;
        }

        @Override
        int[] getDocumentNumbers(MultiIndexReader reader, int[] docNumbers) {
            if (docNumbers.length == 1) {
                docNumbers[0] = this.docNumber;
                return docNumbers;
            }
            return new int[]{this.docNumber};
        }

        @Override
        DocId applyOffset(int offset) {
            return new PlainDocId(this.docNumber + offset);
        }

        @Override
        boolean isValid(BitSet deleted) {
            return !deleted.get(this.docNumber);
        }

        public String toString() {
            return "PlainDocId(" + this.docNumber + ")";
        }
    }

    private static final class UUIDDocId
    extends DocId {
        private final String identifier;
        private ForeignSegmentDocId doc;

        UUIDDocId(String identifier) {
            this.identifier = identifier;
        }

        @Override
        int[] getDocumentNumbers(MultiIndexReader reader, int[] docNumbers) throws IOException {
            int realDoc = -1;
            ForeignSegmentDocId segDocId = this.doc;
            if (segDocId != null) {
                realDoc = reader.getDocumentNumber(segDocId);
            }
            if (realDoc == -1 && (segDocId = reader.createDocId(this.identifier)) != null) {
                realDoc = reader.getDocumentNumber(segDocId);
                this.doc = segDocId;
            }
            if (docNumbers.length == 1) {
                docNumbers[0] = realDoc;
                return docNumbers;
            }
            return new int[]{realDoc};
        }

        @Override
        DocId applyOffset(int offset) {
            return this;
        }

        @Override
        boolean isValid(BitSet deleted) {
            return true;
        }

        public String toString() {
            return "UUIDDocId(" + this.identifier + ")";
        }
    }

    private static final class MultiUUIDDocId
    extends DocId {
        private final UUIDDocId[] docIds;

        MultiUUIDDocId(String[] uuids) {
            this.docIds = new UUIDDocId[uuids.length];
            for (int i = 0; i < uuids.length; ++i) {
                this.docIds[i] = new UUIDDocId(uuids[i]);
            }
        }

        @Override
        int[] getDocumentNumbers(MultiIndexReader reader, int[] docNumbers) throws IOException {
            int[] tmp = new int[1];
            docNumbers = new int[this.docIds.length];
            for (int i = 0; i < docNumbers.length; ++i) {
                docNumbers[i] = this.docIds[i].getDocumentNumbers(reader, tmp)[0];
            }
            return docNumbers;
        }

        @Override
        DocId applyOffset(int offset) {
            return this;
        }

        @Override
        boolean isValid(BitSet deleted) {
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("MultiUUIDDocId(");
            String separator = "";
            for (int i = 0; i < this.docIds.length; ++i) {
                sb.append(separator);
                separator = ", ";
                sb.append(this.docIds[i].identifier);
            }
            sb.append(")");
            return sb.toString();
        }
    }
}

