/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.io.IOException;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.jcr.config.QueryHandlerEntry;
import org.exoplatform.services.jcr.impl.core.query.IndexerChangesFilter;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoMode;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeHandler;
import org.exoplatform.services.jcr.impl.core.query.IndexingTree;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DefaultChangesFilter
extends IndexerChangesFilter {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.DefaultChangesFilter");

    public DefaultChangesFilter(SearchManager searchManager, SearchManager parentSearchManager, QueryHandlerEntry config, IndexingTree indexingTree, IndexingTree parentIndexingTree, QueryHandler handler, QueryHandler parentHandler, ConfigurationManager cfm) throws Exception {
        super(searchManager, parentSearchManager, config, indexingTree, parentIndexingTree, handler, parentHandler, cfm);
        IndexerIoModeHandler modeHandler = new IndexerIoModeHandler(IndexerIoMode.READ_WRITE);
        handler.setIndexerIoModeHandler(modeHandler);
        parentHandler.setIndexerIoModeHandler(modeHandler);
        this.init();
    }

    public DefaultChangesFilter(SearchManager searchManager, SearchManager parentSearchManager, QueryHandlerEntry config, IndexingTree indexingTree, IndexingTree parentIndexingTree, QueryHandler handler, QueryHandler parentHandler, ConfigurationManager cfm, boolean init) throws Exception {
        super(searchManager, parentSearchManager, config, indexingTree, parentIndexingTree, handler, parentHandler, cfm);
        IndexerIoModeHandler modeHandler = new IndexerIoModeHandler(IndexerIoMode.READ_WRITE);
        handler.setIndexerIoModeHandler(modeHandler);
        parentHandler.setIndexerIoModeHandler(modeHandler);
        if (init) {
            this.init();
        }
    }

    public void init() throws Exception {
        if (!this.parentHandler.isInitialized()) {
            this.parentHandler.init();
        }
        if (!this.handler.isInitialized()) {
            this.handler.init();
        }
    }

    @Override
    protected void doUpdateIndex(Set<String> removedNodes, Set<String> addedNodes, Set<String> parentRemovedNodes, Set<String> parentAddedNodes) {
        try {
            this.searchManager.updateIndex(removedNodes, addedNodes);
        }
        catch (RepositoryException e) {
            LOG.error((Object)("Error indexing changes " + String.valueOf((Object)e)), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)("Error indexing changes " + String.valueOf(e)), (Throwable)e);
            this.logErrorChanges(this.handler, removedNodes, addedNodes);
        }
        try {
            this.parentSearchManager.updateIndex(parentRemovedNodes, parentAddedNodes);
        }
        catch (RepositoryException e) {
            LOG.error((Object)("Error indexing changes " + String.valueOf((Object)e)), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)("Error indexing changes " + String.valueOf(e)), (Throwable)e);
            this.logErrorChanges(this.parentHandler, parentRemovedNodes, parentAddedNodes);
        }
    }

    @Override
    protected Log getLogger() {
        return LOG;
    }
}

