/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.quota;

public class PathPatternUtils {
    public static final String ANY_NAME = "*";
    public static final String ANY_CHAR = "%";

    private static String adopt2JavaPattern(String pattern) {
        pattern = PathPatternUtils.normalizePath(pattern);
        pattern = pattern.replaceAll("\\*", "[^/]+");
        pattern = pattern.replaceAll(ANY_CHAR, "[^/]{1}");
        return pattern;
    }

    public static boolean acceptName(String pattern, String absPath) {
        absPath = PathPatternUtils.normalizePath(absPath);
        pattern = PathPatternUtils.adopt2JavaPattern(pattern);
        return absPath.matches(pattern);
    }

    public static boolean acceptDescendant(String pattern, String absPath) {
        absPath = PathPatternUtils.normalizePath(absPath);
        pattern = PathPatternUtils.adopt2JavaPattern((String)pattern);
        pattern = (String)pattern + "(/.+)?";
        return absPath.matches((String)pattern);
    }

    public static String extractCommonAncestor(String pattern, String absPath) {
        pattern = PathPatternUtils.normalizePath(pattern);
        absPath = PathPatternUtils.normalizePath(absPath);
        String[] patterEntries = pattern.split("/");
        String[] pathEntries = absPath.split("/");
        StringBuilder ancestor = new StringBuilder();
        int count = Math.min(pathEntries.length, patterEntries.length);
        for (int i = 1; i < count && PathPatternUtils.acceptName(patterEntries[i], pathEntries[i]); ++i) {
            ancestor.append("/");
            ancestor.append(pathEntries[i]);
        }
        return ancestor.length() == 0 ? "/" : ancestor.toString();
    }

    private static String normalizePath(String absPath) {
        if (absPath.endsWith("/")) {
            return absPath.substring(0, absPath.length() - 1);
        }
        return absPath;
    }
}

