/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Time;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.math.Fraction;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.DefaultVerticalCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.datum.TemporalDatum;

@XmlType(name="TemporalCRSType", propOrder={"coordinateSystem", "datum"})
@XmlRootElement(name="TemporalCRS")
public class DefaultTemporalCRS
extends AbstractCRS
implements TemporalCRS {
    private static final long serialVersionUID = 3000119849197222007L;
    private TemporalDatum datum;
    private transient UnitConverter toSeconds;
    private transient long origin;

    public DefaultTemporalCRS(Map<String, ?> map, TemporalDatum temporalDatum, TimeCS timeCS) {
        super(map, (CoordinateSystem)timeCS);
        ArgumentChecks.ensureNonNull((String)"datum", (Object)temporalDatum);
        this.datum = temporalDatum;
        this.initializeConverter();
    }

    protected DefaultTemporalCRS(TemporalCRS temporalCRS) {
        super((CoordinateReferenceSystem)temporalCRS);
        this.datum = temporalCRS.getDatum();
        this.initializeConverter();
    }

    public static DefaultTemporalCRS castOrCopy(TemporalCRS temporalCRS) {
        return temporalCRS == null || temporalCRS instanceof DefaultTemporalCRS ? (DefaultTemporalCRS)temporalCRS : new DefaultTemporalCRS(temporalCRS);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeConverter();
    }

    private void initializeConverter() {
        this.toSeconds = this.getUnit().getConverterTo(Units.SECOND);
        long l = this.datum.getOrigin().getTime();
        this.origin = l / 1000L;
        if ((l %= 1000L) != 0L) {
            UnitConverter unitConverter = Units.converter(null, (Number)new Fraction((int)l, 1000).simplify());
            this.toSeconds = unitConverter.concatenate(this.toSeconds);
        }
    }

    public Class<? extends TemporalCRS> getInterface() {
        return TemporalCRS.class;
    }

    @XmlElement(name="temporalDatum", required=true)
    public TemporalDatum getDatum() {
        return this.datum;
    }

    @XmlElement(name="timeCS", required=true)
    public TimeCS getCoordinateSystem() {
        return (TimeCS)super.getCoordinateSystem();
    }

    public final Unit<Time> getUnit() {
        return super.getCoordinateSystem().getAxis(0).getUnit().asType(Time.class);
    }

    @Override
    public DefaultTemporalCRS forConvention(AxesConvention axesConvention) {
        return (DefaultTemporalCRS)super.forConvention(axesConvention);
    }

    @Override
    final AbstractCRS createSameType(Map<String, ?> map, CoordinateSystem coordinateSystem) {
        return new DefaultTemporalCRS(map, this.datum, (TimeCS)coordinateSystem);
    }

    public Instant toInstant(double d) {
        if (Double.isFinite(d)) {
            d = this.toSeconds.convert(d);
            long l = Math.round(d);
            return Instant.ofEpochSecond(Math.addExact(l, this.origin), Math.round((d - (double)l) * 1.0E9));
        }
        return null;
    }

    public Date toDate(double d) {
        if (Double.isFinite(d)) {
            d = this.toSeconds.convert(d);
            long l = Math.round(d);
            long l2 = Math.addExact(l, this.origin);
            l2 = Math.multiplyExact(l2, 1000L);
            l2 = Math.addExact(Math.round((d - (double)l) * 1000.0), l2);
            return new Date(l2);
        }
        return null;
    }

    public double toValue(Instant instant) {
        if (instant != null) {
            double d = Math.subtractExact(instant.getEpochSecond(), this.origin);
            return this.toSeconds.inverse().convert(d += (double)instant.getNano() / 1.0E9);
        }
        return Double.NaN;
    }

    public double toValue(Date date) {
        if (date != null) {
            long l = date.getTime();
            long l2 = l / 1000L;
            l2 = Math.subtractExact(l2, this.origin);
            return this.toSeconds.inverse().convert((double)l2 + (double)(l %= 1000L) / 1000.0);
        }
        return Double.NaN;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        if (formatter.getConvention().majorVersion() == 1) {
            formatter.setInvalidWKT(this, null);
        }
        return DefaultTemporalCRS.isBaseCRS(formatter) ? "BaseTimeCRS" : "TimeCRS";
    }

    private DefaultTemporalCRS() {
    }

    private void setDatum(TemporalDatum temporalDatum) {
        if (this.datum == null) {
            this.datum = temporalDatum;
            if (super.getCoordinateSystem() != null) {
                this.initializeConverter();
            }
        } else {
            MetadataUtilities.propertyAlreadySet(DefaultVerticalCRS.class, (String)"setDatum", (String)"temporalDatum");
        }
    }

    private void setCoordinateSystem(TimeCS timeCS) {
        this.setCoordinateSystem("timeCS", (CoordinateSystem)timeCS);
        if (this.toSeconds == null && this.datum != null) {
            this.initializeConverter();
        }
    }
}

