/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.ClassLoading;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.jcr.config.ConfigurationPersister;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryServiceConfiguration;
import org.exoplatform.services.jcr.impl.config.RepositoryServiceConfigurationPlugin;
import org.exoplatform.services.jcr.impl.util.io.DirectoryHelper;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.JiBXException;
import org.picocontainer.Startable;

public class RepositoryServiceConfigurationImpl
extends RepositoryServiceConfiguration
implements Startable {
    protected ValueParam param;
    protected ConfigurationManager configurationService;
    private ConfigurationPersister configurationPersister;
    private final List<String> configExtensionPaths = new CopyOnWriteArrayList<String>();
    private final int maxBackupFiles;
    private int indexBackupFile = 1;
    public static final int DEFAULT_MAX_BACKUP_FILES = 3;

    public RepositoryServiceConfigurationImpl(InitParams params, ConfigurationManager configurationService, InitialContextInitializer initialContextInitializer) throws RepositoryConfigurationException {
        this.param = params.getValueParam("conf-path");
        ValueParam valueBackupFiles = params.getValueParam("max-backup-files");
        int n = this.maxBackupFiles = valueBackupFiles == null ? 3 : Integer.valueOf(valueBackupFiles.getValue());
        if (params.getPropertiesParam("working-conf") != null) {
            String cn = params.getPropertiesParam("working-conf").getProperty("persister-class-name");
            if (cn == null) {
                cn = params.getPropertiesParam("working-conf").getProperty("persisterClassName");
            }
            if (cn != null) {
                try {
                    Class configurationPersisterClass = ClassLoading.forName((String)cn, (Object)this);
                    this.configurationPersister = (ConfigurationPersister)configurationPersisterClass.newInstance();
                    this.configurationPersister.init(params.getPropertiesParam("working-conf"));
                }
                catch (InstantiationException e) {
                    throw new RepositoryConfigurationException(e.getLocalizedMessage(), e);
                }
                catch (IllegalAccessException e) {
                    throw new RepositoryConfigurationException(e.getLocalizedMessage(), e);
                }
                catch (ClassNotFoundException e) {
                    throw new RepositoryConfigurationException(e.getLocalizedMessage(), e);
                }
            }
        }
        this.configurationService = configurationService;
    }

    public void addConfig(RepositoryServiceConfigurationPlugin plugin) {
        this.configExtensionPaths.add(plugin.getConfPath());
    }

    @Override
    public boolean isRetainable() {
        URL fileURL;
        if (this.configurationPersister != null) {
            return true;
        }
        String strfileUri = this.param.getValue();
        try {
            fileURL = this.configurationService.getURL(strfileUri);
        }
        catch (Exception e) {
            return false;
        }
        return fileURL.getProtocol().equals("file");
    }

    @Override
    public synchronized void retain() throws RepositoryException {
        try {
            if (!this.isRetainable()) {
                throw new RepositoryException("Unsupported  configuration place " + String.valueOf(this.configurationService.getURL(this.param.getValue())) + " If you want to save configuration, start repository from standalone file. Or persister-class-name not configured");
            }
            OutputStream saveStream = null;
            if (this.configurationPersister != null) {
                saveStream = new ByteArrayOutputStream();
            } else {
                URL filePath = this.configurationService.getURL(this.param.getValue());
                File sourceConfig = new File(filePath.toURI());
                File backUp = new File(String.valueOf(sourceConfig.getAbsoluteFile()) + "." + this.indexBackupFile++);
                if (this.indexBackupFile > this.maxBackupFiles) {
                    this.indexBackupFile = 1;
                }
                try {
                    DirectoryHelper.deleteDstAndRename(sourceConfig, backUp);
                }
                catch (IOException ioe) {
                    throw new RepositoryException("Can't back up configuration on path " + sourceConfig.getAbsolutePath(), (Throwable)ioe);
                }
                saveStream = new FileOutputStream(sourceConfig);
            }
            IBindingFactory bfact = BindingDirectory.getFactory(RepositoryServiceConfiguration.class);
            IMarshallingContext mctx = bfact.createMarshallingContext();
            mctx.marshalDocument((Object)this, "ISO-8859-1", null, saveStream);
            ((OutputStream)saveStream).close();
            if (this.configurationPersister != null) {
                this.configurationPersister.write(new ByteArrayInputStream(saveStream.toByteArray()));
            }
        }
        catch (JiBXException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (RepositoryConfigurationException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void start() {
        try {
            String[] paths = this.configExtensionPaths.toArray(new String[this.configExtensionPaths.size()]);
            for (int i = paths.length - 1; i >= 0; --i) {
                if (i == paths.length - 1) {
                    this.init(this.configurationService.getInputStream(paths[i]));
                    continue;
                }
                this.merge(this.configurationService.getInputStream(paths[i]));
            }
            if (this.configExtensionPaths.isEmpty()) {
                this.init(this.configurationService.getInputStream(this.param.getValue()));
            } else {
                this.merge(this.configurationService.getInputStream(this.param.getValue()));
            }
            if (this.configurationPersister != null) {
                if (this.configurationPersister.hasConfig()) {
                    this.merge(this.configurationPersister.read());
                }
                this.retain();
            }
        }
        catch (RepositoryConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(new RepositoryConfigurationException("Fail to init from xml! Reason: " + String.valueOf(e), e));
        }
    }

    public void stop() {
    }
}

