/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.io.IOException;
import java.lang.reflect.Array;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.apache.sis.geometry.AbstractDirectPosition;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.internal.metadata.Resources;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.simple.SimpleExtent;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.internal.util.StandardDateFormat;
import org.apache.sis.internal.util.X364;
import org.apache.sis.io.wkt.Colors;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Symbols;
import org.apache.sis.io.wkt.Transliterator;
import org.apache.sis.io.wkt.UnformattableObjectException;
import org.apache.sis.io.wkt.Warnings;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Localized;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.collection.IntegerList;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.coordinate.Position;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;

public class Formatter
implements Localized {
    static final int BBOX_ACCURACY = 2;
    private static final int VERTICAL_ACCURACY = 9;
    static final String FOREGROUND_DEFAULT = "\u001b[39m";
    static final String BACKGROUND_DEFAULT = "\u001b[49m";
    private final Locale locale;
    private final Symbols symbols;
    private final String separatorNewLine;
    private Colors colors;
    private Convention convention;
    private Citation authority;
    Transliterator transliterator;
    boolean verifyCharacterValidity = true;
    private final List<FormattableObject> enclosingElements = new ArrayList<FormattableObject>();
    private final Map<Unit<?>, Unit<?>> units = new HashMap(4);
    private long hasContextualUnit;
    private final NumberFormat numberFormat;
    private final DateFormat dateFormat;
    private final UnitFormat unitFormat;
    private final FieldPosition dummy = new FieldPosition(0);
    private StringBuffer buffer;
    private int elementStart;
    private byte toUpperCase;
    private byte longKeywords;
    private int listSizeLimit;
    private int colorApplied;
    private byte indentation;
    private int margin;
    private IntegerList keywordSpaceAt;
    private boolean requestNewLine;
    private boolean isComplement;
    private boolean highlightError;
    private Warnings warnings;
    private final Locale errorLocale;

    public Formatter() {
        this(Convention.DEFAULT, Symbols.getDefault(), 2);
    }

    public Formatter(Convention convention, Symbols symbols, int n) {
        ArgumentChecks.ensureNonNull((String)"convention", (Object)((Object)convention));
        ArgumentChecks.ensureNonNull((String)"symbols", (Object)symbols);
        ArgumentChecks.ensureBetween((String)"indentation", (int)-1, (int)127, (int)n);
        this.errorLocale = this.locale = Locale.getDefault(Locale.Category.DISPLAY);
        this.convention = convention;
        this.authority = convention.getNameAuthority();
        this.symbols = symbols.immutable();
        this.transliterator = convention == Convention.INTERNAL ? Transliterator.IDENTITY : Transliterator.DEFAULT;
        this.separatorNewLine = this.symbols.separatorNewLine();
        this.indentation = (byte)n;
        this.numberFormat = symbols.createNumberFormat();
        this.dateFormat = new StandardDateFormat(symbols.getLocale());
        this.unitFormat = new UnitFormat(symbols.getLocale());
        this.buffer = new StringBuffer();
        this.unitFormat.setStyle(UnitFormat.Style.NAME);
        if (convention.usesCommonUnits) {
            this.unitFormat.setLocale(Locale.US);
        }
    }

    Formatter(Locale locale, Locale locale2, Symbols symbols, NumberFormat numberFormat, DateFormat dateFormat, UnitFormat unitFormat) {
        this.locale = locale;
        this.errorLocale = locale2;
        this.convention = Convention.DEFAULT;
        this.authority = Convention.DEFAULT.getNameAuthority();
        this.symbols = symbols;
        this.separatorNewLine = symbols.separatorNewLine();
        this.indentation = (byte)2;
        this.numberFormat = numberFormat;
        this.dateFormat = dateFormat;
        this.unitFormat = unitFormat;
    }

    final void setBuffer(StringBuffer stringBuffer) {
        this.buffer = stringBuffer;
        this.elementStart = stringBuffer != null ? stringBuffer.length() : 0;
    }

    final void configure(Convention convention, Citation citation, Colors colors, byte by, byte by2, byte by3, int n) {
        this.convention = convention;
        this.authority = citation != null ? citation : convention.getNameAuthority();
        this.colors = colors;
        this.toUpperCase = by;
        this.longKeywords = by2;
        this.indentation = by3;
        this.listSizeLimit = n;
        this.transliterator = convention == Convention.INTERNAL ? Transliterator.IDENTITY : Transliterator.DEFAULT;
        this.unitFormat.setLocale(convention.usesCommonUnits ? Locale.US : Locale.ROOT);
    }

    public final Convention getConvention() {
        return this.convention;
    }

    public final Transliterator getTransliterator() {
        return this.transliterator;
    }

    public final Citation getNameAuthority() {
        return this.authority;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    private void setColor(ElementKind elementKind) {
        if (this.colors != null) {
            if (this.colorApplied == 0) {
                String string = this.colors.getAnsiSequence(elementKind);
                if (string == null) {
                    return;
                }
                boolean bl = this.buffer.length() == this.elementStart;
                this.buffer.append(string);
                if (bl) {
                    this.elementStart = this.buffer.length();
                }
            }
            ++this.colorApplied;
        }
    }

    private void resetColor() {
        if (this.colors != null && --this.colorApplied <= 0) {
            this.colorApplied = 0;
            this.buffer.append(FOREGROUND_DEFAULT);
        }
    }

    public void newLine() {
        if (this.indentation > -1) {
            this.requestNewLine = true;
        }
    }

    public void indent(int n) {
        this.margin = Math.max(0, this.margin + this.indentation * n);
    }

    public String shortOrLong(String string, String string2) {
        return (this.longKeywords != 0 ? this.longKeywords < 0 : this.convention.toUpperCase) ? string : string2;
    }

    private void appendSeparator() {
        if (this.buffer.length() != this.elementStart) {
            if (this.requestNewLine) {
                this.buffer.append(this.separatorNewLine).append(CharSequences.spaces((int)this.margin));
            } else {
                this.buffer.append(this.symbols.getSeparator());
            }
        } else if (this.requestNewLine) {
            this.buffer.append(System.lineSeparator()).append(CharSequences.spaces((int)this.margin));
        }
        this.requestNewLine = false;
    }

    private void openElement(boolean bl, String string) {
        if (bl && this.buffer.length() != this.elementStart) {
            this.newLine();
        }
        this.appendSeparator();
        if (this.toUpperCase != 0) {
            Locale locale = this.symbols.getLocale();
            string = this.toUpperCase >= 0 ? string.toUpperCase(locale) : string.toLowerCase(locale);
        }
        this.elementStart = this.buffer.append(string).appendCodePoint(this.symbols.getOpeningBracket(0)).length();
    }

    private void closeElement(boolean bl) {
        this.buffer.appendCodePoint(this.symbols.getClosingBracket(0));
        if (bl) {
            this.newLine();
        }
    }

    public void append(FormattableObject formattableObject) {
        Object object;
        int n;
        if (formattableObject == null) {
            return;
        }
        int n2 = n = this.enclosingElements.size();
        while (--n2 >= 0) {
            if (this.enclosingElements.get(n2) != formattableObject) continue;
            throw new IllegalStateException(Errors.getResources((Locale)this.errorLocale).getString((short)18));
        }
        this.enclosingElements.add(formattableObject);
        if (this.hasContextualUnit < 0L) {
            throw new IllegalStateException(Errors.getResources((Locale)this.errorLocale).getString((short)131));
        }
        this.hasContextualUnit <<= 1;
        this.appendSeparator();
        n2 = this.buffer.length();
        this.elementStart = this.buffer.appendCodePoint(this.symbols.getOpeningBracket(0)).length();
        this.indent(1);
        IdentifiedObject identifiedObject = formattableObject instanceof IdentifiedObject ? (IdentifiedObject)formattableObject : null;
        String string = formattableObject.formatTo(this);
        if (string == null) {
            if (identifiedObject != null) {
                this.setInvalidWKT(identifiedObject, null);
            } else {
                this.setInvalidWKT(formattableObject.getClass(), null);
            }
            string = Formatter.getName(formattableObject.getClass());
        } else if (this.toUpperCase != 0) {
            object = this.symbols.getLocale();
            String string2 = string = this.toUpperCase >= 0 ? string.toUpperCase((Locale)object) : string.toLowerCase((Locale)object);
        }
        if (this.highlightError && this.colors != null && (object = this.colors.getAnsiSequence(ElementKind.ERROR)) != null) {
            this.buffer.insert(n2, (String)object + BACKGROUND_DEFAULT);
            n2 += ((String)object).length();
        }
        this.highlightError = false;
        this.buffer.insert(n2, string);
        if (this.keywordSpaceAt != null) {
            int n3 = string.length();
            CharSequence charSequence = CharSequences.spaces((int)string.codePointCount(0, n3));
            int n4 = this.keywordSpaceAt.size();
            int n5 = 0;
            while (n5 < n4) {
                int n6 = this.keywordSpaceAt.getInt(n5);
                this.buffer.insert(n6 += ++n5 * n3, charSequence);
            }
            this.keywordSpaceAt.clear();
        }
        if (identifiedObject == null && this.convention.majorVersion() != 1 && formattableObject instanceof GeneralParameterValue) {
            identifiedObject = ((GeneralParameterValue)formattableObject).getDescriptor();
        }
        if (identifiedObject != null) {
            this.appendComplement(identifiedObject, n >= 1 ? this.enclosingElements.get(n - 1) : null, n >= 2 ? this.enclosingElements.get(n - 2) : null);
        }
        this.buffer.appendCodePoint(this.symbols.getClosingBracket(0));
        this.indent(-1);
        this.enclosingElements.remove(n);
        this.hasContextualUnit >>>= 1;
    }

    private void appendComplement(IdentifiedObject identifiedObject, FormattableObject formattableObject, FormattableObject formattableObject2) {
        Set<ReferenceIdentifier> set;
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        this.isComplement = true;
        if (this.convention == Convention.INTERNAL) {
            bl4 = true;
            bl3 = false;
            bl2 = true;
            bl = true;
        } else {
            if (formattableObject == null || formattableObject instanceof CompoundCRS) {
                bl4 = true;
            } else if (formattableObject2 instanceof CoordinateOperation && !(formattableObject instanceof IdentifiedObject)) {
                bl4 = true;
            } else if (this.convention == Convention.WKT2_SIMPLIFIED) {
                bl4 = false;
            } else {
                boolean bl5 = bl4 = identifiedObject instanceof OperationMethod || identifiedObject instanceof GeneralParameterDescriptor;
            }
            if (this.convention.majorVersion() == 1) {
                bl3 = true;
                bl2 = false;
                bl = false;
            } else {
                boolean bl6 = bl3 = formattableObject != null;
                if (identifiedObject instanceof CoordinateOperation) {
                    bl = bl2 = !(formattableObject instanceof ConcatenatedOperation);
                } else if (identifiedObject instanceof ReferenceSystem) {
                    bl2 = formattableObject == null;
                    bl = formattableObject == null || formattableObject2 instanceof CoordinateOperation;
                } else {
                    bl2 = false;
                    bl = false;
                }
            }
        }
        if (bl2) {
            this.appendForSubtypes(identifiedObject);
        }
        if (bl4 && (set = identifiedObject.getIdentifiers()) != null) {
            if (bl3) {
                for (ReferenceIdentifier referenceIdentifier : set) {
                    if (!Citations.identifierMatches((Citation)this.authority, (Citation)referenceIdentifier.getAuthority())) continue;
                    set = Collections.singleton(referenceIdentifier);
                    break;
                }
            }
            for (ReferenceIdentifier referenceIdentifier : set) {
                if (!(referenceIdentifier instanceof FormattableObject)) {
                    referenceIdentifier = ImmutableIdentifier.castOrCopy(referenceIdentifier);
                }
                this.append((FormattableObject)referenceIdentifier);
                if (!bl3) continue;
                break;
            }
        }
        if (bl) {
            this.appendOnNewLine("Remark", identifiedObject.getRemarks(), ElementKind.REMARKS);
        }
        this.isComplement = false;
    }

    private void appendForSubtypes(IdentifiedObject identifiedObject) {
        Extent extent;
        InternationalString internationalString;
        InternationalString internationalString2;
        if (identifiedObject instanceof ReferenceSystem) {
            internationalString2 = null;
            internationalString = ((ReferenceSystem)identifiedObject).getScope();
            extent = ((ReferenceSystem)identifiedObject).getDomainOfValidity();
        } else if (identifiedObject instanceof Datum) {
            internationalString2 = ((Datum)identifiedObject).getAnchorPoint();
            internationalString = ((Datum)identifiedObject).getScope();
            extent = ((Datum)identifiedObject).getDomainOfValidity();
        } else if (identifiedObject instanceof CoordinateOperation) {
            internationalString2 = null;
            internationalString = ((CoordinateOperation)identifiedObject).getScope();
            extent = ((CoordinateOperation)identifiedObject).getDomainOfValidity();
        } else {
            return;
        }
        this.appendOnNewLine("Anchor", internationalString2, null);
        this.appendOnNewLine("Scope", internationalString, ElementKind.SCOPE);
        if (extent != null) {
            this.appendOnNewLine("Area", extent.getDescription(), ElementKind.EXTENT);
            this.append(Extents.getGeographicBoundingBox((Extent)extent), 2);
            this.appendVerticalExtent((MeasurementRange<Double>)Extents.getVerticalRange((Extent)extent));
            this.appendTemporalExtent((Range<Date>)Extents.getTimeRange((Extent)extent));
        }
    }

    public void append(GeographicBoundingBox geographicBoundingBox, int n) {
        if (geographicBoundingBox != null) {
            this.openElement(this.isComplement, "BBox");
            this.setColor(ElementKind.EXTENT);
            this.numberFormat.setMinimumFractionDigits(n);
            this.numberFormat.setMaximumFractionDigits(n);
            this.numberFormat.setRoundingMode(RoundingMode.FLOOR);
            this.appendPreset(geographicBoundingBox.getSouthBoundLatitude());
            this.appendPreset(geographicBoundingBox.getWestBoundLongitude());
            this.numberFormat.setRoundingMode(RoundingMode.CEILING);
            this.appendPreset(geographicBoundingBox.getNorthBoundLatitude());
            this.appendPreset(geographicBoundingBox.getEastBoundLongitude());
            this.resetColor();
            this.closeElement(this.isComplement);
        }
    }

    private void appendVerticalExtent(MeasurementRange<Double> measurementRange) {
        if (measurementRange != null) {
            double d = measurementRange.getMinDouble();
            double d2 = measurementRange.getMaxDouble();
            int n = Numerics.fractionDigitsForDelta((double)(d2 - d));
            int n2 = Math.min(Math.min(Numerics.suggestFractionDigits((double[])new double[]{d, d2}), n + 2), 9);
            this.openElement(true, "VerticalExtent");
            this.setColor(ElementKind.EXTENT);
            this.numberFormat.setMinimumFractionDigits(n);
            this.numberFormat.setMaximumFractionDigits(n2);
            this.numberFormat.setRoundingMode(RoundingMode.FLOOR);
            this.appendPreset(d);
            this.numberFormat.setRoundingMode(RoundingMode.CEILING);
            this.appendPreset(d2);
            Unit unit = measurementRange.unit();
            if (!this.convention.isSimplified() || !Units.METRE.equals((Object)unit)) {
                this.append(unit);
            }
            this.resetColor();
            this.closeElement(true);
        }
    }

    private void appendTemporalExtent(Range<Date> range) {
        if (range != null) {
            Date date = (Date)range.getMinValue();
            Date date2 = (Date)range.getMaxValue();
            if (date != null && date2 != null) {
                this.openElement(true, "TimeExtent");
                this.setColor(ElementKind.EXTENT);
                this.append(date);
                this.append(date2);
                this.resetColor();
                this.closeElement(true);
            }
        }
    }

    public void append(MathTransform mathTransform) {
        if (mathTransform != null) {
            if (mathTransform instanceof FormattableObject) {
                this.append((FormattableObject)mathTransform);
            } else {
                FormattableObject formattableObject = WKTUtilities.toFormattable(mathTransform, this.convention == Convention.INTERNAL);
                if (formattableObject != null) {
                    this.append(formattableObject);
                } else {
                    throw new UnformattableObjectException(Errors.format((short)50, FormattableObject.class, (Object)mathTransform.getClass()));
                }
            }
        }
    }

    private void appendOnNewLine(String string, InternationalString internationalString, ElementKind elementKind) {
        String string2;
        ArgumentChecks.ensureNonNull((String)"keyword", (Object)string);
        if (internationalString != null && (string2 = CharSequences.trimWhitespaces((String)internationalString.toString(this.locale))) != null && !string2.isEmpty()) {
            this.openElement(true, string);
            this.quote(string2, elementKind);
            this.closeElement(true);
        }
    }

    public void append(String string, ElementKind elementKind) {
        if (string != null) {
            this.appendSeparator();
            if (elementKind != ElementKind.CODE_LIST) {
                this.quote(string, elementKind);
            } else {
                this.setColor(elementKind);
                this.buffer.append(string);
                this.resetColor();
            }
        }
    }

    private void quote(String string, ElementKind elementKind) {
        this.setColor(elementKind);
        int n = this.buffer.appendCodePoint(this.symbols.getOpeningQuote(0)).length();
        if (elementKind != ElementKind.REMARKS) {
            string = this.transliterator.filter(string);
            if (this.verifyCharacterValidity) {
                int n2;
                int n3 = 0;
                int n4 = string.length();
                for (int i = 0; i < n4; i += n2) {
                    int n5 = string.codePointAt(i);
                    n2 = Character.charCount(n5);
                    if (Characters.isValidWKT((int)n5)) continue;
                    String string2 = string.substring(i, i + n2);
                    while ((i += n2) < n4) {
                        n5 = string.codePointAt(i);
                        n2 = Character.charCount(n5);
                        if (n5 != 32 && n5 != 95) continue;
                    }
                    this.warnings().add(Errors.formatInternational((short)48, (Object[])new Object[]{"Well-Known Text", string.substring(n3, i), string2}), null, null);
                    break;
                }
            }
        }
        this.buffer.append(string);
        this.closeQuote(n);
        this.resetColor();
    }

    private void closeQuote(int n) {
        String string = this.symbols.getQuote();
        while ((n = this.buffer.indexOf(string, n)) >= 0) {
            int n2 = string.length();
            if (this.convention.majorVersion() == 1) {
                this.buffer.delete(n, n + n2);
                continue;
            }
            this.buffer.insert(n += n2, string);
            n += n2;
        }
        this.buffer.append(string);
    }

    public void append(CodeList<?> codeList) {
        if (codeList != null) {
            String string;
            this.appendSeparator();
            String string2 = string = this.convention.majorVersion() == 1 ? codeList.name() : Types.getCodeName(codeList);
            if (CharSequences.isUnicodeIdentifier((CharSequence)string)) {
                this.setColor(ElementKind.CODE_LIST);
                this.buffer.append(string);
                this.resetColor();
            } else {
                this.quote(string, ElementKind.CODE_LIST);
                this.setInvalidWKT(codeList.getClass(), null);
            }
        }
    }

    public void append(Date date) {
        if (date != null) {
            this.appendSeparator();
            this.dateFormat.format(date, this.buffer, this.dummy);
        }
    }

    public void append(boolean bl) {
        this.appendSeparator();
        this.buffer.append(bl ? "TRUE" : "FALSE");
    }

    public void append(long l) {
        this.appendSeparator();
        this.setColor(this.isComplement ? ElementKind.IDENTIFIER : ElementKind.INTEGER);
        this.numberFormat.setMaximumFractionDigits(0);
        this.numberFormat.format(l, this.buffer, this.dummy);
        this.resetColor();
    }

    public void append(double d) {
        this.appendSeparator();
        this.setColor(ElementKind.NUMBER);
        if (this.symbols.useScientificNotation(Math.abs(d))) {
            this.buffer.append(d);
        } else {
            this.numberFormat.setMaximumFractionDigits(DecimalFunctions.fractionDigitsForValue((double)d, (int)2));
            this.numberFormat.setMinimumFractionDigits(1);
            this.numberFormat.setRoundingMode(RoundingMode.HALF_EVEN);
            this.numberFormat.format(d, this.buffer, this.dummy);
        }
        this.resetColor();
    }

    public void append(Vector[] vectorArray, int ... nArray) {
        int n;
        CharSequence charSequence;
        int n2;
        int n3;
        boolean bl;
        if (vectorArray == null || vectorArray.length == 0) {
            return;
        }
        if (nArray == null || nArray.length == 0) {
            nArray = WKTUtilities.suggestFractionDigits(vectorArray);
        }
        this.numberFormat.setRoundingMode(RoundingMode.HALF_EVEN);
        int n4 = vectorArray.length;
        boolean bl2 = this.indentation > -1 && n4 > 1;
        boolean bl3 = bl = !this.requestNewLine;
        if (bl2) {
            int n5 = this.margin;
            if (bl) {
                int n6;
                for (n3 = n2 = this.buffer.length(); n3 > 0 && !Characters.isLineOrParagraphSeparator((int)(n6 = this.buffer.codePointBefore(n3))); n3 -= Character.charCount(n6)) {
                }
                n5 = this.buffer.codePointCount(n3, n2);
            }
            charSequence = CharSequences.spaces((int)n5);
        } else {
            charSequence = "";
        }
        int[][] nArrayArray = new int[n4][];
        n2 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            if (n3 == 0) {
                this.appendSeparator();
            } else {
                this.buffer.append(this.separatorNewLine).append(charSequence);
            }
            Vector vector = vectorArray[n3];
            int n7 = vector.size();
            n2 = Math.max(n2, n7);
            int[] object = new int[n7 << 1];
            nArrayArray[n3] = object;
            for (n = 0; n < n7; ++n) {
                if (n != 0) {
                    this.buffer.append(' ');
                }
                if (n < nArray.length) {
                    int n5 = nArray[n];
                    this.numberFormat.setMaximumFractionDigits(n5);
                    this.numberFormat.setMinimumFractionDigits(n5);
                }
                object[n << 1] = this.buffer.length();
                this.setColor(ElementKind.NUMBER);
                Number number = vector.get(n);
                if (number != null) {
                    this.numberFormat.format(number, this.buffer, this.dummy);
                } else {
                    this.buffer.append('\u2026');
                }
                this.resetColor();
                object[n << 1 | 1] = this.buffer.length();
            }
        }
        if (bl2) {
            int n6;
            n3 = this.elementStart;
            String string = this.buffer.substring(n3);
            this.buffer.setLength(n3);
            int[] nArray2 = new int[n2];
            for (int[] nArray3 : nArrayArray) {
                for (int i = 0; i < nArray3.length; i += 2) {
                    int n7 = i >> 1;
                    int n8 = i;
                    int n9 = nArray3[n8] - n3;
                    nArray3[n8] = n9;
                    int n10 = i + 1;
                    nArray3[n10] = nArray3[n10] - n3;
                    n6 = string.codePointCount(n9, nArray3[n10]);
                    if (n6 <= nArray2[n7]) continue;
                    nArray2[n7] = n6;
                }
            }
            if (bl && this.keywordSpaceAt == null) {
                this.keywordSpaceAt = new IntegerList(nArrayArray.length, Integer.MAX_VALUE);
            }
            boolean bl4 = false;
            n = 0;
            for (int[] nArray4 : nArrayArray) {
                boolean bl5;
                n6 = 0;
                while (n6 < nArray4.length) {
                    int n11 = nArray2[n6 >> 1];
                    int n12 = nArray4[n6++];
                    int n13 = nArray4[n6++];
                    this.buffer.append(string, n, n12).append(CharSequences.spaces((int)(n11 - string.codePointCount(n12, n13))));
                    if (bl5) {
                        bl5 = false;
                        this.keywordSpaceAt.add(Integer.valueOf(this.buffer.length()));
                    }
                    this.buffer.append(string, n12, n13);
                    n = n13;
                }
                bl5 = bl;
            }
        }
    }

    private void appendPreset(double d) {
        this.appendSeparator();
        this.setColor(ElementKind.NUMBER);
        this.numberFormat.format(d, this.buffer, this.dummy);
        this.resetColor();
    }

    private void appendExact(double d) {
        if (Locale.ROOT.equals(this.symbols.getLocale())) {
            this.appendSeparator();
            this.setColor(this.highlightError ? ElementKind.ERROR : ElementKind.NUMBER);
            int n = (int)d;
            if ((double)n == d) {
                this.buffer.append(n);
            } else {
                this.buffer.append(d);
            }
            this.resetColor();
        } else {
            this.append(d);
        }
        this.highlightError = false;
    }

    public void append(Unit<?> unit) {
        if (unit != null) {
            Integer n;
            boolean bl = this.longKeywords == 0 ? this.convention.isSimplified() : this.longKeywords < 0;
            boolean bl2 = this.convention.majorVersion() == 1;
            Unit unit2 = unit.getSystemUnit();
            String string = unit2.equals((Object)Units.METRE) ? (bl ? "Unit" : "LengthUnit") : (unit2.equals((Object)Units.RADIAN) ? (bl ? "Unit" : "AngleUnit") : (unit2.equals((Object)Units.UNITY) ? (bl ? "Unit" : "ScaleUnit") : (unit2.equals((Object)Units.SECOND) ? "TimeUnit" : "ParametricUnit")));
            this.openElement(false, string);
            this.setColor(ElementKind.UNIT);
            int n2 = this.buffer.appendCodePoint(this.symbols.getOpeningQuote(0)).length();
            this.unitFormat.format(unit, this.buffer, this.dummy);
            this.closeQuote(n2);
            this.resetColor();
            double d = Units.toStandardUnit(unit);
            if (Double.isNaN(d) && Units.isAngular(unit)) {
                this.appendExact(Math.PI / 180);
            } else {
                this.appendExact(d);
            }
            if ((this.convention == Convention.INTERNAL || Double.isNaN(d)) && (n = Units.getEpsgCode(unit, (boolean)(this.getEnclosingElement(1) instanceof CoordinateSystemAxis))) != null) {
                this.openElement(false, bl2 ? "Authority" : "Id");
                this.append("EPSG", null);
                if (bl2) {
                    this.append(n.toString(), null);
                } else {
                    this.append(n.intValue());
                }
                this.closeElement(false);
            }
            this.closeElement(false);
            if (!(d > 0.0) || string != "Unit" && bl2) {
                this.setInvalidWKT(Unit.class, null);
            }
        }
    }

    public void appendAny(Object object) {
        if (object == null) {
            this.appendSeparator();
            this.buffer.append("null");
        } else if (!this.appendValue(object) && !this.appendElement(object)) {
            this.append(object.toString(), null);
        }
    }

    final boolean appendValue(Object object) {
        if (object instanceof Number) {
            Number number = (Number)object;
            if (Numbers.isInteger(number.getClass())) {
                this.append(number.longValue());
            } else {
                this.append(number.doubleValue());
            }
        } else if (object instanceof CodeList) {
            this.append((CodeList)object);
        } else if (object instanceof Date) {
            this.append((Date)object);
        } else if (object instanceof Boolean) {
            this.append((Boolean)object);
        } else if (object instanceof CharSequence) {
            this.append(object instanceof InternationalString ? ((InternationalString)object).toString(this.locale) : object.toString(), null);
        } else if (object.getClass().isArray()) {
            this.appendSeparator();
            this.elementStart = this.buffer.appendCodePoint(this.symbols.getOpenSequence()).length();
            int n = Array.getLength(object);
            int n2 = n <= this.listSizeLimit ? n : Math.max(this.listSizeLimit / 2 - 1, 1);
            for (int i = 0; i < n; ++i) {
                if (i == n2) {
                    int n3 = n - Math.min(2 * n2, this.listSizeLimit);
                    this.buffer.append(this.symbols.getSeparator());
                    this.setColor(ElementKind.REMARKS);
                    this.buffer.append(Resources.forLocale((Locale)this.locale).getString((short)4, (Object)n3));
                    this.resetColor();
                    i += n3;
                    this.setInvalidWKT(object.getClass().getSimpleName(), null);
                }
                this.appendAny(Array.get(object, i));
            }
            this.buffer.appendCodePoint(this.symbols.getCloseSequence());
        } else {
            return false;
        }
        return true;
    }

    final boolean appendElement(Object object) {
        if (object instanceof FormattableObject) {
            this.append((FormattableObject)object);
        } else if (object instanceof IdentifiedObject) {
            this.append(AbstractIdentifiedObject.castOrCopy((IdentifiedObject)object));
        } else if (object instanceof MathTransform) {
            this.append((MathTransform)object);
        } else if (object instanceof Unit) {
            this.append((Unit)object);
        } else if (object instanceof GeographicBoundingBox) {
            this.append((GeographicBoundingBox)object, 2);
        } else if (object instanceof VerticalExtent) {
            this.appendVerticalExtent((MeasurementRange<Double>)Extents.getVerticalRange((Extent)new SimpleExtent(null, (VerticalExtent)object, null)));
        } else if (object instanceof TemporalExtent) {
            this.appendTemporalExtent((Range<Date>)Extents.getTimeRange((Extent)new SimpleExtent(null, null, (TemporalExtent)object)));
        } else if (object instanceof Position) {
            this.append(AbstractDirectPosition.castOrCopy(((Position)object).getDirectPosition()));
        } else if (object instanceof Envelope) {
            this.append(AbstractEnvelope.castOrCopy((Envelope)object));
        } else {
            return false;
        }
        return true;
    }

    public String delegateTo(Object object) throws UnformattableObjectException {
        ArgumentChecks.ensureNonNull((String)"other", (Object)object);
        if (object instanceof FormattableObject) {
            return ((FormattableObject)object).formatTo(this);
        }
        throw new UnformattableObjectException(Errors.format((short)50, FormattableObject.class, object.getClass()));
    }

    public FormattableObject getEnclosingElement(int n) {
        ArgumentChecks.ensurePositive((String)"depth", (int)n);
        n = this.enclosingElements.size() - 1 - n;
        return n >= 0 ? this.enclosingElements.get(n) : null;
    }

    public boolean hasContextualUnit(int n) {
        ArgumentChecks.ensurePositive((String)"depth", (int)n);
        return (this.hasContextualUnit & Numerics.bitmask((int)n)) != 0L;
    }

    public <Q extends Quantity<Q>> Unit<Q> addContextualUnit(Unit<Q> unit) {
        if (unit == null || this.convention.usesCommonUnits) {
            return null;
        }
        this.hasContextualUnit |= 1L;
        return this.units.put(unit.getSystemUnit(), unit);
    }

    public void restoreContextualUnit(Unit<?> unit, Unit<?> unit2) {
        if (unit2 == null) {
            if (unit != null && this.units.remove(unit.getSystemUnit()) != unit && !this.convention.usesCommonUnits) {
                throw new IllegalStateException();
            }
            this.hasContextualUnit &= 0xFFFFFFFFFFFFFFFEL;
        } else if (this.units.put(unit2.getSystemUnit(), unit2) != unit) {
            throw new IllegalStateException();
        }
    }

    public <Q extends Quantity<Q>> Unit<Q> toContextualUnit(Unit<Q> unit) {
        Unit<?> unit2;
        if (unit != null && (unit2 = this.units.get(unit.getSystemUnit())) != null) {
            return unit2;
        }
        return unit;
    }

    public boolean isInvalidWKT() {
        return this.warnings != null || this.buffer != null && this.buffer.length() == 0;
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = new Warnings(this.errorLocale, false, Collections.emptyMap());
        }
        return this.warnings;
    }

    public void setInvalidWKT(IdentifiedObject identifiedObject, Exception exception) {
        String string;
        ArgumentChecks.ensureNonNull((String)"unformattable", (Object)identifiedObject);
        ReferenceIdentifier referenceIdentifier = identifiedObject.getName();
        if (referenceIdentifier == null || (string = referenceIdentifier.getCode()) == null) {
            string = Formatter.getName(identifiedObject.getClass());
        }
        this.setInvalidWKT(string, exception);
    }

    public void setInvalidWKT(Class<?> clazz, Exception exception) {
        ArgumentChecks.ensureNonNull((String)"unformattable", clazz);
        this.setInvalidWKT(Formatter.getName(clazz), exception);
    }

    private void setInvalidWKT(String string, Exception exception) {
        this.warnings().add(Errors.formatInternational((short)13, (Object[])new Object[]{"WKT", string}), exception, null);
        this.highlightError = true;
    }

    private static String getName(Class<?> clazz) {
        if (!clazz.isInterface()) {
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                if (!clazz2.getName().startsWith("org.opengis.")) continue;
                clazz = clazz2;
                break;
            }
        }
        return Classes.getShortName(clazz);
    }

    final Warnings getWarnings() {
        return this.warnings;
    }

    final void appendWarnings() throws IOException {
        Warnings warnings = this.warnings;
        if (warnings != null) {
            StringBuffer stringBuffer = this.buffer;
            String string = System.lineSeparator();
            stringBuffer.append(string).append(string);
            if (this.colors != null) {
                stringBuffer.append(X364.BACKGROUND_RED.sequence()).append(X364.BOLD.sequence()).append(' ');
            }
            Vocabulary.getResources((Locale)this.errorLocale).appendLabel((short)222, (Appendable)stringBuffer);
            if (this.colors != null) {
                stringBuffer.append(' ').append(X364.RESET.sequence()).append(X364.FOREGROUND_RED.sequence());
            }
            stringBuffer.append(string);
            int n = warnings.getNumMessages();
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < n; ++i) {
                String string2 = Exceptions.getLocalizedMessage((Throwable)warnings.getException(i), (Locale)this.errorLocale);
                if (string2 == null) {
                    string2 = warnings.getMessage(i);
                }
                if (!hashSet.add(string2)) continue;
                stringBuffer.append("  \u2022 ").append(string2).append(string);
            }
        }
    }

    public String toWKT() {
        return this.buffer.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(Classes.getShortClassName((Object)this));
        String string = " of ";
        int n = this.enclosingElements.size();
        while (--n >= 0) {
            stringBuilder.append(string).append(Classes.getShortClassName((Object)this.enclosingElements.get(n)));
            string = " inside ";
        }
        return stringBuilder.toString();
    }

    final void clear() {
        if (this.buffer != null) {
            this.buffer.setLength(0);
        }
        this.enclosingElements.clear();
        this.units.clear();
        this.hasContextualUnit = 0L;
        this.elementStart = 0;
        this.colorApplied = 0;
        this.margin = 0;
        this.keywordSpaceAt = null;
        this.requestNewLine = false;
        this.isComplement = false;
        this.highlightError = false;
        this.warnings = null;
    }
}

