/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.value;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.value.EditableBinaryValue;
import org.exoplatform.services.jcr.core.value.ReadableBinaryValue;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.core.value.BaseValue;
import org.exoplatform.services.jcr.impl.dataflow.EditableValueData;
import org.exoplatform.services.jcr.impl.dataflow.SpoolConfig;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;

public class BinaryValue
extends BaseValue
implements EditableBinaryValue,
ReadableBinaryValue {
    public static final int TYPE = 2;
    protected boolean changed;
    protected final SpoolConfig spoolConfig;

    public BinaryValue(InputStream stream, SpoolConfig spoolConfig) throws IOException {
        this(new TransientValueData(0, stream, null, spoolConfig), spoolConfig);
    }

    BinaryValue(ValueData data, SpoolConfig spoolConfig) {
        super(2, data);
        this.spoolConfig = spoolConfig;
    }

    @Override
    public void update(InputStream stream, long length, long position) throws IOException, RepositoryException {
        if (!this.changed) {
            this.internalData = this.createEditableCopy(this.getInternalData());
        }
        ((EditableValueData)this.internalData).update(stream, length, position);
        this.invalidateStream();
    }

    @Override
    public void setLength(long size) throws IOException, RepositoryException {
        if (!this.changed) {
            this.internalData = this.createEditableCopy(this.getInternalData());
        }
        ((EditableValueData)this.internalData).setLength(size);
        this.invalidateStream();
    }

    private EditableValueData createEditableCopy(ValueData oldValue) throws RepositoryException, IllegalStateException, IOException {
        if (oldValue.isByteArray()) {
            byte[] oldBytes = oldValue.getAsByteArray();
            byte[] newBytes = new byte[oldBytes.length];
            System.arraycopy(oldBytes, 0, newBytes, 0, newBytes.length);
            try {
                return new EditableValueData(newBytes, oldValue.getOrderNumber());
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        try {
            return new EditableValueData(oldValue.getAsStream(), oldValue.getOrderNumber(), this.spoolConfig);
        }
        catch (FileNotFoundException e) {
            throw new RepositoryException("Create editable copy error. " + String.valueOf(e), (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException("Create editable copy error. " + String.valueOf(e), (Throwable)e);
        }
    }
}

