/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib;

import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionManager;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MFile;
import ucar.nc2.grib.collection.GribCollection;
import ucar.nc2.grib.grib1.Grib1Index;
import ucar.nc2.grib.grib2.Grib2Index;
import ucar.unidata.io.RandomAccessFile;

public abstract class GribIndex {
    public static final String GBX9_IDX = ".gbx9";
    public static final boolean debug = false;
    private static final CollectionManager.ChangeChecker gribCC = new CollectionManager.ChangeChecker(){

        public boolean hasChangedSince(MFile file, long when) {
            File idxFile = GribCollection.getFileInCache(file.getPath() + GribIndex.GBX9_IDX);
            if (!idxFile.exists()) {
                return true;
            }
            long idxLastModified = idxFile.lastModified();
            if (idxLastModified < file.getLastModified()) {
                return true;
            }
            return 0L < when && when < idxLastModified;
        }

        public boolean hasntChangedSince(MFile file, long when) {
            File idxFile = GribCollection.getFileInCache(file.getPath() + GribIndex.GBX9_IDX);
            if (!idxFile.exists()) {
                return true;
            }
            if (idxFile.lastModified() < file.getLastModified()) {
                return true;
            }
            return 0L < when && idxFile.lastModified() < when;
        }
    };

    public static CollectionManager.ChangeChecker getChangeChecker() {
        return gribCC;
    }

    public static GribIndex readOrCreateIndexFromSingleFile(boolean isGrib1, boolean createCollectionIndex, MFile mfile, FeatureCollectionConfig.GribConfig config, CollectionUpdateType force, Logger logger) throws IOException {
        GribIndex index;
        GribIndex gribIndex = index = isGrib1 ? new Grib1Index() : new Grib2Index();
        if (!index.readIndex(mfile.getPath(), mfile.getLastModified(), force)) {
            index.makeIndex(mfile.getPath(), null);
            logger.debug("  Index written: {} == {} records", (Object)(mfile.getName() + GBX9_IDX), (Object)index.getNRecords());
        }
        if (!createCollectionIndex) {
            return index;
        }
        return index;
    }

    public abstract boolean readIndex(String var1, long var2, CollectionUpdateType var4) throws IOException;

    public abstract boolean makeIndex(String var1, RandomAccessFile var2) throws IOException;

    public abstract int getNRecords();
}

