/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.lock.cacheable;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.dataflow.ChangesLogIterator;
import org.exoplatform.services.jcr.dataflow.CompositeChangesLog;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListener;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.backup.Backupable;
import org.exoplatform.services.jcr.impl.backup.DataRestore;
import org.exoplatform.services.jcr.impl.backup.DummyDataRestore;
import org.exoplatform.services.jcr.impl.backup.rdbms.DataRestoreContext;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.lock.LockRemover;
import org.exoplatform.services.jcr.impl.core.lock.LockRemoverHolder;
import org.exoplatform.services.jcr.impl.core.lock.LockTableHandler;
import org.exoplatform.services.jcr.impl.core.lock.SessionLockManager;
import org.exoplatform.services.jcr.impl.core.lock.cacheable.CacheableLockManager;
import org.exoplatform.services.jcr.impl.core.lock.cacheable.CacheableSessionLockManager;
import org.exoplatform.services.jcr.impl.core.lock.cacheable.LockData;
import org.exoplatform.services.jcr.impl.dataflow.TransientItemData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.jcr.impl.storage.JCRInvalidItemStateException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.transaction.ActionNonTxAware;
import org.picocontainer.Startable;

public abstract class AbstractCacheableLockManager
implements CacheableLockManager,
ItemsPersistenceListener,
Startable,
Backupable {
    public static final String TIME_OUT = "time-out";
    public static final long DEFAULT_LOCK_TIMEOUT = 1800000L;
    protected final DataManager dataManager;
    protected long lockTimeOut;
    protected LockRemover lockRemover;
    protected final WorkspaceEntry config;
    protected Map<String, CacheableSessionLockManager> sessionLockManagers;
    protected TransactionManager tm;
    protected DataSource dataSource;
    public static final String LOCKS_FORCE_REMOVE = "org.exoplatform.jcr.locks.force.remove";
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.AbstractCacheableLockManager");
    protected LockActionNonTxAware<Integer, Object> getNumLocks;
    protected LockActionNonTxAware<Boolean, Object> hasLocks;
    protected LockActionNonTxAware<Boolean, String> isLockLive;
    protected LockActionNonTxAware<Object, LockData> refresh;
    protected LockActionNonTxAware<Boolean, String> lockExist;
    protected LockActionNonTxAware<LockData, String> getLockDataById;
    protected LockActionNonTxAware<List<LockData>, Object> getLockList;

    public AbstractCacheableLockManager(WorkspacePersistentDataManager dataManager, WorkspaceEntry config, TransactionManager transactionManager, LockRemoverHolder lockRemoverHolder) throws RepositoryConfigurationException {
        if (config.getLockManager() != null) {
            if (config.getLockManager().hasParameters() && config.getLockManager().getParameterValue(TIME_OUT, null) != null) {
                long timeOut = config.getLockManager().getParameterTime(TIME_OUT);
                this.lockTimeOut = timeOut > 0L ? timeOut : 1800000L;
            }
        } else {
            this.lockTimeOut = 1800000L;
        }
        this.config = config;
        this.dataManager = dataManager;
        this.sessionLockManagers = new ConcurrentHashMap<String, CacheableSessionLockManager>();
        this.tm = transactionManager;
        this.lockRemover = lockRemoverHolder.getLockRemover(this);
        dataManager.addItemPersistenceListener(this);
    }

    @Managed
    @ManagedDescription(value="The number of active locks")
    public int getNumLocks() {
        try {
            return (Integer)this.getNumLocks.run();
        }
        catch (LockException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
            return -1;
        }
    }

    protected boolean hasLocks() {
        try {
            return (Boolean)this.hasLocks.run();
        }
        catch (LockException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
            return true;
        }
    }

    @Override
    public boolean isLockLive(String nodeId) throws LockException {
        try {
            return (Boolean)this.isLockLive.run(new String[]{nodeId});
        }
        catch (LockException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
            return false;
        }
    }

    @Override
    public void refreshLockData(LockData newLockData) throws LockException {
        this.refresh.run(new LockData[]{newLockData});
    }

    @Override
    public boolean lockExist(String nodeId) {
        try {
            return (Boolean)this.lockExist.run(new String[]{nodeId});
        }
        catch (LockException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
            return false;
        }
    }

    protected LockData getLockDataById(String nodeId) {
        try {
            return (LockData)this.getLockDataById.run(new String[]{nodeId});
        }
        catch (LockException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
            return null;
        }
    }

    protected synchronized List<LockData> getLockList() {
        try {
            return (List)this.getLockList.run();
        }
        catch (LockException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
            return null;
        }
    }

    @Managed
    @ManagedDescription(value="Remove the expired locks")
    public void cleanExpiredLocks() {
        this.removeExpired();
    }

    @Override
    public long getDefaultLockTimeOut() {
        return this.lockTimeOut;
    }

    @Override
    public SessionLockManager getSessionLockManager(String sessionId, SessionDataManager transientManager) {
        CacheableSessionLockManager sessionManager = new CacheableSessionLockManager(sessionId, this, transientManager);
        this.sessionLockManagers.put(sessionId, sessionManager);
        return sessionManager;
    }

    @Override
    public boolean isTXAware() {
        return true;
    }

    @Override
    public void onSaveItems(ItemStateChangesLog changesLog) {
        ArrayList<PlainChangesLog> chengesLogList = new ArrayList<PlainChangesLog>();
        if (changesLog instanceof TransactionChangesLog) {
            ChangesLogIterator logIterator = ((TransactionChangesLog)changesLog).getLogIterator();
            while (logIterator.hasNextLog()) {
                chengesLogList.add(logIterator.nextLog());
            }
        } else if (changesLog instanceof PlainChangesLog) {
            chengesLogList.add((PlainChangesLog)changesLog);
        } else if (changesLog instanceof CompositeChangesLog) {
            ChangesLogIterator iter = ((CompositeChangesLog)changesLog).getLogIterator();
            while (iter.hasNextLog()) {
                chengesLogList.add(iter.nextLog());
            }
        }
        ArrayList<LockOperationContainer> containers = new ArrayList<LockOperationContainer>();
        block10: for (PlainChangesLog currChangesLog : chengesLogList) {
            String sessionId = currChangesLog.getSessionId();
            try {
                switch (currChangesLog.getEventType()) {
                    case 0x400000: {
                        if (currChangesLog.getSize() < 2) {
                            LOG.error((Object)("Incorrect changes log  of type ExtendedEvent.LOCK size=" + currChangesLog.getSize() + "<2 \n" + currChangesLog.dump()));
                            break;
                        }
                        String nodeIdentifier = currChangesLog.getAllStates().get(0).getData().getParentIdentifier();
                        CacheableSessionLockManager session = this.sessionLockManagers.get(sessionId);
                        if (session != null && session.containsPendingLock(nodeIdentifier)) {
                            containers.add(new LockOperationContainer(nodeIdentifier, currChangesLog.getSessionId(), 0x400000));
                            break;
                        }
                        LOG.error((Object)"Lock must exist in pending locks.");
                        break;
                    }
                    case 0x800000: {
                        if (currChangesLog.getSize() < 2) {
                            LOG.error((Object)("Incorrect changes log  of type ExtendedEvent.UNLOCK size=" + currChangesLog.getSize() + "<2 \n" + currChangesLog.dump()));
                            break;
                        }
                        containers.add(new LockOperationContainer(currChangesLog.getAllStates().get(0).getData().getParentIdentifier(), currChangesLog.getSessionId(), 0x800000));
                        break;
                    }
                    default: {
                        String nodeIdentifier;
                        HashSet<String> removedLock = new HashSet<String>();
                        for (ItemState itemState : currChangesLog.getAllStates()) {
                            if (!itemState.getData().isNode() || !this.lockExist(itemState.getData().getIdentifier())) continue;
                            nodeIdentifier = itemState.getData().getIdentifier();
                            if (itemState.isDeleted()) {
                                removedLock.add(nodeIdentifier);
                                continue;
                            }
                            if (!itemState.isAdded() && !itemState.isRenamed() && !itemState.isUpdated()) continue;
                            removedLock.remove(nodeIdentifier);
                        }
                        for (String identifier : removedLock) {
                            containers.add(new LockOperationContainer(identifier, currChangesLog.getSessionId(), 0x800000));
                        }
                        continue block10;
                    }
                }
            }
            catch (IllegalStateException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        Collections.sort(containers);
        for (LockOperationContainer container : containers) {
            try {
                container.apply();
            }
            catch (LockException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void removeExpired() {
        ArrayList<String> removeLockList = new ArrayList<String>();
        for (LockData lock : this.getLockList()) {
            if (lock.isSessionScoped() || lock.getTimeToDeath() >= 0L) continue;
            removeLockList.add(lock.getNodeIdentifier());
        }
        Collections.sort(removeLockList);
        for (String rLock : removeLockList) {
            this.removeLock(rLock);
        }
    }

    public void start() {
        this.lockRemover.start();
        boolean deleteLocks = "true".equalsIgnoreCase(System.getProperty(LOCKS_FORCE_REMOVE, "false"));
        if (deleteLocks) {
            this.doClean();
        }
    }

    public void stop() {
        this.lockRemover.stop();
        this.sessionLockManagers.clear();
    }

    protected TransientItemData copyItemData(PropertyData prop) throws RepositoryException {
        if (prop == null) {
            return null;
        }
        TransientPropertyData newData = new TransientPropertyData(prop.getQPath(), prop.getIdentifier(), prop.getPersistedVersion(), prop.getType(), prop.getParentIdentifier(), prop.isMultiValued(), prop.getValues());
        return newData;
    }

    protected abstract void internalLock(String var1, String var2) throws LockException;

    protected abstract void internalUnLock(String var1, String var2) throws LockException;

    @Override
    public String getLockTokenHash(String token) {
        String hash = "";
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.update(token.getBytes(), 0, token.length());
            hash = new BigInteger(1, m.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Object)"Can't get instanse of MD5 MessageDigest!", (Throwable)e);
        }
        return hash;
    }

    @Override
    public LockData getExactNodeOrCloseParentLock(NodeData node) throws RepositoryException {
        return this.getExactNodeOrCloseParentLock(node, true);
    }

    private LockData getExactNodeOrCloseParentLock(NodeData node, boolean checkHasLocks) throws RepositoryException {
        NodeData parentData;
        if (node == null || checkHasLocks && !this.hasLocks()) {
            return null;
        }
        LockData retval = null;
        retval = this.getLockDataById(node.getIdentifier());
        if (retval == null && (parentData = (NodeData)this.dataManager.getItemData(node.getParentIdentifier())) != null) {
            retval = this.getExactNodeOrCloseParentLock(parentData, false);
        }
        return retval;
    }

    public LockData getExactNodeLock(NodeData node) throws RepositoryException {
        if (node == null || !this.hasLocks()) {
            return null;
        }
        return this.getLockDataById(node.getIdentifier());
    }

    @Override
    public LockData getClosedChild(NodeData node) throws RepositoryException {
        return this.getClosedChild(node, true);
    }

    private LockData getClosedChild(NodeData node, boolean checkHasLocks) throws RepositoryException {
        if (node == null || checkHasLocks && !this.hasLocks()) {
            return null;
        }
        LockData retval = null;
        List<NodeData> childData = this.dataManager.getChildNodesData(node);
        for (NodeData nodeData : childData) {
            retval = this.getLockDataById(nodeData.getIdentifier());
            if (retval == null) continue;
            return retval;
        }
        for (NodeData nodeData : childData) {
            retval = this.getClosedChild(nodeData, false);
            if (retval == null) continue;
            return retval;
        }
        return retval;
    }

    protected void removeLock(String nodeIdentifier) {
        try {
            NodeData nData = (NodeData)this.dataManager.getItemData(nodeIdentifier);
            if (nData == null) {
                return;
            }
            PlainChangesLogImpl changesLog = new PlainChangesLogImpl(new ArrayList<ItemState>(), IdentityConstants.SYSTEM, 0x800000);
            TransientItemData lockOwner = this.copyItemData((PropertyData)this.dataManager.getItemData(nData, new QPathEntry(Constants.JCR_LOCKOWNER, 1), ItemType.PROPERTY));
            if (lockOwner == null) {
                return;
            }
            changesLog.add(ItemState.createDeletedState(lockOwner));
            TransientItemData lockIsDeep = this.copyItemData((PropertyData)this.dataManager.getItemData(nData, new QPathEntry(Constants.JCR_LOCKISDEEP, 1), ItemType.PROPERTY));
            if (lockIsDeep == null) {
                return;
            }
            changesLog.add(ItemState.createDeletedState(lockIsDeep));
            if (lockOwner == null && lockIsDeep == null) {
                return;
            }
            this.dataManager.save(new TransactionChangesLog(changesLog));
        }
        catch (JCRInvalidItemStateException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"The propperty was removed in other node of cluster.", (Throwable)((Object)e));
            }
        }
        catch (RepositoryException e) {
            LOG.error((Object)("Error occur during removing lock" + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    @Override
    public void closeSessionLockManager(String sessionID) {
        this.sessionLockManagers.remove(sessionID);
    }

    protected void removeAll() {
        List<LockData> locks = this.getLockList();
        for (LockData lockData : locks) {
            this.removeLock(lockData.getNodeIdentifier());
        }
    }

    @Override
    public void clean() throws BackupException {
        LOG.info((Object)"Start to clean lock Data");
        this.doClean();
    }

    @Override
    public void backup(File storageDir) throws BackupException {
        LOG.info((Object)"Start to backup lock data");
        ObjectOutputStream out = null;
        try {
            File contentFile = new File(storageDir, "CacheLocks.dump");
            out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(contentFile)));
            List<LockData> locks = this.getLockList();
            out.writeInt(locks.size());
            for (LockData lockData : locks) {
                lockData.writeExternal(out);
            }
        }
        catch (FileNotFoundException e) {
            throw new BackupException(e);
        }
        catch (IOException e) {
            throw new BackupException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"Can't close output stream", (Throwable)e);
                }
            }
        }
    }

    @Override
    public DataRestore getDataRestorer(DataRestoreContext context) throws BackupException {
        ArrayList<LockData> locks = new ArrayList<LockData>();
        ObjectInputStream in = null;
        try {
            File contentFile = new File((File)context.getObject("storage-dir"), "CacheLocks.dump");
            if (!contentFile.exists()) {
                DummyDataRestore dummyDataRestore = new DummyDataRestore();
                return dummyDataRestore;
            }
            in = new ObjectInputStream(new FileInputStream(contentFile));
            int count = in.readInt();
            for (int i = 0; i < count; ++i) {
                LockData lockData = new LockData();
                lockData.readExternal(in);
                locks.add(lockData);
            }
        }
        catch (FileNotFoundException e) {
            throw new BackupException(e);
        }
        catch (IOException e) {
            throw new BackupException(e);
        }
        catch (ClassNotFoundException e) {
            throw new BackupException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"Can't close output stream", (Throwable)e);
                }
            }
        }
        return new CacheLocksRestore(locks);
    }

    protected abstract boolean isAloneInCluster();

    protected abstract LockData doPut(LockData var1);

    protected abstract void doRemove(LockData var1);

    protected abstract void doClean();

    public abstract LockTableHandler getLockTableHandler();

    protected abstract class LockActionNonTxAware<R, A>
    extends ActionNonTxAware<R, A, LockException> {
        protected LockActionNonTxAware() {
        }

        protected TransactionManager getTransactionManager() {
            return AbstractCacheableLockManager.this.tm;
        }
    }

    private class LockOperationContainer
    implements Comparable<LockOperationContainer> {
        private String identifier;
        private String sessionId;
        private int type;

        public LockOperationContainer(String identifier, String sessionId, int type) {
            this.identifier = identifier;
            this.sessionId = sessionId;
            this.type = type;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public void apply() throws LockException {
            if (this.type == 0x400000) {
                AbstractCacheableLockManager.this.internalLock(this.sessionId, this.identifier);
            } else if (this.type == 0x800000) {
                AbstractCacheableLockManager.this.internalUnLock(this.sessionId, this.identifier);
            }
        }

        @Override
        public int compareTo(LockOperationContainer o) {
            return this.identifier.compareTo(o.getIdentifier());
        }
    }

    protected class CacheLocksRestore
    implements DataRestore {
        private final List<LockData> backupLocks = new ArrayList<LockData>();
        private List<LockData> actualLocks = new ArrayList<LockData>();

        CacheLocksRestore(List<LockData> backupLocks) {
            this.backupLocks.addAll(backupLocks);
        }

        @Override
        public void clean() throws BackupException {
            LOG.info((Object)"Start to clean lock Data");
            this.actualLocks.addAll(AbstractCacheableLockManager.this.getLockList());
            AbstractCacheableLockManager.this.doClean();
        }

        @Override
        public void restore() throws BackupException {
            for (LockData lockData : this.backupLocks) {
                AbstractCacheableLockManager.this.doPut(lockData);
            }
        }

        @Override
        public void commit() throws BackupException {
        }

        @Override
        public void rollback() throws BackupException {
            AbstractCacheableLockManager.this.doClean();
            for (LockData lockData : this.actualLocks) {
                AbstractCacheableLockManager.this.doPut(lockData);
            }
        }

        @Override
        public void close() throws BackupException {
            this.backupLocks.clear();
            this.actualLocks.clear();
        }
    }
}

