/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf;

import java.io.IOException;
import java.net.URI;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.DiscreteSampling;
import org.apache.sis.internal.netcdf.RasterResource;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreClosedException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.WarningEvent;
import org.apache.sis.storage.netcdf.MetadataReader;
import org.apache.sis.storage.netcdf.NetcdfStoreProvider;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Version;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.opengis.metadata.Metadata;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;
import org.opengis.util.NameSpace;

public class NetcdfStore
extends DataStore
implements Aggregate {
    private Decoder decoder;
    private final URI location;
    private Metadata metadata;
    private List<Resource> components;

    public NetcdfStore(NetcdfStoreProvider netcdfStoreProvider, StorageConnector storageConnector) throws DataStoreException {
        super((DataStoreProvider)netcdfStoreProvider, storageConnector);
        this.location = (URI)storageConnector.getStorageAs(URI.class);
        Path path = (Path)storageConnector.getStorageAs(Path.class);
        try {
            this.decoder = NetcdfStoreProvider.decoder(this.listeners, storageConnector);
        }
        catch (IOException | ArithmeticException exception) {
            throw new DataStoreException((Throwable)exception);
        }
        if (this.decoder == null) {
            throw new UnsupportedStorageException(super.getLocale(), "NetCDF", storageConnector.getStorage(), (OpenOption[])storageConnector.getOption(OptionKey.OPEN_OPTIONS));
        }
        this.decoder.location = path;
        String string = Strings.trimOrNull((String)this.decoder.stringValue("id"));
        if (string == null) {
            string = this.decoder.getFilename();
        }
        if (string != null) {
            DefaultNameFactory defaultNameFactory = this.decoder.nameFactory;
            this.decoder.namespace = defaultNameFactory.createNameSpace((GenericName)defaultNameFactory.createLocalName(null, (CharSequence)string), null);
        }
        if (((Object)((Object)this)).getClass() == NetcdfStore.class) {
            this.listeners.useWarningEventsOnly();
        }
    }

    public Optional<ParameterValueGroup> getOpenParameters() {
        return Optional.ofNullable(URIDataStore.parameters((DataStoreProvider)this.provider, (URI)this.location));
    }

    public synchronized Version getConventionVersion() throws DataStoreException {
        for (CharSequence charSequence : CharSequences.split((CharSequence)this.decoder().stringValue("Conventions"), (char)',')) {
            if (!CharSequences.regionMatches((CharSequence)charSequence, (int)0, (CharSequence)"CF-", (boolean)true)) continue;
            return new Version(charSequence.subSequence(3, charSequence.length()).toString());
        }
        return null;
    }

    public Optional<GenericName> getIdentifier() throws DataStoreException {
        NameSpace nameSpace = this.decoder().namespace;
        return nameSpace != null ? Optional.of(nameSpace.name()) : Optional.empty();
    }

    public synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            try {
                MetadataReader metadataReader = new MetadataReader(this.decoder());
                this.metadata = metadataReader.read();
            }
            catch (IOException | ArithmeticException exception) {
                throw new DataStoreException((Throwable)exception);
            }
        }
        return this.metadata;
    }

    public Optional<TreeTable> getNativeMetadata() throws DataStoreException {
        DefaultTreeTable defaultTreeTable = new DefaultTreeTable(new TableColumn[]{TableColumn.NAME, TableColumn.VALUE});
        TreeTable.Node node = defaultTreeTable.getRoot();
        node.setValue(TableColumn.NAME, (Object)"NetCDF");
        this.decoder().addAttributesTo(node);
        return Optional.of(defaultTreeTable);
    }

    public synchronized Collection<Resource> components() throws DataStoreException {
        if (this.components == null) {
            try {
                Decoder decoder = this.decoder();
                DiscreteSampling[] discreteSamplingArray = decoder.getDiscreteSampling((Object)this);
                List<Resource> list = RasterResource.create(decoder, (Object)this);
                if (!list.isEmpty()) {
                    list.addAll((Collection<Resource>)UnmodifiableArrayList.wrap((Object[])discreteSamplingArray));
                    discreteSamplingArray = list.toArray(new Resource[list.size()]);
                }
                this.components = UnmodifiableArrayList.wrap((Object[])discreteSamplingArray);
            }
            catch (IOException iOException) {
                throw new DataStoreException((Throwable)iOException);
            }
        }
        return this.components;
    }

    public <T extends StoreEvent> void addListener(Class<T> clazz, StoreListener<? super T> storeListener) {
        if (storeListener == null || clazz == null || clazz.isAssignableFrom(WarningEvent.class)) {
            super.addListener(clazz, storeListener);
        }
    }

    public synchronized void close() throws DataStoreException {
        Decoder decoder = this.decoder;
        this.decoder = null;
        this.metadata = null;
        this.components = null;
        if (decoder != null) {
            try {
                decoder.close();
            }
            catch (IOException iOException) {
                throw new DataStoreException((Throwable)iOException);
            }
        }
    }

    private Decoder decoder() throws DataStoreClosedException {
        Decoder decoder = this.decoder;
        if (decoder == null) {
            throw new DataStoreClosedException(this.getLocale(), "NetCDF", new OpenOption[]{StandardOpenOption.READ});
        }
        return decoder;
    }

    public String toString() {
        return Strings.bracket(((Object)((Object)this)).getClass(), (Object)this.decoder);
    }
}

