/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.UnknownServiceException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.internal.storage.wkt.StoreFormat;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.storage.DataOptionKey;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Classes;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class PRJDataStore
extends URIDataStore {
    private static final int MAXIMAL_LENGTH = 65536;
    protected static final String PRJ = "prj";
    protected final Charset encoding;
    private final Locale locale;
    private final TimeZone timezone;
    protected CoordinateReferenceSystem crs;

    protected PRJDataStore(DataStoreProvider dataStoreProvider, StorageConnector storageConnector) throws DataStoreException {
        super(dataStoreProvider, storageConnector);
        this.crs = storageConnector.getOption(DataOptionKey.DEFAULT_CRS);
        this.encoding = (Charset)storageConnector.getOption(DataOptionKey.ENCODING);
        this.locale = (Locale)storageConnector.getOption(DataOptionKey.LOCALE);
        this.timezone = (TimeZone)storageConnector.getOption(DataOptionKey.TIMEZONE);
    }

    protected final void readPRJ() throws DataStoreException {
        Exception exception = null;
        try {
            String string = this.readAuxiliaryFile(PRJ).toString();
            StoreFormat storeFormat = new StoreFormat(this.locale, this.timezone, null, this.listeners);
            storeFormat.setConvention(Convention.WKT1_COMMON_UNITS);
            ParsePosition parsePosition = new ParsePosition(0);
            this.crs = (CoordinateReferenceSystem)storeFormat.parse(string, parsePosition);
            if (this.crs != null) {
                storeFormat.validate(this.crs);
                return;
            }
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            this.listeners.warning(Resources.format((short)66, PRJ), iOException);
            return;
        }
        catch (IOException | ClassCastException | ParseException exception2) {
            exception = exception2;
        }
        throw new DataStoreReferencingException(Resources.format((short)66, PRJ), exception);
    }

    protected final AuxiliaryContent readAuxiliaryFile(String string) throws IOException, DataStoreException {
        Object object;
        InputStream inputStream;
        Object object2;
        Path path = this.getSpecifiedPath();
        if (path != null) {
            object2 = PRJDataStore.getBaseFilename(path);
            path = path.resolveSibling(((String)object2).concat(string));
            inputStream = Files.newInputStream(path, new OpenOption[0]);
            object = path;
        } else {
            object2 = IOUtilities.toAuxiliaryURL(this.location, string);
            if (object2 == null) {
                return null;
            }
            inputStream = ((URL)object2).openStream();
            object = object2;
        }
        object2 = this.encoding != null ? new InputStreamReader(inputStream, this.encoding) : new InputStreamReader(inputStream);
        try {
            int n;
            char[] cArray = new char[1024];
            int n2 = 0;
            while ((n = ((InputStreamReader)object2).read(cArray, n2, cArray.length - n2)) >= 0) {
                if ((n2 += n) < cArray.length) continue;
                if (n2 >= 65536) {
                    throw new DataStoreContentException(Resources.forLocale(this.listeners.getLocale()).getString((short)71, IOUtilities.filename(object)));
                }
                cArray = Arrays.copyOf(cArray, n2 * 2);
            }
            AuxiliaryContent auxiliaryContent = new AuxiliaryContent(object, cArray, 0, n2);
            return auxiliaryContent;
        }
        finally {
            if (object2 != null) {
                ((InputStreamReader)object2).close();
            }
        }
    }

    protected final void writePRJ() throws DataStoreException {
        block10: {
            try {
                if (this.crs == null) {
                    this.deleteAuxiliaryFile(PRJ);
                    break block10;
                }
                try (BufferedWriter bufferedWriter = this.writeAuxiliaryFile(PRJ);){
                    StoreFormat storeFormat = new StoreFormat(this.locale, this.timezone, null, this.listeners);
                    storeFormat.format(this.crs, bufferedWriter);
                    bufferedWriter.newLine();
                }
            }
            catch (IOException iOException) {
                String string = this.getIdentifier().orElse(null);
                if (string == null) {
                    string = Classes.getShortClassName((Object)this);
                }
                throw new DataStoreException(Resources.format((short)69, string), iOException);
            }
        }
    }

    protected final BufferedWriter writeAuxiliaryFile(String string) throws IOException, DataStoreException {
        Path[] pathArray = super.getComponentFiles();
        if (pathArray.length == 0) {
            throw new UnknownServiceException();
        }
        Path path = pathArray[0];
        String string2 = PRJDataStore.getBaseFilename(path);
        path = path.resolveSibling(string2.concat(string));
        return this.encoding != null ? Files.newBufferedWriter(path, this.encoding, new OpenOption[0]) : Files.newBufferedWriter(path, new OpenOption[0]);
    }

    protected final void deleteAuxiliaryFile(String string) throws DataStoreException, IOException {
        for (Path path : super.getComponentFiles()) {
            String string2 = PRJDataStore.getBaseFilename(path);
            path = path.resolveSibling(string2.concat(string));
            Files.deleteIfExists(path);
        }
    }

    @Override
    public Path[] getComponentFiles() throws DataStoreException {
        return this.listComponentFiles(PRJ);
    }

    protected final Path[] listComponentFiles(String ... stringArray) throws DataStoreException {
        Object[] objectArray = super.getComponentFiles();
        int n = objectArray.length;
        if (n != 0) {
            Path path = objectArray[0];
            String string = PRJDataStore.getBaseFilename(path);
            for (String string2 : stringArray) {
                Path path2;
                if (string2 == null || !Files.isRegularFile(path2 = path.resolveSibling(string.concat(string2)), new LinkOption[0])) continue;
                if (n >= objectArray.length) {
                    objectArray = (Path[])Arrays.copyOf(objectArray, n + stringArray.length);
                }
                objectArray[n++] = path2;
            }
            objectArray = (Path[])ArraysExt.resize((Object[])objectArray, (int)n);
        }
        return objectArray;
    }

    private static String getBaseFilename(Path path) {
        String string = path.getFileName().toString();
        int n = string.lastIndexOf(46);
        return n >= 0 ? string.substring(0, n + 1) : string + '.';
    }

    @Override
    public Optional<ParameterValueGroup> getOpenParameters() {
        ParameterValueGroup parameterValueGroup = PRJDataStore.parameters(this.provider, this.location);
        if (parameterValueGroup != null) {
            parameterValueGroup.parameter("defaultCRS").setValue((Object)this.crs);
            return Optional.of(parameterValueGroup);
        }
        return Optional.empty();
    }

    protected static final class AuxiliaryContent
    implements CharSequence {
        private final Object source;
        private final char[] buffer;
        private final int offset;
        private final int length;

        private AuxiliaryContent(Object object, char[] cArray, int n, int n2) {
            this.source = object;
            this.buffer = cArray;
            this.offset = n;
            this.length = n2;
        }

        public String getFilename() {
            return IOUtilities.filename(this.source);
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public char charAt(int n) {
            return this.buffer[this.offset + n];
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return new AuxiliaryContent(this.source, this.buffer, this.offset + n, n2 - n);
        }

        @Override
        public String toString() {
            return new String(this.buffer, this.offset, this.length);
        }
    }

    public static abstract class Provider
    extends URIDataStore.Provider {
        static final String CRS_NAME = "defaultCRS";
        public static final ParameterDescriptor<CoordinateReferenceSystem> DEFAULT_CRS;

        protected Provider() {
        }

        @Override
        protected ParameterDescriptorGroup build(ParameterBuilder parameterBuilder) {
            return parameterBuilder.createGroup(new GeneralParameterDescriptor[]{LOCATION_PARAM, DEFAULT_CRS});
        }

        @Override
        public DataStore open(ParameterValueGroup parameterValueGroup) throws DataStoreException {
            ArgumentChecks.ensureNonNull((String)"parameter", (Object)parameterValueGroup);
            StorageConnector storageConnector = Provider.connector(this, parameterValueGroup);
            Parameters parameters = Parameters.castOrWrap((ParameterValueGroup)parameterValueGroup);
            storageConnector.setOption(DataOptionKey.DEFAULT_CRS, (CoordinateReferenceSystem)parameters.getValue(DEFAULT_CRS));
            return this.open(storageConnector);
        }

        static {
            ParameterBuilder parameterBuilder = new ParameterBuilder();
            DEFAULT_CRS = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addName((CharSequence)CRS_NAME)).setDescription((CharSequence)Vocabulary.formatInternational((short)36))).create(CoordinateReferenceSystem.class, null);
        }
    }
}

