/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.cas;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.exoplatform.services.database.utils.DialectDetecter;
import org.exoplatform.services.database.utils.JDBCUtils;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.storage.value.cas.RecordAlreadyExistsException;
import org.exoplatform.services.jcr.impl.storage.value.cas.RecordNotFoundException;
import org.exoplatform.services.jcr.impl.storage.value.cas.VCASException;
import org.exoplatform.services.jcr.impl.storage.value.cas.ValueContentAddressStorage;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class JDBCValueContentAddressStorageImpl
implements ValueContentAddressStorage {
    public static final String JDBC_SOURCE_NAME_PARAM = "jdbc-source-name";
    public static final String JDBC_DIALECT_PARAM = "jdbc-dialect";
    public static final String TABLE_NAME_PARAM = "jdbc-table-name";
    public static final String DEFAULT_TABLE_NAME = "JCR_VCAS";
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.JDBCValueContentAddressStorageImpl");
    private static final String MYSQL_PK_CONSTRAINT_DETECT_PATTERN = "(.*Constraint+.*Violation+.*Duplicate+.*entry+.*)+?";
    private static final Pattern MYSQL_PK_CONSTRAINT_DETECT = Pattern.compile("(.*Constraint+.*Violation+.*Duplicate+.*entry+.*)+?", 2);
    private static final String DB2_PK_CONSTRAINT_DETECT_PATTERN = "(.*DB2 SQL [Ee]rror+.*SQLCODE[:=].?-803+.*SQLSTATE[:=].?23505+.*%s.*)+?";
    private static final String H2_PK_CONSTRAINT_DETECT_PATTERN = "(.*JdbcSQLException.*violation.*PRIMARY_KEY_.*)";
    private static final Pattern H2_PK_CONSTRAINT_DETECT = Pattern.compile("(.*JdbcSQLException.*violation.*PRIMARY_KEY_.*)", 2);
    private Pattern DB2_PK_CONSTRAINT_DETECT;
    protected DataSource dataSource;
    protected String tableName;
    protected String dialect;
    protected String sqlAddRecord;
    protected String sqlDeleteRecord;
    protected String sqlDeleteValueRecord;
    protected String sqlSelectRecord;
    protected String sqlSelectRecords;
    protected String sqlSelectOwnRecords;
    protected String sqlSelectSharingProps;
    protected String sqlConstraintPK;
    protected String sqlVCASIDX;

    @Override
    public void init(Properties props) throws RepositoryConfigurationException, VCASException {
        String sn = props.getProperty(JDBC_SOURCE_NAME_PARAM);
        if (sn == null) {
            throw new RepositoryConfigurationException("jdbc-source-name parameter expected!");
        }
        try {
            this.dataSource = (DataSource)new InitialContext().lookup(sn);
            Connection conn = null;
            Statement st = null;
            try {
                conn = this.dataSource.getConnection();
                DatabaseMetaData dbMetaData = conn.getMetaData();
                String dialect = props.getProperty(JDBC_DIALECT_PARAM);
                dialect = dialect.toUpperCase();
                if (dialect == null || dialect.startsWith("AUTO")) {
                    dialect = DialectDetecter.detect((DatabaseMetaData)dbMetaData);
                }
                this.dialect = dialect;
                String tn = props.getProperty(TABLE_NAME_PARAM);
                this.tableName = tn != null ? tn : DEFAULT_TABLE_NAME;
                String pattern = String.format(DB2_PK_CONSTRAINT_DETECT_PATTERN, this.tableName);
                this.DB2_PK_CONSTRAINT_DETECT = Pattern.compile(pattern, 2);
                this.sqlConstraintPK = this.tableName + "_PK";
                this.sqlVCASIDX = this.tableName + "_IDX";
                if (dialect.startsWith("PGSQL") || dialect.startsWith("INGRES")) {
                    this.tableName = this.tableName.toUpperCase().toLowerCase();
                    this.sqlConstraintPK = this.sqlConstraintPK.toUpperCase().toLowerCase();
                    this.sqlVCASIDX = this.sqlVCASIDX.toUpperCase().toLowerCase();
                }
                this.sqlAddRecord = "INSERT INTO " + this.tableName + " (PROPERTY_ID, ORDER_NUM, CAS_ID) VALUES(?,?,?)";
                this.sqlDeleteRecord = "DELETE FROM " + this.tableName + " WHERE PROPERTY_ID=?";
                this.sqlDeleteValueRecord = "DELETE FROM " + this.tableName + " WHERE PROPERTY_ID=? AND ORDER_NUM=?";
                this.sqlSelectRecord = "SELECT CAS_ID FROM " + this.tableName + " WHERE PROPERTY_ID=? AND ORDER_NUM=?";
                this.sqlSelectRecords = "SELECT CAS_ID, ORDER_NUM FROM " + this.tableName + " WHERE PROPERTY_ID=? ORDER BY ORDER_NUM";
                this.sqlSelectOwnRecords = "SELECT P.CAS_ID, P.ORDER_NUM, S.CAS_ID as SHARED_ID FROM " + this.tableName + " P LEFT JOIN " + this.tableName + " S ON P.PROPERTY_ID<>S.PROPERTY_ID AND P.CAS_ID=S.CAS_ID WHERE P.PROPERTY_ID=? GROUP BY P.CAS_ID, P.ORDER_NUM, S.CAS_ID ORDER BY P.ORDER_NUM";
                this.sqlSelectSharingProps = "SELECT DISTINCT C.PROPERTY_ID AS PROPERTY_ID FROM " + this.tableName + " C, " + this.tableName + " P WHERE C.CAS_ID=P.CAS_ID AND C.PROPERTY_ID<>P.PROPERTY_ID AND P.PROPERTY_ID=?";
                if (!JDBCUtils.tableExists((String)this.tableName, (Connection)conn)) {
                    st = conn.createStatement();
                    st.executeUpdate("CREATE TABLE " + this.tableName + " (PROPERTY_ID VARCHAR(96) NOT NULL, ORDER_NUM INTEGER NOT NULL, CAS_ID VARCHAR(512) NOT NULL, CONSTRAINT " + this.sqlConstraintPK + " PRIMARY KEY(PROPERTY_ID, ORDER_NUM))");
                    if (dialect.startsWith("MYSQL-UTF8")) {
                        st.executeUpdate("CREATE INDEX " + this.sqlVCASIDX + " ON " + this.tableName + "(CAS_ID (255), PROPERTY_ID, ORDER_NUM)");
                    } else {
                        st.executeUpdate("CREATE INDEX " + this.sqlVCASIDX + " ON " + this.tableName + "(CAS_ID, PROPERTY_ID, ORDER_NUM)");
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("JDBC Value Content Address Storage initialized in database " + sn));
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("JDBC Value Content Address Storage already initialized in database " + sn));
                }
            }
            catch (SQLException e) {
                throw new VCASException("VCAS INIT database error: " + String.valueOf(e), e);
            }
            finally {
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e) {
                        LOG.error((Object)("Can't close the Statement: " + e.getMessage()));
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        throw new VCASException("VCAS INIT database error on Connection close: " + String.valueOf(e), e);
                    }
                }
            }
        }
        catch (NamingException e) {
            throw new RepositoryConfigurationException("JDBC data source is not available in JNDI with name '" + sn + "'. Error: " + String.valueOf(e), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addValue(String propertyId, int orderNum, String identifier) throws VCASException {
        try (Connection con = this.dataSource.getConnection();){
            PreparedStatement ps = con.prepareStatement(this.sqlAddRecord);
            ps.setString(1, propertyId);
            ps.setInt(2, orderNum);
            ps.setString(3, identifier);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            if (this.isRecordAlreadyExistsException(e)) {
                throw new RecordAlreadyExistsException("Record already exists, propertyId=" + propertyId + " orderNum=" + orderNum + ". Error: " + String.valueOf(e), e);
            }
            throw new VCASException("VCAS ADD database error: " + String.valueOf(e), e);
        }
    }

    private boolean isRecordAlreadyExistsException(SQLException e) {
        String err = e.toString();
        if (this.dialect.startsWith("MYSQL")) {
            return MYSQL_PK_CONSTRAINT_DETECT.matcher(err).find();
        }
        if (err.toLowerCase().toUpperCase().indexOf(this.sqlConstraintPK.toLowerCase().toUpperCase()) >= 0) {
            return true;
        }
        if (this.dialect.startsWith("DB2")) {
            return this.DB2_PK_CONSTRAINT_DETECT.matcher(err).find();
        }
        if (this.dialect.startsWith("H2")) {
            return H2_PK_CONSTRAINT_DETECT.matcher(err).find();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteProperty(String propertyId) throws VCASException {
        try (Connection con = this.dataSource.getConnection();){
            PreparedStatement ps = con.prepareStatement(this.sqlDeleteRecord);
            ps.setString(1, propertyId);
            int res = ps.executeUpdate();
            ps.close();
            if (res <= 0) {
                throw new RecordNotFoundException("Record not found, propertyId=" + propertyId);
            }
        }
        catch (SQLException e) {
            throw new VCASException("VCAS DELETE database error: " + String.valueOf(e), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteValue(String propertyId, int orderNumb) throws VCASException {
        try (Connection con = this.dataSource.getConnection();){
            PreparedStatement ps = con.prepareStatement(this.sqlDeleteValueRecord);
            ps.setString(1, propertyId);
            ps.setInt(2, orderNumb);
            int res = ps.executeUpdate();
            ps.close();
            if (res <= 0) {
                throw new RecordNotFoundException("Value record not found, propertyId=" + propertyId + " orderNumb=" + orderNumb);
            }
        }
        catch (SQLException e) {
            throw new VCASException("VCAS Value DELETE database error: " + String.valueOf(e), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getIdentifier(String propertyId, int orderNum) throws VCASException {
        try {
            Connection con = this.dataSource.getConnection();
            ResultSet rs = null;
            PreparedStatement ps = null;
            try {
                ps = con.prepareStatement(this.sqlSelectRecord);
                ps.setString(1, propertyId);
                ps.setInt(2, orderNum);
                rs = ps.executeQuery();
                if (!rs.next()) throw new RecordNotFoundException("No record found with propertyId=" + propertyId + " orderNum=" + orderNum);
                String string = rs.getString("CAS_ID");
                return string;
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e) {
                        LOG.error((Object)("Can't close the Statement: " + e.getMessage()));
                    }
                }
                con.close();
            }
        }
        catch (SQLException e) {
            throw new VCASException("VCAS GET ID database error: " + String.valueOf(e), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> getIdentifiers(String propertyId, boolean ownOnly) throws VCASException {
        try {
            Connection con = this.dataSource.getConnection();
            Statement ps = null;
            ResultSet rs = null;
            try {
                ArrayList<String> ids = new ArrayList<String>();
                if (ownOnly) {
                    ps = con.prepareStatement(this.sqlSelectOwnRecords);
                    ps.setString(1, propertyId);
                    rs = ps.executeQuery();
                    if (!rs.next()) throw new RecordNotFoundException("No records found with propertyId=" + propertyId);
                    do {
                        rs.getString("SHARED_ID");
                        if (!rs.wasNull()) continue;
                        ids.add(rs.getString("CAS_ID"));
                    } while (rs.next());
                    ArrayList<String> arrayList = ids;
                    return arrayList;
                }
                ps = con.prepareStatement(this.sqlSelectRecords);
                ps.setString(1, propertyId);
                rs = ps.executeQuery();
                if (!rs.next()) throw new RecordNotFoundException("No records found with propertyId=" + propertyId);
                do {
                    ids.add(rs.getString("CAS_ID"));
                } while (rs.next());
                ArrayList<String> arrayList = ids;
                return arrayList;
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e) {
                        LOG.error((Object)("Can't close the Statement: " + e.getMessage()));
                    }
                }
                con.close();
            }
        }
        catch (SQLException e) {
            throw new VCASException("VCAS GET IDs database error: " + String.valueOf(e), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasSharedContent(String propertyId) throws VCASException {
        boolean bl;
        Connection con;
        block10: {
            con = this.dataSource.getConnection();
            PreparedStatement ps = null;
            try {
                ps = con.prepareStatement(this.sqlSelectSharingProps);
                ps.setString(1, propertyId);
                bl = ps.executeQuery().next();
                if (ps == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException e) {
                            LOG.error((Object)("Can't close the Statement: " + e.getMessage()));
                        }
                    }
                    con.close();
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new VCASException("VCAS HAS SHARED IDs database error: " + String.valueOf(e), e);
                }
            }
            try {
                ps.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the Statement: " + e.getMessage()));
            }
        }
        con.close();
        return bl;
    }
}

