/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage.j2d;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.util.Collections;
import java.util.Map;
import org.apache.sis.image.PlanarImage;
import org.apache.sis.internal.coverage.j2d.DeferredProperty;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;

public class TiledImage
extends PlanarImage {
    private final ColorModel colorModel;
    private final int width;
    private final int height;
    private final int minTileX;
    private final int minTileY;
    private final Raster[] tiles;
    private final Map<String, Object> properties;

    public TiledImage(Map<String, Object> map, ColorModel colorModel, int n, int n2, int n3, int n4, Raster ... rasterArray) {
        ArgumentChecks.ensureStrictlyPositive((String)"width", (int)n);
        ArgumentChecks.ensureStrictlyPositive((String)"height", (int)n2);
        ArgumentChecks.ensureNonEmpty((String)"tiles", (Object[])rasterArray);
        this.colorModel = colorModel;
        this.width = n;
        this.height = n2;
        this.minTileX = n3;
        this.minTileY = n4;
        this.tiles = rasterArray;
        this.properties = map != null ? JDK9.copyOf(map) : Collections.emptyMap();
    }

    @Override
    public String verify() {
        int n = this.getMinX();
        int n2 = this.getMinY();
        int n3 = this.getNumXTiles();
        int n4 = this.getTileWidth();
        int n5 = this.getTileHeight();
        SampleModel sampleModel = this.getSampleModel();
        for (int i = 0; i < this.tiles.length; ++i) {
            Raster raster = this.tiles[i];
            int n6 = i % n3;
            int n7 = i / n3;
            int n8 = n + n6 * n4;
            int n9 = n2 + n7 * n5;
            if (raster.getMinX() != n8) {
                return TiledImage.property(n6, n7, "x");
            }
            if (raster.getMinY() != n9) {
                return TiledImage.property(n6, n7, "y");
            }
            int n10 = raster.getWidth();
            int n11 = raster.getHeight();
            if (n10 != n4 || n11 != n5) {
                if (n10 != Math.min(n4, this.width - n8)) {
                    return TiledImage.property(n6, n7, "width");
                }
                if (n11 != Math.min(n5, this.height - n9)) {
                    return TiledImage.property(n6, n7, "height");
                }
            }
            if (sampleModel.equals(raster.getSampleModel())) continue;
            return TiledImage.property(n6, n7, "sampleModel");
        }
        return super.verify();
    }

    private static String property(int n, int n2, String string) {
        return "tiles[" + n + ", " + n2 + "]." + string;
    }

    @Override
    public ColorModel getColorModel() {
        return this.colorModel;
    }

    @Override
    public SampleModel getSampleModel() {
        return this.tiles[0].getSampleModel();
    }

    @Override
    public Object getProperty(String string) {
        Object object = this.properties.getOrDefault(string, Image.UndefinedProperty);
        if (object instanceof DeferredProperty) {
            object = ((DeferredProperty)object).compute(this);
        }
        return object;
    }

    @Override
    public String[] getPropertyNames() {
        int n = this.properties.size();
        return n == 0 ? null : this.properties.keySet().toArray(new String[n]);
    }

    @Override
    public int getMinX() {
        return this.tiles[0].getMinX();
    }

    @Override
    public int getMinY() {
        return this.tiles[0].getMinY();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getTileWidth() {
        return this.tiles[0].getWidth();
    }

    @Override
    public int getTileHeight() {
        return this.tiles[0].getHeight();
    }

    @Override
    public int getMinTileX() {
        return this.minTileX;
    }

    @Override
    public int getMinTileY() {
        return this.minTileY;
    }

    @Override
    public Raster getTile(int n, int n2) {
        int n3 = this.getNumXTiles();
        int n4 = this.getNumYTiles();
        n = TiledImage.verifyTileIndex("tileX", n, this.minTileX, n3);
        n2 = TiledImage.verifyTileIndex("tileY", n2, this.minTileY, n4);
        return this.tiles[n + n2 * n3];
    }

    private static int verifyTileIndex(String string, int n, int n2, int n3) {
        int n4 = n - n2;
        if (n4 >= 0 && n4 < n3) {
            return n4;
        }
        throw new IndexOutOfBoundsException(Errors.format((short)166, (Object)string, (Object)n2, (Object)(n2 + n3 - 1), (Object)n));
    }
}

