/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.quota;

import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemDataTraversingVisitor;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.core.JCRPath;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.jcr.impl.quota.QuotaManagerException;
import org.exoplatform.services.jcr.impl.quota.QuotaPersister;
import org.exoplatform.services.jcr.impl.quota.WorkspaceQuotaContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CalculateNodeDataSizeTool {
    private final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.CalculateNodeDataSizeTask");
    protected final String wsName;
    protected final String rName;
    protected final QuotaPersister quotaPersister;
    protected final WorkspacePersistentDataManager dataManager;
    protected final LocationFactory lFactory;

    public CalculateNodeDataSizeTool(WorkspaceQuotaContext context) {
        this.wsName = context.wsName;
        this.rName = context.rName;
        this.quotaPersister = context.quotaPersister;
        this.dataManager = context.dataManager;
        this.lFactory = context.lFactory;
    }

    public void getAndSetNodeDataSize(String nodePath) {
        try {
            long dataSize = this.getNodeDataSizeDirectly(nodePath);
            this.quotaPersister.setNodeDataSizeIfQuotaExists(this.rName, this.wsName, nodePath, dataSize);
        }
        catch (QuotaManagerException e) {
            this.LOG.warn((Object)("Can't calculate node data size " + nodePath + " because: " + e.getCause().getMessage()));
        }
    }

    public long getNodeDataSizeDirectly(String nodePath) throws QuotaManagerException {
        try {
            NodeData node = (NodeData)this.dataManager.getItemData("00exo0jcr0root0uuid0000000000000");
            JCRPath path = this.lFactory.parseRelPath(nodePath.substring(1));
            for (QPathEntry entry : path.getInternalPath().getEntries()) {
                if ((node = (NodeData)this.dataManager.getItemData(node, entry, ItemType.NODE, false)) != null) continue;
                throw new ItemNotFoundException("Node " + nodePath + " not found in workspace");
            }
            CalculateNodeDataSizeVisitor visitor = new CalculateNodeDataSizeVisitor(this, this.dataManager);
            node.accept(visitor);
            return visitor.getSize();
        }
        catch (RepositoryException e) {
            throw new QuotaManagerException(e.getMessage(), e);
        }
    }

    private class CalculateNodeDataSizeVisitor
    extends ItemDataTraversingVisitor {
        private long size;

        public CalculateNodeDataSizeVisitor(CalculateNodeDataSizeTool calculateNodeDataSizeTool, ItemDataConsumer dataManager) {
            super(dataManager);
        }

        @Override
        protected void entering(PropertyData property, int level) throws RepositoryException {
        }

        @Override
        protected void entering(NodeData node, int level) throws RepositoryException {
            this.size += ((WorkspacePersistentDataManager)this.dataManager).getNodeDataSize(node.getIdentifier());
        }

        @Override
        protected void leaving(PropertyData property, int level) throws RepositoryException {
        }

        @Override
        protected void leaving(NodeData node, int level) throws RepositoryException {
        }

        public long getSize() {
            return this.size;
        }
    }
}

