/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.util.Arrays;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridCoverageProcessor;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.referencing.operation.builder.LinearTransformBuilder;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class DomainLinearizer {
    private boolean gridStartsAtZero;
    private double scale = 1.0;
    private GridCoverageProcessor processor;

    public boolean getGridStartsAtZero() {
        return this.gridStartsAtZero;
    }

    public void setGridStartsAtZero(boolean bl) {
        this.gridStartsAtZero = bl;
    }

    public double getScaleFactor() {
        return this.scale;
    }

    public void setScaleFactor(double d) {
        ArgumentChecks.ensureStrictlyPositive((String)"factor", (double)d);
        this.scale = d;
    }

    private GridCoverageProcessor processor() {
        if (this.processor == null) {
            this.processor = new GridCoverageProcessor();
        }
        return this.processor;
    }

    public GridCoverage apply(GridCoverage gridCoverage) throws TransformException {
        ArgumentChecks.ensureNonNull((String)"coverage", (Object)gridCoverage);
        GridGeometry gridGeometry = gridCoverage.getGridGeometry();
        GridGeometry gridGeometry2 = this.apply(gridGeometry);
        if (gridGeometry.equals(gridGeometry2)) {
            return gridCoverage;
        }
        return this.processor().resample(gridCoverage, gridGeometry2);
    }

    public GridGeometry apply(GridGeometry gridGeometry) throws TransformException {
        ArgumentChecks.ensureNonNull((String)"gg", (Object)gridGeometry);
        if (gridGeometry.nonLinears != 0L) {
            try {
                MathTransform mathTransform = gridGeometry.requireGridToCRS(true);
                GeneralEnvelope generalEnvelope = gridGeometry.extent.toCRS(null, null, null);
                MathTransform mathTransform2 = this.modify(LinearTransformBuilder.approximate((MathTransform)mathTransform, (Envelope)generalEnvelope));
                MathTransform mathTransform3 = MathTransforms.concatenate((MathTransform)mathTransform, (MathTransform)mathTransform2.inverse());
                generalEnvelope = Envelopes.transform((MathTransform)mathTransform3, (Envelope)generalEnvelope);
                int n = generalEnvelope.getDimension();
                long[] lArray = new long[n * 2];
                double[] dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    long l = Math.round(generalEnvelope.getMinimum(i));
                    long l2 = Math.round(generalEnvelope.getMaximum(i));
                    l2 = Math.max(l, Math.decrementExact(l2));
                    if (this.gridStartsAtZero) {
                        l2 = Math.subtractExact(l2, l);
                        dArray[i] = l;
                    } else {
                        lArray[i] = l;
                    }
                    lArray[i + n] = l2;
                }
                mathTransform2 = MathTransforms.concatenate((MathTransform)MathTransforms.translation((double[])dArray), (MathTransform)mathTransform2);
                if (!mathTransform2.equals((Object)mathTransform)) {
                    return new GridGeometry(new GridExtent(gridGeometry.extent, lArray), PixelInCell.CELL_CENTER, mathTransform2, gridGeometry.envelope.getCoordinateReferenceSystem());
                }
            }
            catch (FactoryException factoryException) {
                Throwable throwable = factoryException.getCause();
                if (throwable instanceof TransformException) {
                    throw (TransformException)throwable;
                }
                throw new TransformException(factoryException.getMessage(), (Throwable)factoryException);
            }
        }
        return gridGeometry;
    }

    private MathTransform modify(LinearTransform linearTransform) {
        double[] dArray = new double[linearTransform.getTargetDimensions()];
        Arrays.fill(dArray, this.scale);
        return MathTransforms.concatenate((MathTransform)MathTransforms.scale((double[])dArray), (MathTransform)linearTransform);
    }
}

