/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.internal.referencing.provider.Molodensky;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.datum.DatumShiftGrid;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.DatumShiftTransform;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

abstract class MolodenskyFormula
extends DatumShiftTransform {
    private static final long serialVersionUID = 7684676923384073055L;
    static final double ANGULAR_SCALE = 1.0000000000039175;
    final boolean isSource3D;
    final boolean isTarget3D;
    final boolean isAbridged;
    protected final double tX;
    protected final double tY;
    protected final double tZ;
    final double \u0394a;
    final double \u0394fmod;
    protected final double semiMajor;
    protected final double eccentricitySquared;

    MolodenskyFormula(MolodenskyFormula molodenskyFormula, Ellipsoid ellipsoid, Ellipsoid ellipsoid2, ParameterDescriptorGroup parameterDescriptorGroup) {
        this(ellipsoid2, molodenskyFormula.isTarget3D, ellipsoid, molodenskyFormula.isSource3D, -molodenskyFormula.tX, -molodenskyFormula.tY, -molodenskyFormula.tZ, molodenskyFormula.grid, molodenskyFormula.isAbridged, parameterDescriptorGroup);
    }

    MolodenskyFormula(Ellipsoid ellipsoid, boolean bl, Ellipsoid ellipsoid2, boolean bl2, double d, double d2, double d3, DatumShiftGrid<?, ?> datumShiftGrid, boolean bl3, ParameterDescriptorGroup parameterDescriptorGroup) {
        super(parameterDescriptorGroup, bl, bl2, datumShiftGrid);
        ArgumentChecks.ensureNonNull((String)"source", (Object)ellipsoid);
        ArgumentChecks.ensureNonNull((String)"target", (Object)ellipsoid2);
        DefaultEllipsoid defaultEllipsoid = DefaultEllipsoid.castOrCopy(ellipsoid);
        this.isSource3D = bl;
        this.isTarget3D = bl2;
        this.isAbridged = bl3;
        this.semiMajor = defaultEllipsoid.getSemiMajorAxis();
        this.\u0394a = defaultEllipsoid.semiMajorAxisDifference(ellipsoid2);
        this.tX = d;
        this.tY = d2;
        this.tZ = d3;
        double d4 = defaultEllipsoid.getSemiMinorAxis();
        double d5 = defaultEllipsoid.flatteningDifference(ellipsoid2);
        this.eccentricitySquared = defaultEllipsoid.getEccentricitySquared();
        this.\u0394fmod = bl3 ? this.semiMajor * d5 + (this.semiMajor - d4) * (this.\u0394a / this.semiMajor) : d4 * d5;
        Unit<Length> unit = defaultEllipsoid.getAxisUnit();
        this.setContextParameters(this.semiMajor, d4, unit, ellipsoid2);
        this.completeParameters(this.context, d4, unit, d5);
        this.context.normalizeGeographicInputs(0.0);
        this.context.denormalizeGeographicOutputs(0.0);
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        Unit unit = this.context.getOrCreate(Molodensky.SRC_SEMI_MAJOR).getUnit();
        double d = this.context.getOrCreate(Molodensky.SRC_SEMI_MINOR).doubleValue(unit);
        Parameters parameters = Parameters.castOrWrap(this.getParameterDescriptors().createValue());
        parameters.getOrCreate(Molodensky.SRC_SEMI_MAJOR).setValue(this.semiMajor, unit);
        parameters.getOrCreate(Molodensky.SRC_SEMI_MINOR).setValue(d, unit);
        this.completeParameters(parameters, d, unit, Double.NaN);
        return parameters;
    }

    void completeParameters(Parameters parameters, double d, Unit<?> unit, double d2) {
        parameters.getOrCreate(Molodensky.DIMENSION).setValue(this.getSourceDimensions());
    }

    @Override
    public final int getSourceDimensions() {
        return this.isSource3D ? 3 : 2;
    }

    @Override
    public final int getTargetDimensions() {
        return this.isTarget3D ? 3 : 2;
    }

    final Matrix transform(double d, double d2, double d3, double[] dArray, int n, double d4, double d5, double d6, double[] dArray2, boolean bl) throws TransformException {
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14 = Math.sin(d);
        double d15 = Math.cos(d);
        double d16 = Math.sin(d2);
        double d17 = Math.cos(d2);
        double d18 = d16 * d16;
        double d19 = 1.0 - this.eccentricitySquared * d18;
        double d20 = Math.sqrt(d19);
        double d21 = d19 * d20;
        double d22 = this.semiMajor * (1.0 - this.eccentricitySquared) / d21;
        double d23 = this.semiMajor / d20;
        double d24 = this.\u0394fmod * 2.0;
        if (!this.isAbridged) {
            d22 += d3;
            d23 += d3;
            d24 = d24 * (0.5 / d20 + 0.5 / d21) + this.\u0394a * this.eccentricitySquared / d20;
        }
        while (true) {
            d13 = d5 * d14 + d4 * d15;
            d12 = d5 * d15 - d4 * d14;
            d11 = (d6 + d24 * d16) * d17 - d13 * d16;
            d10 = 1.0000000000039175 / (d23 * d17);
            d9 = 1.0000000000039175 / d22;
            d8 = d + d12 * d10;
            d7 = d2 + d11 * d9;
            if (dArray2 == null) break;
            this.grid.interpolateInCell(this.normalizedToGridX(d8), this.normalizedToGridY(d7), dArray2);
            d4 = -dArray2[0];
            d5 = -dArray2[1];
            d6 = -dArray2[2];
            dArray2 = null;
        }
        if (dArray != null) {
            dArray[n++] = d8;
            dArray[n++] = d7;
            if (this.isTarget3D) {
                double d25 = this.\u0394fmod * d18;
                double d26 = this.\u0394a;
                if (!this.isAbridged) {
                    d25 /= d20;
                    d26 *= d20;
                }
                dArray[n++] = d3 + d13 * d17 + d6 * d16 + d25 - d26;
            }
        }
        if (!bl) {
            return null;
        }
        MatrixSIS matrixSIS = Matrices.createDiagonal(this.getTargetDimensions(), this.getSourceDimensions());
        double d27 = d16 * d17;
        double d28 = this.eccentricitySquared * d27 / d19;
        double d29 = 3.0 * d28 * (1.0 - this.eccentricitySquared) / d19;
        double d30 = d12 * d16;
        double d31 = d12 * d17;
        double d32 = d30 / d17;
        double d33 = -d6 * d16 - d17 * d13 + d24 * (1.0 - 2.0 * d18);
        double d34 = d6 * d17 - d16 * d13;
        if (this.isAbridged) {
            d32 -= d12 * d28;
            d33 -= d11 * d29;
            d34 += d24 * d17 * d16;
        } else {
            double d35;
            double d36;
            double d37 = d29 * d20 * (this.semiMajor / d22);
            d32 -= d28 * d12 * this.semiMajor / (d20 * d23);
            d33 -= d37 * d34 - (this.\u0394fmod * (d28 * 2.0 / (1.0 - this.eccentricitySquared) + (1.0 + 1.0 / d19) * (d28 - d37)) + this.\u0394a * (d28 + 1.0) * this.eccentricitySquared) * d27 / d20;
            if (this.isSource3D) {
                d36 = d12 / d23;
                d35 = -d11 / d22;
                matrixSIS.setElement(0, 2, -d36 * d10);
                matrixSIS.setElement(1, 2, d35 * d9);
            }
            d36 = this.\u0394fmod * (d28 * d18 + 2.0 * d27);
            d35 = this.\u0394a * d28;
            d34 += d36 / d20 + d35 * d20;
        }
        matrixSIS.setElement(0, 0, 1.0 - d13 * d10);
        matrixSIS.setElement(1, 1, 1.0 + d33 * d9);
        matrixSIS.setElement(0, 1, d32 * d10);
        matrixSIS.setElement(1, 0, -d30 * d9);
        if (this.isTarget3D) {
            matrixSIS.setElement(2, 0, d31);
            matrixSIS.setElement(2, 1, d34);
        }
        return matrixSIS;
    }

    @Override
    protected int computeHashCode() {
        int n = super.computeHashCode() + Long.hashCode(Double.doubleToLongBits(this.\u0394a) + Double.doubleToLongBits(this.\u0394fmod) + 31L * (Double.doubleToLongBits(this.tX) + 31L * (Double.doubleToLongBits(this.tY) + 31L * Double.doubleToLongBits(this.tZ))));
        if (this.isAbridged) {
            n ^= 0xFFFFFFFF;
        }
        return n;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            MolodenskyFormula molodenskyFormula = (MolodenskyFormula)object;
            return this.isSource3D == molodenskyFormula.isSource3D && this.isTarget3D == molodenskyFormula.isTarget3D && this.isAbridged == molodenskyFormula.isAbridged && Numerics.epsilonEqual((double)this.tX, (double)molodenskyFormula.tX, (ComparisonMode)comparisonMode) && Numerics.epsilonEqual((double)this.tY, (double)molodenskyFormula.tY, (ComparisonMode)comparisonMode) && Numerics.epsilonEqual((double)this.tZ, (double)molodenskyFormula.tZ, (ComparisonMode)comparisonMode) && Numerics.epsilonEqual((double)this.\u0394a, (double)molodenskyFormula.\u0394a, (ComparisonMode)comparisonMode) && Numerics.epsilonEqual((double)this.\u0394fmod, (double)molodenskyFormula.\u0394fmod, (ComparisonMode)comparisonMode) && Numerics.epsilonEqual((double)this.semiMajor, (double)molodenskyFormula.semiMajor, (ComparisonMode)comparisonMode) && Numerics.epsilonEqual((double)this.eccentricitySquared, (double)molodenskyFormula.eccentricitySquared, (ComparisonMode)comparisonMode);
        }
        return false;
    }
}

