/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.SessionReference;
import org.exoplatform.services.jcr.impl.core.TrackedSession;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;

public class SessionFactory {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.SessionFactory");
    private final ExoContainer container;
    private final String workspaceName;

    public SessionFactory(WorkspaceEntry config, ExoContainerContext containerContext) {
        this.container = containerContext.getContainer();
        this.workspaceName = config.getName();
        boolean tracking = "true".equalsIgnoreCase(System.getProperty("exo.jcr.session.tracking.active", "false"));
        if (tracking) {
            long maxAgeMillis;
            block8: {
                maxAgeMillis = 0L;
                String maxagevalue = System.getProperty("exo.jcr.session.tracking.maxage");
                if (maxagevalue != null) {
                    try {
                        maxAgeMillis = Long.parseLong(maxagevalue) * 1000L;
                    }
                    catch (NumberFormatException e) {
                        if (!LOG.isTraceEnabled()) break block8;
                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                    }
                }
            }
            if (maxAgeMillis <= 0L) {
                maxAgeMillis = 120000L;
            }
            try {
                SessionReference.start(maxAgeMillis);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (config.getContainer().getParameterInteger("lazy-node-iterator-page-size", 100) < 20) {
            config.getContainer().putParameterValue("lazy-node-iterator-page-size", Integer.toString(20));
            LOG.warn((Object)"Value for \"lazy-node-iterator-page-size\" is too small. Using allowed minimum page size : 20.");
        }
    }

    SessionImpl createSession(ConversationState user) throws RepositoryException, LoginException {
        if (SessionReference.isStarted()) {
            return new TrackedSession(this.workspaceName, user, this.container);
        }
        return new SessionImpl(this.workspaceName, user, this.container);
    }
}

