/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gml;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.util.Locale;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.measure.Units;
import org.apache.sis.util.resources.Errors;

@XmlType(name="MeasureType")
public final class Measure {
    private static final UnitFormat UCUM = new UnitFormat(Locale.ROOT);
    @XmlValue
    public double value;
    public Unit<?> unit;
    public boolean asXPointer;

    public Measure() {
        this.value = Double.NaN;
    }

    public Measure(double d, Unit<?> unit) {
        this.value = d;
        this.unit = unit;
    }

    @XmlAttribute(name="uom", required=true)
    public String getUOM() {
        return Measure.getUOM(this.unit, this.asXPointer, false);
    }

    public static String getUOM(Unit<?> unit, boolean bl, boolean bl2) {
        Comparable<Integer> comparable;
        if (!bl && (comparable = Units.getEpsgCode(unit, (boolean)bl2)) != null) {
            return "urn:ogc:def:uom:EPSG::" + comparable;
        }
        if (unit == null || unit.equals((Object)Units.UNITY)) {
            return "";
        }
        Context context = Context.current();
        comparable = Context.schema(context, "gmd", "http://www.isotc211.org/2005/");
        ((StringBuilder)comparable).append("resources/uom/gmxUom.xml").append("#xpointer(//*[@gml:id='");
        try {
            UCUM.format(unit, comparable);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return ((StringBuilder)comparable).append("'])").toString();
    }

    public void setUOM(String string) throws URISyntaxException {
        Context context = Context.current();
        this.unit = Context.converter(context).toUnit(context, string);
    }

    public <Q extends Quantity<Q>> Unit<Q> getUnit(Class<Q> clazz) {
        return this.unit != null ? this.unit.asType(clazz) : null;
    }

    public boolean setUnit(Unit<?> unit) {
        boolean bl = this.unit != null && !this.unit.equals(unit);
        this.unit = unit;
        return bl;
    }

    public static void missingUOM(Class<?> clazz, String string) {
        Context.warningOccured(Context.current(), clazz, string, Errors.class, (short)76, "uom", "Measure");
    }

    static {
        UCUM.setStyle(UnitFormat.Style.UCUM);
    }
}

