/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.filter.sqlmm;

import java.util.Arrays;
import java.util.Collection;
import org.apache.sis.filter.Expression;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.filter.FunctionRegister;
import org.apache.sis.internal.filter.sqlmm.GeometryConstructor;
import org.apache.sis.internal.filter.sqlmm.OneGeometry;
import org.apache.sis.internal.filter.sqlmm.SQLMM;
import org.apache.sis.internal.filter.sqlmm.ST_FromBinary;
import org.apache.sis.internal.filter.sqlmm.ST_FromText;
import org.apache.sis.internal.filter.sqlmm.ST_Point;
import org.apache.sis.internal.filter.sqlmm.ST_Transform;
import org.apache.sis.internal.filter.sqlmm.TwoGeometries;
import org.apache.sis.internal.jdk9.JDK9;

public final class Registry
implements FunctionRegister {
    private final Geometries<?> library;

    public Registry(Geometries<?> geometries) {
        this.library = geometries;
    }

    @Override
    public String getAuthority() {
        return "SQL/MM";
    }

    @Override
    public Collection<String> getNames() {
        return JDK9.toList(Arrays.stream(SQLMM.values()).map(Enum::name));
    }

    @Override
    public <R> Expression<R, ?> create(String string, Expression<? super R, ?>[] expressionArray) {
        SQLMM sQLMM = SQLMM.valueOf(string);
        switch (sQLMM) {
            case ST_PointFromWKB: 
            case ST_LineFromWKB: 
            case ST_PolyFromWKB: 
            case ST_BdPolyFromWKB: 
            case ST_GeomCollFromWKB: 
            case ST_MPointFromWKB: 
            case ST_MLineFromWKB: 
            case ST_MPolyFromWKB: 
            case ST_BdMPolyFromWKB: 
            case ST_GeomFromWKB: {
                return new ST_FromBinary(sQLMM, expressionArray, this.library);
            }
            case ST_PointFromText: 
            case ST_LineFromText: 
            case ST_PolyFromText: 
            case ST_BdPolyFromText: 
            case ST_GeomCollFromText: 
            case ST_MPointFromText: 
            case ST_MLineFromText: 
            case ST_MPolyFromText: 
            case ST_BdMPolyFromText: 
            case ST_GeomFromText: {
                return new ST_FromText(sQLMM, expressionArray, this.library);
            }
            case ST_Polygon: 
            case ST_LineString: 
            case ST_MultiPoint: 
            case ST_MultiLineString: 
            case ST_MultiPolygon: 
            case ST_GeomCollection: {
                return new GeometryConstructor(sQLMM, expressionArray, this.library);
            }
            case ST_Point: {
                return new ST_Point(expressionArray, this.library);
            }
            case ST_Transform: {
                return new ST_Transform(expressionArray, this.library);
            }
        }
        switch (sQLMM.geometryCount()) {
            case 1: {
                if (sQLMM.maxParamCount == 1) {
                    return new OneGeometry(sQLMM, expressionArray, this.library);
                }
                return new OneGeometry.WithArgument(sQLMM, expressionArray, this.library);
            }
            case 2: {
                if (sQLMM.maxParamCount == 2) {
                    return new TwoGeometries(sQLMM, expressionArray, this.library);
                }
                return new TwoGeometries.WithArgument(sQLMM, expressionArray, this.library);
            }
        }
        throw new AssertionError((Object)sQLMM);
    }
}

