/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.jcr.config.QueryHandlerEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;

public class RSyncConfiguration {
    public static final String PARAM_RSYNC_ENTRY_NAME = "rsync-entry-name";
    public static final String PARAM_RSYNC_ENTRY_PATH = "rsync-entry-path";
    public static final String PARAM_RSYNC_PORT = "rsync-port";
    public static final int PARAM_RSYNC_PORT_DEFAULT = 873;
    public static final String PARAM_RSYNC_USER = "rsync-user";
    public static final String PARAM_RSYNC_PASSWORD = "rsync-password";
    public static final String PARAM_RSYNC_OFFLINE = "rsync-offline";
    private String rsyncEntryName;
    private String rsyncEntryPath;
    private String rsyncUserName;
    private String rsyncPassword;
    private int rsyncPort;
    private boolean rsyncOffline;

    public RSyncConfiguration(QueryHandlerEntry config) throws RepositoryConfigurationException {
        this.rsyncEntryName = config.getParameterValue(PARAM_RSYNC_ENTRY_NAME, null);
        this.rsyncEntryPath = config.getParameterValue(PARAM_RSYNC_ENTRY_PATH, null);
        if (StringUtils.isEmpty((CharSequence)this.rsyncEntryName) || StringUtils.isEmpty((CharSequence)this.rsyncEntryPath)) {
            throw new RepositoryConfigurationException("rsync-entry-path or rsync-entry-name path cannot be empty.");
        }
        this.rsyncUserName = config.getParameterValue(PARAM_RSYNC_USER, null);
        this.rsyncPassword = config.getParameterValue(PARAM_RSYNC_PASSWORD, null);
        this.rsyncPort = config.getParameterInteger(PARAM_RSYNC_PORT, 873);
        this.rsyncOffline = config.getParameterBoolean(PARAM_RSYNC_OFFLINE, true);
    }

    public String getRsyncEntryName() {
        return this.rsyncEntryName;
    }

    public String getRsyncEntryPath() {
        return this.rsyncEntryPath;
    }

    public String getRsyncUserName() {
        return this.rsyncUserName;
    }

    public String getRsyncPassword() {
        return this.rsyncPassword;
    }

    public int getRsyncPort() {
        return this.rsyncPort;
    }

    public boolean isRsyncOffline() {
        return this.rsyncOffline;
    }

    public String generateRsyncSource(String path) throws RepositoryConfigurationException {
        String relativeIndexPath;
        String absoluteRsyncEntryPath;
        String indexPath;
        try {
            indexPath = new File(path).getCanonicalPath();
            absoluteRsyncEntryPath = new File(this.rsyncEntryPath).getCanonicalPath();
        }
        catch (IOException e) {
            throw new RepositoryConfigurationException("Index path or rsyncEntry path is invalid.", e);
        }
        if (indexPath.startsWith(absoluteRsyncEntryPath)) {
            relativeIndexPath = indexPath.substring(absoluteRsyncEntryPath.length());
            if (File.separatorChar == '\\') {
                relativeIndexPath = relativeIndexPath.replace(File.separatorChar, '/');
            }
        } else {
            throw new RepositoryConfigurationException("Invalid RSync configuration. Index must be placed in folder that is a descendant of RSync Server Entry. Current RSync Server Entry Path is : " + absoluteRsyncEntryPath + " but it doesnt hold Index folder, that is : " + indexPath + ". Please fix configuration according to JCR Documentation and restart application.");
        }
        String urlFormatString = "rsync://%s:" + this.rsyncPort + "/" + this.rsyncEntryName + relativeIndexPath + "/";
        return urlFormatString;
    }
}

