/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.measure.Latitude;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;

public class SatelliteTracking
extends NormalizedProjection {
    private static final long serialVersionUID = -209787336760184649L;
    private final double cos_i;
    private final double sin_i;
    private final double cos2_i;
    private final double p2_on_p1;
    private final double n;
    private final double s0;
    private final boolean isConic;
    private final double \u03b8_bound;

    static Initializer initializer(OperationMethod operationMethod, Parameters parameters) {
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> enumMap = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        enumMap.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, org.apache.sis.internal.referencing.provider.SatelliteTracking.CENTRAL_MERIDIAN);
        enumMap.put(NormalizedProjection.ParameterRole.LATITUDE_OF_CONFORMAL_SPHERE_RADIUS, org.apache.sis.internal.referencing.provider.SatelliteTracking.LATITUDE_OF_ORIGIN);
        return new Initializer(operationMethod, parameters, enumMap, null);
    }

    public SatelliteTracking(OperationMethod operationMethod, Parameters parameters) {
        this(SatelliteTracking.initializer(operationMethod, parameters));
    }

    private SatelliteTracking(Initializer initializer) {
        super(initializer, null);
        double d = Math.toRadians(initializer.getAndStore(org.apache.sis.internal.referencing.provider.SatelliteTracking.LATITUDE_OF_ORIGIN));
        double d2 = Math.toRadians(initializer.getAndStore(org.apache.sis.internal.referencing.provider.SatelliteTracking.STANDARD_PARALLEL_1));
        double d3 = Math.toRadians(initializer.getAndStore(org.apache.sis.internal.referencing.provider.SatelliteTracking.STANDARD_PARALLEL_2));
        double d4 = Math.toRadians(initializer.getAndStore(org.apache.sis.internal.referencing.provider.SatelliteTracking.SATELLITE_ORBIT_INCLINATION));
        this.p2_on_p1 = initializer.getAndStore(org.apache.sis.internal.referencing.provider.SatelliteTracking.SATELLITE_ORBITAL_PERIOD) / initializer.getAndStore(org.apache.sis.internal.referencing.provider.SatelliteTracking.ASCENDING_NODE_PERIOD);
        this.sin_i = Math.sin(d4);
        this.cos_i = Math.cos(d4);
        this.cos2_i = this.cos_i * this.cos_i;
        this.isConic = Math.abs(d3 + d2) > 1.5706706731410455E-9;
        double d5 = Math.cos(d2);
        double d6 = d5 * d5;
        MatrixSIS matrixSIS = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        if (this.isConic) {
            double d7;
            double d8;
            double d9 = Math.sin(d2);
            double d10 = this.L(Math.sin(d), org.apache.sis.internal.referencing.provider.SatelliteTracking.LATITUDE_OF_ORIGIN);
            double d11 = this.L(d9, org.apache.sis.internal.referencing.provider.SatelliteTracking.STANDARD_PARALLEL_1);
            double d12 = this.F(d6, org.apache.sis.internal.referencing.provider.SatelliteTracking.STANDARD_PARALLEL_1);
            if (Math.abs(d3 - d2) < 1.5706706731410455E-9) {
                this.n = d9 * (this.p2_on_p1 * (2.0 * this.cos2_i - d6) - this.cos_i) / (this.p2_on_p1 * d6 - this.cos_i);
            } else {
                d8 = Math.cos(d3);
                d7 = this.F(d8 * d8, org.apache.sis.internal.referencing.provider.SatelliteTracking.STANDARD_PARALLEL_2);
                double d13 = this.L(Math.sin(d3), org.apache.sis.internal.referencing.provider.SatelliteTracking.STANDARD_PARALLEL_2);
                this.n = (d7 - d12) / (d13 - d11);
            }
            this.s0 = d12 - this.n * d11;
            d8 = d5 * Math.sin(d12) / this.n;
            d7 = d8 / Math.sin(this.n * d10 + this.s0);
            if (!Double.isFinite(d8) || d8 == 0.0) {
                throw this.invalid(org.apache.sis.internal.referencing.provider.SatelliteTracking.STANDARD_PARALLEL_1);
            }
            MatrixSIS matrixSIS2 = this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
            matrixSIS2.convertAfter(0, this.n, null);
            matrixSIS.convertBefore(0, d8, null);
            matrixSIS.convertBefore(1, -d8, d7);
            this.\u03b8_bound = initializer.boundOfScaledLongitude(this.n);
        } else {
            this.\u03b8_bound = Double.NaN;
            this.s0 = Double.NaN;
            this.n = Double.NaN;
            double d14 = Math.sqrt(d6 - this.cos2_i) / (this.p2_on_p1 * d6 - this.cos_i);
            matrixSIS.convertBefore(0, d5, null);
            matrixSIS.convertBefore(1, d5 * d14, null);
            if (!Double.isFinite(d14) || d14 == 0.0) {
                throw this.invalid(org.apache.sis.internal.referencing.provider.SatelliteTracking.STANDARD_PARALLEL_1);
            }
        }
    }

    @Override
    final String[] getInternalParameterNames() {
        return new String[]{"i", "P\u2082\u2215P\u2081"};
    }

    @Override
    final double[] getInternalParameterValues() {
        return new double[]{this.cos_i < 0.7853981633974483 ? Math.acos(this.cos_i) : Math.asin(this.sin_i), this.p2_on_p1};
    }

    private double F(double d, ParameterDescriptor<Double> parameterDescriptor) {
        double d2 = Math.atan((this.p2_on_p1 * d - this.cos_i) / Math.sqrt(d - this.cos2_i));
        if (Double.isFinite(d2)) {
            return d2;
        }
        throw this.invalid(parameterDescriptor);
    }

    private double L(double d, ParameterDescriptor<Double> parameterDescriptor) {
        double d2 = -Math.asin(d / this.sin_i);
        double d3 = Math.atan(Math.tan(d2) * this.cos_i) - this.p2_on_p1 * d2;
        if (Double.isFinite(d3)) {
            return d3;
        }
        throw this.invalid(parameterDescriptor);
    }

    private InvalidParameterValueException invalid(ParameterDescriptor<Double> parameterDescriptor) {
        String string = parameterDescriptor.getName().getCode();
        double d = this.context.doubleValue(parameterDescriptor);
        double d2 = Math.abs(this.context.doubleValue(org.apache.sis.internal.referencing.provider.SatelliteTracking.SATELLITE_ORBIT_INCLINATION));
        return new InvalidParameterValueException(Errors.format((short)166, (Object)string, (Object)(-d2), (Object)d2, (Object)new Latitude(d)), string, d);
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        double d = dArray[n + 1];
        double d2 = Math.sin(d) / this.sin_i;
        double d3 = -Math.asin(d2);
        double d4 = Math.tan(d3);
        double d5 = Math.atan(d4 * this.cos_i);
        double d6 = dArray[n];
        double d7 = d5 - this.p2_on_p1 * d3;
        if (this.isConic) {
            d6 = SatelliteTracking.wraparoundScaledLongitude(d6, this.\u03b8_bound);
            d3 = this.n * d7 + this.s0;
            if ((Double.doubleToRawLongBits(d3) ^ Double.doubleToRawLongBits(this.n)) < 0L) {
                d3 = Double.NaN;
            }
            double d8 = Math.sin(d3);
            d7 = Math.cos(d6) / d8;
            d6 = Math.sin(d6) / d8;
        }
        if (dArray2 != null) {
            dArray2[n2] = d6;
            dArray2[n2 + 1] = d7;
        }
        if (!bl) {
            return null;
        }
        Matrix2 matrix2 = new Matrix2();
        matrix2.m11 = Math.cos(d) / this.sin_i / Math.sqrt(1.0 - d2 * d2) * (this.p2_on_p1 - (1.0 + d4 * d4) * this.cos_i / (1.0 + d5 * d5));
        if (this.isConic) {
            double d9 = -this.n / Math.tan(d3);
            matrix2.m00 = d7;
            matrix2.m10 = -d6;
            matrix2.m01 = d6 * d9 * matrix2.m11;
            matrix2.m11 *= d7 * d9;
        }
        return matrix2;
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d;
        double d2;
        double d3 = dArray[n];
        double d4 = dArray[n + 1];
        if (this.isConic) {
            d2 = Math.copySign(Math.hypot(d3, d4), this.n);
            d3 = Math.atan(d3 / d4);
            d4 = (Math.asin(1.0 / d2) - this.s0) / this.n;
        }
        d2 = 1.0 / this.cos2_i;
        double d5 = this.p2_on_p1 * this.cos_i;
        double d6 = -1.5707963267948966;
        int n3 = 18;
        do {
            if (--n3 < 0) {
                throw new ProjectionException(Resources.format((short)46));
            }
            double d7 = Math.tan(d4 + this.p2_on_p1 * d6) / this.cos_i;
            double d8 = d7 * d7;
            d = (Math.atan(d7) - d6) / (1.0 - d5 * ((d8 + d2) / (d8 + 1.0)));
            d6 += d;
        } while (Math.abs(d) >= 1.5706706731410455E-9);
        dArray2[n2] = d3;
        dArray2[n2 + 1] = -Math.asin(Math.sin(d6) * this.sin_i);
    }
}

