/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.io.Serializable;
import java.util.Objects;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;

public final class GridOrientation
implements Serializable {
    private static final long serialVersionUID = -1354776950822418237L;
    public static final GridOrientation HOMOTHETY = new GridOrientation(0L, null, false);
    public static final GridOrientation REFLECTION_Y = new GridOrientation(2L, null, false);
    public static final GridOrientation DISPLAY = new GridOrientation(2L, AxesConvention.DISPLAY_ORIENTED, false);
    final long flippedAxes;
    final AxesConvention crsVariant;
    final boolean canReorderGridAxis;

    private GridOrientation(long l, AxesConvention axesConvention, boolean bl) {
        this.flippedAxes = l;
        this.crsVariant = axesConvention;
        this.canReorderGridAxis = bl;
    }

    public GridOrientation flipGridAxis(int n) {
        ArgumentChecks.ensurePositive((String)"dimension", (int)n);
        if (n >= 64) {
            throw new IllegalArgumentException(Errors.format((short)37, (Object)(n + 1)));
        }
        return new GridOrientation(this.flippedAxes ^ 1L << n, this.crsVariant, this.canReorderGridAxis);
    }

    public GridOrientation useVariantOfCRS(AxesConvention axesConvention) {
        if (axesConvention == this.crsVariant) {
            return this;
        }
        if (axesConvention == AxesConvention.NORMALIZED) {
            throw new IllegalArgumentException(Errors.format((short)170, (Object)axesConvention));
        }
        return new GridOrientation(this.flippedAxes, axesConvention, this.canReorderGridAxis);
    }

    public GridOrientation canReorderGridAxis(boolean bl) {
        if (bl == this.canReorderGridAxis) {
            return this;
        }
        return new GridOrientation(this.flippedAxes, this.crsVariant, bl);
    }

    public boolean equals(Object object) {
        if (object instanceof GridOrientation) {
            GridOrientation gridOrientation = (GridOrientation)object;
            return this.flippedAxes == gridOrientation.flippedAxes && this.crsVariant == gridOrientation.crsVariant && this.canReorderGridAxis == gridOrientation.canReorderGridAxis;
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(this.flippedAxes) + Objects.hashCode(this.crsVariant) + Boolean.hashCode(this.canReorderGridAxis);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName()).append('[');
        String string = "";
        if (this.flippedAxes != 0L) {
            long l;
            stringBuilder.append("flip={");
            long l2 = this.flippedAxes;
            do {
                l = Long.numberOfTrailingZeros(l2);
                stringBuilder.append(string).append(l);
                string = ", ";
            } while ((l2 &= 1L << (int)l ^ 0xFFFFFFFFFFFFFFFFL) != 0L);
            stringBuilder.append('}');
        }
        if (this.crsVariant != null) {
            stringBuilder.append(string).append("crs=").append(this.crsVariant);
            if (this.canReorderGridAxis) {
                stringBuilder.append(" with grid axis reordering");
            }
        }
        return stringBuilder.append(']').toString();
    }
}

