/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.StoreUtilities;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.IllegalNameException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Localized;
import org.apache.sis.util.collection.TreeTable;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;
import org.opengis.util.ScopedName;

public abstract class DataStore
implements Resource,
Localized,
AutoCloseable {
    protected final DataStoreProvider provider;
    private final String name;
    private Locale locale;
    protected final StoreListeners listeners;

    protected DataStore() {
        this.provider = null;
        this.name = null;
        this.locale = Locale.getDefault(Locale.Category.DISPLAY);
        this.listeners = new StoreListeners(null, this);
    }

    protected DataStore(DataStoreProvider dataStoreProvider, StorageConnector storageConnector) throws DataStoreException {
        ArgumentChecks.ensureNonNull((String)"connector", (Object)storageConnector);
        this.provider = dataStoreProvider;
        this.name = storageConnector.getStorageName();
        this.locale = Locale.getDefault(Locale.Category.DISPLAY);
        this.listeners = new StoreListeners(null, this);
    }

    protected DataStore(DataStore dataStore, DataStoreProvider dataStoreProvider, StorageConnector storageConnector, boolean bl) throws DataStoreException {
        StoreListeners storeListeners;
        ArgumentChecks.ensureNonNull((String)"connector", (Object)storageConnector);
        this.provider = dataStoreProvider;
        this.name = storageConnector.getStorageName();
        if (dataStore != null) {
            this.locale = dataStore.locale;
            if (bl) {
                this.listeners = dataStore.listeners;
                return;
            }
            storeListeners = dataStore.listeners;
        } else {
            this.locale = Locale.getDefault(Locale.Category.DISPLAY);
            storeListeners = null;
        }
        this.listeners = new StoreListeners(storeListeners, this);
    }

    public DataStoreProvider getProvider() {
        return this.provider;
    }

    public abstract Optional<ParameterValueGroup> getOpenParameters();

    public synchronized void setLocale(Locale locale) {
        ArgumentChecks.ensureNonNull((String)"locale", (Object)locale);
        this.locale = locale;
    }

    public synchronized Locale getLocale() {
        return this.locale;
    }

    public String getDisplayName() {
        return this.name;
    }

    @Override
    public Optional<GenericName> getIdentifier() throws DataStoreException {
        Metadata metadata = this.getMetadata();
        if (metadata != null) {
            Citation citation = null;
            for (Object object : metadata.getIdentificationInfo()) {
                Citation citation2 = object.getCitation();
                if (citation2 == null) continue;
                if (citation != null && citation != citation2) {
                    return Optional.empty();
                }
                citation = citation2;
            }
            if (citation != null) {
                ReferenceIdentifier referenceIdentifier = null;
                for (Citation citation2 : citation.getIdentifiers()) {
                    if (citation2 instanceof GenericName) {
                        return Optional.of((GenericName)citation2);
                    }
                    if (referenceIdentifier != null || !(citation2 instanceof ReferenceIdentifier)) continue;
                    referenceIdentifier = (ReferenceIdentifier)citation2;
                }
                if (referenceIdentifier != null) {
                    return Optional.of(new NamedIdentifier(referenceIdentifier));
                }
            }
        }
        return Optional.empty();
    }

    @Override
    public abstract Metadata getMetadata() throws DataStoreException;

    public Optional<TreeTable> getNativeMetadata() throws DataStoreException {
        return Optional.empty();
    }

    public Resource findResource(String string) throws DataStoreException {
        ArgumentChecks.ensureNonEmpty((String)"identifier", (CharSequence)string);
        Resource resource = this.findResource(string, this, new IdentityHashMap<Resource, Boolean>());
        if (resource != null) {
            return resource;
        }
        throw new IllegalNameException(StoreUtilities.resourceNotFound(this, string));
    }

    private Resource findResource(String string, Resource resource, Map<Resource, Boolean> map) throws DataStoreException {
        if (resource != null && map.put(resource, Boolean.TRUE) == null) {
            GenericName genericName = resource.getIdentifier().orElse(null);
            if (genericName != null) {
                do {
                    if (!string.equals(genericName.toString())) continue;
                    return resource;
                } while (genericName instanceof ScopedName && genericName != (genericName = ((ScopedName)genericName).tail()));
            }
            if (resource instanceof Aggregate) {
                Resource resource2 = null;
                for (Resource resource3 : ((Aggregate)resource).components()) {
                    Resource resource4 = this.findResource(string, resource3, map);
                    if (resource4 == null) continue;
                    if (resource2 == null) {
                        resource2 = resource4;
                        continue;
                    }
                    throw new IllegalNameException(Resources.forLocale(this.getLocale()).getString((short)23, this.getDisplayName(), string));
                }
                return resource2;
            }
        }
        return null;
    }

    @Override
    public <T extends StoreEvent> void addListener(Class<T> clazz, StoreListener<? super T> storeListener) {
        this.listeners.addListener(clazz, storeListener);
    }

    @Override
    public <T extends StoreEvent> void removeListener(Class<T> clazz, StoreListener<? super T> storeListener) {
        this.listeners.removeListener(clazz, storeListener);
    }

    @Override
    public abstract void close() throws DataStoreException;

    public String toString() {
        return Strings.bracket(this.getClass(), (Object)this.getDisplayName());
    }
}

