/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.action.AbstractActionManager;
import org.apache.pdfbox.preflight.action.GoToAction;
import org.apache.pdfbox.preflight.action.GoToRemoteAction;
import org.apache.pdfbox.preflight.action.HideAction;
import org.apache.pdfbox.preflight.action.InvalidAction;
import org.apache.pdfbox.preflight.action.NamedAction;
import org.apache.pdfbox.preflight.action.SubmitAction;
import org.apache.pdfbox.preflight.action.ThreadAction;
import org.apache.pdfbox.preflight.action.UndefAction;
import org.apache.pdfbox.preflight.action.UriAction;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.utils.COSUtils;

public class ActionManagerFactory {
    public final List<AbstractActionManager> getActionManagers(PreflightContext ctx, COSDictionary dictionary) throws ValidationException {
        COSDictionary aaDict;
        COSBase aa;
        ArrayList<AbstractActionManager> result = new ArrayList<AbstractActionManager>(0);
        HashMap<COSObjectKey, Boolean> alreadyCreated = new HashMap<COSObjectKey, Boolean>();
        COSBase aDict = dictionary.getDictionaryObject(COSName.A);
        if (aDict != null) {
            this.callCreateAction(aDict, ctx, result, alreadyCreated);
        }
        COSDocument cosDocument = ctx.getDocument().getDocument();
        COSBase oaDict = dictionary.getDictionaryObject("OpenAction");
        if (oaDict != null && !COSUtils.isArray(oaDict, cosDocument)) {
            this.callCreateAction(oaDict, ctx, result, alreadyCreated);
        }
        if ((aa = dictionary.getDictionaryObject("AA")) != null && (aaDict = COSUtils.getAsDictionary(aa, cosDocument)) != null) {
            for (Object key : aaDict.keySet()) {
                COSName name = (COSName)key;
                this.callCreateAction(aaDict.getItem(name), ctx, result, name.getName(), alreadyCreated);
            }
        }
        return result;
    }

    private void callCreateAction(COSBase aDict, PreflightContext ctx, List<AbstractActionManager> result, Map<COSObjectKey, Boolean> alreadyCreated) throws ValidationException {
        this.callCreateAction(aDict, ctx, result, null, alreadyCreated);
    }

    private void callCreateAction(COSBase aDict, PreflightContext ctx, List<AbstractActionManager> result, String additionActionKey, Map<COSObjectKey, Boolean> alreadyCreated) throws ValidationException {
        COSDocument cosDocument = ctx.getDocument().getDocument();
        if (COSUtils.isDictionary(aDict, cosDocument)) {
            if (aDict instanceof COSObject) {
                COSObjectKey cok = new COSObjectKey((COSObject)aDict);
                if (!alreadyCreated.containsKey(cok)) {
                    result.add(this.createActionManager(ctx, COSUtils.getAsDictionary(aDict, cosDocument), additionActionKey));
                    alreadyCreated.put(cok, true);
                }
            } else {
                result.add(this.createActionManager(ctx, COSUtils.getAsDictionary(aDict, cosDocument), additionActionKey));
            }
        } else {
            ctx.addValidationError(new ValidationResult.ValidationError("6.1.3", "Action entry isn't an instance of COSDictionary"));
        }
    }

    public final List<AbstractActionManager> getNextActions(PreflightContext ctx, COSDictionary actionDictionary) throws ValidationException {
        ArrayList<AbstractActionManager> result = new ArrayList<AbstractActionManager>(0);
        HashMap<COSObjectKey, Boolean> alreadyCreated = new HashMap<COSObjectKey, Boolean>();
        COSBase nextDict = actionDictionary.getDictionaryObject("Next");
        if (nextDict != null) {
            COSDocument cosDocument = ctx.getDocument().getDocument();
            if (COSUtils.isArray(nextDict, cosDocument)) {
                COSArray array = COSUtils.getAsArray(nextDict, cosDocument);
                for (int i = 0; i < array.size(); ++i) {
                    this.callCreateAction(array.get(i), ctx, result, alreadyCreated);
                }
            } else {
                this.callCreateAction(nextDict, ctx, result, alreadyCreated);
            }
        }
        return result;
    }

    protected AbstractActionManager createActionManager(PreflightContext ctx, COSDictionary action, String aaKey) throws ValidationException {
        String type = action.getNameAsString(COSName.TYPE);
        if (type != null && !"Action".equals(type)) {
            throw new ValidationException("The given dictionary isn't the dictionary of an Action");
        }
        String s = action.getNameAsString(COSName.S);
        if ("GoTo".equals(s)) {
            return new GoToAction(this, action, ctx, aaKey);
        }
        if ("GoToR".equals(s)) {
            return new GoToRemoteAction(this, action, ctx, aaKey);
        }
        if ("Thread".equals(s)) {
            return new ThreadAction(this, action, ctx, aaKey);
        }
        if ("URI".equals(s)) {
            return new UriAction(this, action, ctx, aaKey);
        }
        if ("Hide".equals(s)) {
            return new HideAction(this, action, ctx, aaKey);
        }
        if ("Named".equals(s)) {
            return new NamedAction(this, action, ctx, aaKey);
        }
        if ("SubmitForm".equals(s)) {
            return new SubmitAction(this, action, ctx, aaKey);
        }
        if ("Launch".equals(s) || "Sound".equals(s) || "Movie".equals(s) || "ResetForm".equals(s) || "ImportData".equals(s) || "JavaScript".equals(s) || "SetState".equals(s) || "NOP".equals(s)) {
            return new InvalidAction(this, action, ctx, aaKey, s);
        }
        return new UndefAction(this, action, ctx, aaKey, s);
    }
}

