/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.access;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.security.IdentityConstants;

public class AccessControlList
implements Externalizable {
    private static final long serialVersionUID = 5848327750178729120L;
    public static final String DELIMITER = ";";
    private String owner;
    private final List<AccessControlEntry> accessList;

    public AccessControlList() {
        this(IdentityConstants.SYSTEM);
    }

    AccessControlList(String ownerName) {
        this.owner = ownerName;
        this.accessList = new ArrayList<AccessControlEntry>();
        for (String str : PermissionType.ALL) {
            this.accessList.add(new AccessControlEntry(IdentityConstants.ANY, str));
        }
    }

    public AccessControlList(String owner, List<AccessControlEntry> accessList) {
        this.owner = owner;
        this.accessList = accessList;
    }

    public boolean hasPermissions() {
        return this.accessList != null;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public void addPermissions(String rawData) throws RepositoryException {
        StringTokenizer listTokenizer = new StringTokenizer(rawData, DELIMITER);
        if (listTokenizer.countTokens() < 1) {
            throw new RepositoryException("AccessControlList " + rawData + " is empty or have a bad format");
        }
        while (listTokenizer.hasMoreTokens()) {
            String entry = listTokenizer.nextToken();
            try {
                this.accessList.add(AccessControlEntry.parse(entry));
            }
            catch (IllegalArgumentException e) {
                throw new RepositoryException("AccessControlEntry " + entry + " is empty or have a bad format", (Throwable)e);
            }
        }
    }

    public void addPermissions(String identity, String[] perm) throws RepositoryException {
        for (String p : perm) {
            this.accessList.add(new AccessControlEntry(identity, p));
        }
    }

    public void removePermissions(String identity) {
        Iterator<AccessControlEntry> iter = this.accessList.iterator();
        while (iter.hasNext()) {
            AccessControlEntry a = iter.next();
            if (!a.getIdentity().equals(identity)) continue;
            iter.remove();
        }
    }

    public void removePermissions(String identity, String permission) {
        Iterator<AccessControlEntry> iter = this.accessList.iterator();
        while (iter.hasNext()) {
            AccessControlEntry a = iter.next();
            if (!a.getIdentity().equals(identity) || !a.getPermission().equals(permission)) continue;
            iter.remove();
        }
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public List<AccessControlEntry> getPermissionEntries() {
        ArrayList<AccessControlEntry> list = new ArrayList<AccessControlEntry>();
        int length = this.accessList.size();
        for (int i = 0; i < length; ++i) {
            AccessControlEntry entry = this.accessList.get(i);
            list.add(new AccessControlEntry(entry.getIdentity(), entry.getPermission()));
        }
        return list;
    }

    public List<String> getPermissions(String identity) {
        ArrayList<String> permissions = new ArrayList<String>();
        int length = this.accessList.size();
        for (int i = 0; i < length; ++i) {
            AccessControlEntry entry = this.accessList.get(i);
            if (!entry.getIdentity().equals(identity)) continue;
            permissions.add(entry.getPermission());
        }
        return permissions;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AccessControlList) {
            AccessControlList another = (AccessControlList)obj;
            if (!(this.owner == null && another.owner == null || this.owner != null && this.owner.equals(another.owner))) {
                return false;
            }
            List<AccessControlEntry> anotherAccessList = another.accessList;
            if (this.accessList == null && anotherAccessList == null) {
                return true;
            }
            if (this.accessList != null && anotherAccessList != null && this.accessList.size() == anotherAccessList.size()) {
                for (int i = 0; i < this.accessList.size(); ++i) {
                    if (this.accessList.get(i).getAsString().equals(anotherAccessList.get(i).getAsString())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public String dump() {
        StringBuilder res = new StringBuilder("OWNER: ").append(this.owner != null ? this.owner : "null").append("\n");
        if (this.accessList != null) {
            for (AccessControlEntry a : this.accessList) {
                res.append(a.getAsString()).append("\n");
            }
        } else {
            res.append("null");
        }
        return res.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buf;
        int ownLength = in.readInt();
        if (ownLength != 0) {
            buf = new byte[ownLength];
            in.readFully(buf);
            this.owner = new String(buf, "UTF-8");
        } else {
            this.owner = null;
        }
        this.accessList.clear();
        int listSize = in.readInt();
        for (int i = 0; i < listSize; ++i) {
            buf = new byte[in.readInt()];
            in.readFully(buf);
            String ident = new String(buf, "UTF-8");
            buf = new byte[in.readInt()];
            in.readFully(buf);
            String perm = new String(buf, "UTF-8");
            this.accessList.add(new AccessControlEntry(ident, perm));
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.owner != null) {
            out.writeInt(this.owner.getBytes().length);
            out.write(this.owner.getBytes());
        } else {
            out.writeInt(0);
        }
        out.writeInt(this.accessList.size());
        for (AccessControlEntry entry : this.accessList) {
            out.writeInt(entry.getIdentity().getBytes().length);
            out.write(entry.getIdentity().getBytes());
            out.writeInt(entry.getPermission().getBytes().length);
            out.write(entry.getPermission().getBytes());
        }
    }

    public int getPermissionsSize() {
        return this.accessList.size();
    }

    List<AccessControlEntry> getPermissionsList() {
        return this.accessList;
    }
}

