/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.collection;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class SoftSet
implements Set {
    private HashMap map = new HashMap();
    private ReferenceQueue gcqueue = new ReferenceQueue();

    @Override
    public int size() {
        this.processQueue();
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        this.processQueue();
        Integer key = new Integer(o.hashCode());
        boolean contains = this.map.containsKey(key);
        return contains;
    }

    @Override
    public Iterator iterator() {
        this.processQueue();
        Iterator theIter = this.map.values().iterator();
        return new ComparableSoftReferenceIterator(theIter);
    }

    @Override
    public Object[] toArray() {
        this.processQueue();
        return this.toArray(new Object[0]);
    }

    @Override
    public Object[] toArray(Object[] a) {
        this.processQueue();
        int size = this.map.size();
        Object[] array = new Object[]{};
        if (a.length >= size) {
            array = a;
        }
        Iterator iter = this.map.values().iterator();
        int index = 0;
        while (iter.hasNext()) {
            ComparableSoftReference csr = (ComparableSoftReference)iter.next();
            Object value = csr.get();
            if (array.length == 0) {
                if (value == null) {
                    ++index;
                    continue;
                }
                Array.newInstance(value.getClass(), size);
            }
            array[index] = value;
            ++index;
        }
        return array;
    }

    @Override
    public boolean add(Object o) {
        this.processQueue();
        Integer key = new Integer(o.hashCode());
        ComparableSoftReference sr = new ComparableSoftReference(key, o, this.gcqueue);
        return this.map.put(key, sr) == null;
    }

    @Override
    public boolean remove(Object o) {
        this.processQueue();
        Integer key = new Integer(o.hashCode());
        return this.map.remove(key) != null;
    }

    @Override
    public boolean containsAll(Collection c) {
        this.processQueue();
        Iterator iter = c.iterator();
        boolean contains = true;
        while (iter.hasNext()) {
            Object value = iter.next();
            Integer key = new Integer(value.hashCode());
            contains &= this.map.containsKey(key);
        }
        return contains;
    }

    @Override
    public boolean addAll(Collection c) {
        this.processQueue();
        Iterator iter = c.iterator();
        boolean added = false;
        while (iter.hasNext()) {
            ComparableSoftReference sr;
            Object value = iter.next();
            Integer key = new Integer(value.hashCode());
            added |= this.map.put(key, sr = new ComparableSoftReference(key, value, this.gcqueue)) == null;
        }
        return added;
    }

    @Override
    public boolean retainAll(Collection c) {
        Iterator iter = this.iterator();
        boolean removed = false;
        while (iter.hasNext()) {
            Object value = iter.next();
            if (c.contains(value)) continue;
            iter.remove();
            removed = true;
        }
        return removed;
    }

    @Override
    public boolean removeAll(Collection c) {
        this.processQueue();
        Iterator iter = c.iterator();
        boolean removed = false;
        while (iter.hasNext()) {
            Object value = iter.next();
            removed |= this.remove(value);
        }
        return removed;
    }

    @Override
    public void clear() {
        while (this.gcqueue.poll() != null) {
        }
        this.map.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    private void processQueue() {
        ComparableSoftReference cr;
        while ((cr = (ComparableSoftReference)this.gcqueue.poll()) != null) {
            this.map.remove(cr.getKey());
        }
    }

    static class ComparableSoftReferenceIterator
    implements Iterator {
        Iterator theIter;

        ComparableSoftReferenceIterator(Iterator theIter) {
            this.theIter = theIter;
        }

        @Override
        public boolean hasNext() {
            return this.theIter.hasNext();
        }

        public Object next() {
            ComparableSoftReference csr = (ComparableSoftReference)this.theIter.next();
            return csr.get();
        }

        @Override
        public void remove() {
            this.theIter.remove();
        }
    }

    static class ComparableSoftReference
    extends SoftReference {
        private Integer key;

        ComparableSoftReference(Integer key, Object o, ReferenceQueue q) {
            super(o, q);
            this.key = key;
        }

        Integer getKey() {
            return this.key;
        }
    }
}

