/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.init;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.StorageDBInitializer;

public class OracleDBInitializer
extends StorageDBInitializer {
    public OracleDBInitializer(Connection connection, JDBCDataContainerConfig containerConfig) throws IOException {
        super(connection, containerConfig);
    }

    @Override
    protected boolean isSequenceExists(Connection conn, String sequenceName) throws SQLException {
        ResultSet srs = null;
        Statement st = null;
        try {
            st = conn.createStatement();
            srs = st.executeQuery("SELECT " + sequenceName + ".nextval FROM DUAL");
            if (srs.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            if (e.getMessage().indexOf("ORA-02289") >= 0) {
                boolean bl = false;
                return bl;
            }
            throw e;
        }
        finally {
            if (srs != null) {
                try {
                    srs.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + String.valueOf(e)));
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the Statement: " + String.valueOf(e)));
                }
            }
        }
    }
}

