/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.cs.AxisFilter;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.operation.DefaultConversion;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.util.FactoryException;

final class EllipsoidalHeightSeparator
implements AxisFilter {
    private final GeodeticDatum datum;
    private final boolean vertical;

    EllipsoidalHeightSeparator(GeodeticDatum geodeticDatum, boolean bl) {
        this.datum = geodeticDatum;
        this.vertical = bl;
    }

    @Override
    public boolean accept(CoordinateSystemAxis coordinateSystemAxis) {
        return AxisDirections.isVertical(coordinateSystemAxis.getDirection()) == this.vertical;
    }

    private static CRSFactory factory() {
        return (CRSFactory)DefaultFactories.forBuildin(CRSFactory.class);
    }

    SingleCRS separate(SingleCRS singleCRS) throws FactoryException {
        CoordinateSystem coordinateSystem = CoordinateSystems.replaceAxes(singleCRS.getCoordinateSystem(), this);
        if (this.vertical) {
            VerticalCRS verticalCRS = CommonCRS.Vertical.ELLIPSOIDAL.crs();
            if (!Utilities.equalsIgnoreMetadata((Object)verticalCRS.getCoordinateSystem(), (Object)coordinateSystem)) {
                verticalCRS = EllipsoidalHeightSeparator.factory().createVerticalCRS(ReferencingUtilities.getPropertiesForModifiedCRS((IdentifiedObject)verticalCRS), verticalCRS.getDatum(), (VerticalCS)coordinateSystem);
            }
            return verticalCRS;
        }
        if (singleCRS instanceof GeodeticCRS) {
            CommonCRS commonCRS;
            if (!(coordinateSystem instanceof EllipsoidalCS)) {
                throw new IllegalArgumentException(Errors.format((short)178, (Object)IdentifiedObjects.getName((IdentifiedObject)coordinateSystem, null)));
            }
            CommonCRS commonCRS2 = CommonCRS.WGS84;
            if (Utilities.equalsIgnoreMetadata((Object)commonCRS2.geographic().getCoordinateSystem(), (Object)coordinateSystem)) {
                CommonCRS commonCRS3 = CommonCRS.forDatum(this.datum);
                if (commonCRS3 != null) {
                    return commonCRS3.geographic();
                }
            } else if (Utilities.equalsIgnoreMetadata((Object)commonCRS2.normalizedGeographic().getCoordinateSystem(), (Object)coordinateSystem) && (commonCRS = CommonCRS.forDatum(this.datum)) != null) {
                return commonCRS.normalizedGeographic();
            }
            return EllipsoidalHeightSeparator.factory().createGeographicCRS(ReferencingUtilities.getPropertiesForModifiedCRS((IdentifiedObject)singleCRS), this.datum, (EllipsoidalCS)coordinateSystem);
        }
        if (singleCRS instanceof ProjectedCRS) {
            GeographicCRS geographicCRS = ((ProjectedCRS)singleCRS).getBaseCRS();
            if (ReferencingUtilities.getDimension((CoordinateReferenceSystem)geographicCRS) != 2) {
                geographicCRS = (GeographicCRS)this.separate((SingleCRS)geographicCRS);
            }
            Object object = ((ProjectedCRS)singleCRS).getConversionFromBase();
            object = new DefaultConversion(ReferencingUtilities.getPropertiesForModifiedCRS((IdentifiedObject)object), object.getMethod(), null, object.getParameterValues());
            return EllipsoidalHeightSeparator.factory().createProjectedCRS(ReferencingUtilities.getPropertiesForModifiedCRS((IdentifiedObject)singleCRS), geographicCRS, (Conversion)object, (CartesianCS)coordinateSystem);
        }
        throw new IllegalArgumentException(Errors.format((short)163, (Object)singleCRS.getClass()));
    }
}

