/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.exoplatform.services.jcr.impl.storage.value.ValueDataResourceHolder;
import org.exoplatform.services.jcr.impl.storage.value.fs.FileIOChannel;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;

public class SimpleFileIOChannel
extends FileIOChannel {
    public SimpleFileIOChannel(File rootDir, FileCleaner cleaner, String storageId, ValueDataResourceHolder resources) {
        super(rootDir, cleaner, storageId, resources);
    }

    @Override
    protected String makeFilePath(String propertyId, int orderNumber) {
        return propertyId + orderNumber;
    }

    @Override
    protected File getFile(String propertyId, int orderNumber) throws IOException {
        return new File(this.rootDir, this.makeFilePath(propertyId, orderNumber));
    }

    @Override
    protected File[] getFiles(String propertyId) throws IOException {
        return this.rootDir.listFiles(new PropertyIDFilter(this, propertyId));
    }

    protected class PropertyIDFilter
    implements FileFilter {
        private String propertyId;

        public PropertyIDFilter(SimpleFileIOChannel this$0, String propertyId) {
            this.propertyId = propertyId;
        }

        @Override
        public boolean accept(File file) {
            return file.getName().startsWith(this.propertyId);
        }
    }
}

