/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.io;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.internal.storage.io.DataTransfer;
import org.apache.sis.internal.storage.io.MemoryDataTransfer;
import org.apache.sis.internal.storage.io.Region;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.util.resources.Errors;

public class HyperRectangleReader {
    private final DataTransfer reader;
    private long origin;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HyperRectangleReader(byte by, ChannelDataInput channelDataInput) throws DataStoreContentException {
        switch (by) {
            case 3: {
                ChannelDataInput channelDataInput2 = channelDataInput;
                Objects.requireNonNull(channelDataInput2);
                this.reader = channelDataInput2.new ChannelDataInput.BytesReader(null);
                break;
            }
            case 2: {
                ChannelDataInput channelDataInput3 = channelDataInput;
                Objects.requireNonNull(channelDataInput3);
                this.reader = channelDataInput3.new ChannelDataInput.CharsReader((char[])null);
                break;
            }
            case 4: {
                ChannelDataInput channelDataInput4 = channelDataInput;
                Objects.requireNonNull(channelDataInput4);
                this.reader = channelDataInput4.new ChannelDataInput.ShortsReader((short[])null);
                break;
            }
            case 5: {
                ChannelDataInput channelDataInput5 = channelDataInput;
                Objects.requireNonNull(channelDataInput5);
                this.reader = channelDataInput5.new ChannelDataInput.IntsReader((int[])null);
                break;
            }
            case 6: {
                ChannelDataInput channelDataInput6 = channelDataInput;
                Objects.requireNonNull(channelDataInput6);
                this.reader = channelDataInput6.new ChannelDataInput.LongsReader((long[])null);
                break;
            }
            case 8: {
                ChannelDataInput channelDataInput7 = channelDataInput;
                Objects.requireNonNull(channelDataInput7);
                this.reader = channelDataInput7.new ChannelDataInput.FloatsReader((float[])null);
                break;
            }
            case 9: {
                ChannelDataInput channelDataInput8 = channelDataInput;
                Objects.requireNonNull(channelDataInput8);
                this.reader = channelDataInput8.new ChannelDataInput.DoublesReader((double[])null);
                break;
            }
            default: {
                throw new DataStoreContentException(Errors.format((short)149, (Object)by));
            }
        }
        ByteBuffer byteBuffer = channelDataInput.buffer;
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        try {
            byteBuffer.position(0).limit(byteBuffer.capacity());
            this.reader.createView();
        }
        finally {
            byteBuffer.limit(n2).position(n);
        }
    }

    public HyperRectangleReader(String string, Buffer buffer) throws IOException {
        this.reader = new MemoryDataTransfer(string, buffer).reader();
    }

    public final String filename() {
        return this.reader.filename();
    }

    public final int sampleSize() {
        return 1 << this.reader.dataSizeShift();
    }

    public final long getOrigin() {
        return this.origin;
    }

    public final void setOrigin(long l) {
        this.origin = l;
    }

    public final Object read(Region region) throws IOException {
        return this.read(region, 0, false);
    }

    public final Buffer readAsBuffer(Region region, int n) throws IOException {
        return (Buffer)this.read(region, n, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object read(Region region, int n, boolean bl) throws IOException {
        int n2;
        int n3 = region.contiguousDataDimension();
        int n4 = region.targetLength(n3);
        long[] lArray = new long[region.getDimension() - n3];
        int[] nArray = new int[lArray.length];
        int n5 = this.sampleSize();
        long l = Math.addExact(this.origin, region.offset(n5));
        int n6 = 0;
        for (n2 = 0; n2 < lArray.length; ++n2) {
            lArray[n2] = region.stride(n2 + n3, n4, n5);
            assert (lArray[n2] > 0L) : n2;
        }
        n2 = region.targetLength(region.getDimension());
        try {
            this.reader.createDataArray(Math.max(n, n2));
            Buffer buffer = this.reader.view();
            block4: while (true) {
                this.reader.seek(l);
                assert (this.reader.view() == buffer);
                this.reader.readFully(buffer, n6, n4);
                for (int i = 0; i < nArray.length; ++i) {
                    int n7 = i;
                    nArray[n7] = nArray[n7] + 1;
                    if (nArray[n7] < region.targetSize[n3 + i]) {
                        l = Math.addExact(l, lArray[i]);
                        n6 = Math.addExact(n6, n4);
                        continue block4;
                    }
                    nArray[i] = 0;
                }
                break;
            }
            Object object = bl ? this.reader.dataArrayAsBuffer().limit(n2) : this.reader.dataArray();
            return object;
        }
        finally {
            this.reader.setDest(null);
        }
    }
}

