/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.api.functional;

import org.infinispan.commons.util.Experimental;

@Experimental
public interface EntryVersion<T> {
    public T get();

    public CompareResult compareTo(EntryVersion<T> var1);

    public static final class NumericEntryVersion
    implements EntryVersion<Long> {
        private final long version;

        public NumericEntryVersion(long version) {
            this.version = version;
        }

        @Override
        public Long get() {
            return this.version;
        }

        @Override
        public CompareResult compareTo(EntryVersion<Long> other) {
            if (this.version < other.get()) {
                return CompareResult.BEFORE;
            }
            if (this.version > other.get()) {
                return CompareResult.AFTER;
            }
            return CompareResult.EQUAL;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NumericEntryVersion that = (NumericEntryVersion)o;
            return this.version == that.version;
        }

        public int hashCode() {
            return (int)(this.version ^ this.version >>> 32);
        }

        public String toString() {
            return "NumericEntryVersion=" + this.version;
        }
    }

    public static enum CompareResult {
        BEFORE,
        AFTER,
        EQUAL,
        CONFLICTING;

    }
}

