/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.util.Collections;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.Formulas;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.internal.referencing.provider.GeocentricAffineBetweenGeographic;
import org.apache.sis.internal.referencing.provider.GeodeticOperation;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.referencing.operation.transform.MolodenskyTransform;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;

@XmlTransient
public final class Molodensky
extends GeocentricAffineBetweenGeographic {
    private static final long serialVersionUID = 8126525068450868912L;
    public static final ParameterDescriptor<Double> AXIS_LENGTH_DIFFERENCE;
    public static final ParameterDescriptor<Double> FLATTENING_DIFFERENCE;
    public static final ParameterDescriptorGroup PARAMETERS;

    public static ParameterDescriptorGroup internal() {
        ParameterBuilder parameterBuilder = (ParameterBuilder)Molodensky.builder().setCodeSpace(Citations.SIS, "SIS");
        ParameterDescriptor<Object> parameterDescriptor = ((ParameterBuilder)parameterBuilder.addName("abridged")).create(Boolean.class, null);
        return ((ParameterBuilder)parameterBuilder.addName("Molodensky (radians domain)")).createGroup(new GeneralParameterDescriptor[]{DIMENSION, SRC_SEMI_MAJOR, SRC_SEMI_MINOR, AXIS_LENGTH_DIFFERENCE, FLATTENING_DIFFERENCE, TX, TY, TZ, parameterDescriptor});
    }

    public Molodensky() {
        this(3, 3, new Molodensky[4]);
        this.redimensioned[0] = new Molodensky(2, 2, this.redimensioned);
        this.redimensioned[1] = new Molodensky(2, 3, this.redimensioned);
        this.redimensioned[2] = new Molodensky(3, 2, this.redimensioned);
        this.redimensioned[3] = this;
    }

    private Molodensky(int n, int n2, GeodeticOperation[] geodeticOperationArray) {
        super(n, n2, PARAMETERS, geodeticOperationArray);
    }

    @Override
    int getType() {
        return 0;
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory mathTransformFactory, ParameterValueGroup parameterValueGroup) throws FactoryException {
        return Molodensky.createMathTransform(mathTransformFactory, Parameters.castOrWrap(parameterValueGroup), this.getSourceDimensions(), this.getTargetDimensions(), false);
    }

    static MathTransform createMathTransform(MathTransformFactory mathTransformFactory, Parameters parameters, int n, int n2, boolean bl) throws FactoryException {
        Ellipsoid ellipsoid;
        Integer n3 = (Integer)parameters.getValue(DIMENSION);
        if (n3 != null) {
            int n4 = n3;
            if (n4 != 2 && n4 != 3) {
                throw new InvalidParameterValueException(Errors.format((short)45, (Object)"dim", (Object)n3), "dim", (Object)n3);
            }
            n = n2 = n4;
        }
        double d = parameters.doubleValue((ParameterDescriptor<? extends Number>)SRC_SEMI_MAJOR);
        double d2 = parameters.doubleValue((ParameterDescriptor<? extends Number>)SRC_SEMI_MINOR);
        double d3 = Molodensky.optional(parameters, (ParameterDescriptor<Double>)TGT_SEMI_MAJOR);
        double d4 = Molodensky.optional(parameters, (ParameterDescriptor<Double>)TGT_SEMI_MINOR);
        double d5 = Molodensky.conditional(parameters, AXIS_LENGTH_DIFFERENCE, d3);
        double d6 = Molodensky.conditional(parameters, FLATTENING_DIFFERENCE, d4);
        if (Double.isNaN(d3)) {
            d3 = d + d5;
        }
        if (Double.isNaN(d4)) {
            d4 = d3 * (d2 / d - d6);
        }
        Map<String, ReferenceIdentifier> map = Collections.singletonMap("name", NilReferencingObject.UNNAMED);
        Ellipsoid ellipsoid2 = new Ellipsoid(map, d, d2, d5, d6);
        ellipsoid2.other = ellipsoid = new Ellipsoid(map, d3, d4, -d5, -d6);
        ellipsoid.other = ellipsoid2;
        ellipsoid2.computeDifferences(parameters);
        return MolodenskyTransform.createGeodeticTransformation(mathTransformFactory, ellipsoid2, n >= 3, ellipsoid, n2 >= 3, parameters.doubleValue((ParameterDescriptor<? extends Number>)TX), parameters.doubleValue((ParameterDescriptor<? extends Number>)TY), parameters.doubleValue((ParameterDescriptor<? extends Number>)TZ), bl);
    }

    private static double optional(Parameters parameters, ParameterDescriptor<Double> parameterDescriptor) {
        Double d = parameters.getValue(parameterDescriptor);
        return d != null ? d : Double.NaN;
    }

    private static double conditional(Parameters parameters, ParameterDescriptor<Double> parameterDescriptor, double d) {
        return Double.isNaN(d) ? parameters.doubleValue(parameterDescriptor) : Molodensky.optional(parameters, parameterDescriptor);
    }

    static {
        ParameterBuilder parameterBuilder = Molodensky.builder();
        AXIS_LENGTH_DIFFERENCE = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8654")).addName("Semi-major axis length difference")).create(Double.NaN, Units.METRE);
        FLATTENING_DIFFERENCE = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8655")).addName("Flattening difference")).createBounded(-1.0, 1.0, Double.NaN, Units.UNITY);
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.setRequired(true).addIdentifier("9604")).addName("Molodensky")).addName((Citation)Citations.OGC, "Molodenski")).createGroup(new GeneralParameterDescriptor[]{DIMENSION, SRC_SEMI_MAJOR, SRC_SEMI_MINOR, TGT_SEMI_MAJOR, TGT_SEMI_MINOR, TX, TY, TZ, AXIS_LENGTH_DIFFERENCE, FLATTENING_DIFFERENCE});
    }

    private static final class Ellipsoid
    extends DefaultEllipsoid {
        private double \u0394a;
        private double \u0394f;
        Ellipsoid other;

        Ellipsoid(Map<String, ?> map, double d, double d2, double d3, double d4) {
            super(map, d, d2, Formulas.getInverseFlattening(d, d2), false, (Unit<Length>)Units.METRE);
            this.\u0394a = d3;
            this.\u0394f = d4;
        }

        void computeDifferences(Parameters parameters) {
            if (Double.isNaN(this.\u0394a)) {
                this.\u0394a = super.semiMajorAxisDifference(this.other);
                Ellipsoid.setIfPresent(parameters, AXIS_LENGTH_DIFFERENCE, this.\u0394a, this.getAxisUnit());
            }
            if (Double.isNaN(this.\u0394f)) {
                this.\u0394f = super.flatteningDifference(this.other);
                Ellipsoid.setIfPresent(parameters, FLATTENING_DIFFERENCE, this.\u0394f, Units.UNITY);
            }
        }

        private static void setIfPresent(Parameters parameters, ParameterDescriptor<Double> parameterDescriptor, double d, Unit<?> unit) {
            try {
                parameters.getOrCreate(parameterDescriptor).setValue(d, unit);
            }
            catch (InvalidParameterValueException | ParameterNotFoundException throwable) {
                AbstractProvider.recoverableException(Molodensky.class, (Exception)throwable);
            }
        }

        @Override
        public double semiMajorAxisDifference(org.opengis.referencing.datum.Ellipsoid ellipsoid) {
            return ellipsoid == this.other && !Double.isNaN(this.\u0394a) ? this.\u0394a : super.semiMajorAxisDifference(ellipsoid);
        }

        @Override
        public double flatteningDifference(org.opengis.referencing.datum.Ellipsoid ellipsoid) {
            return ellipsoid == this.other && !Double.isNaN(this.\u0394f) ? this.\u0394f : super.flatteningDifference(ellipsoid);
        }
    }
}

