/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rpc.RPCException;
import org.exoplatform.services.rpc.RPCService;
import org.exoplatform.services.rpc.RemoteCommand;
import org.exoplatform.services.rpc.TopologyChangeEvent;
import org.exoplatform.services.rpc.TopologyChangeListener;
import org.picocontainer.Startable;

public class WorkspaceResumer
implements Startable,
TopologyChangeListener {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.WorkspaceResumer");
    private final RPCService rpcService;
    private RemoteCommand requestForResponsibleForResuming;
    private final WorkspaceEntry wsEntry;
    private final RepositoryImpl reposistory;
    public final AtomicBoolean responsibleForResuming = new AtomicBoolean(false);

    public WorkspaceResumer(RPCService rpcService, RepositoryImpl reposistory, WorkspaceEntry wsEntry) {
        this.rpcService = rpcService;
        this.wsEntry = wsEntry;
        this.reposistory = reposistory;
    }

    private void unregisterRemoteCommands() {
        this.rpcService.unregisterCommand(this.requestForResponsibleForResuming);
        this.rpcService.unregisterTopologyChangeListener(this);
    }

    private void registerRemoteCommands() {
        this.requestForResponsibleForResuming = this.rpcService.registerCommand(new RemoteCommand(){

            @Override
            public String getId() {
                return this.getClass().getName() + "-requestForResponsibilityForResuming-" + WorkspaceResumer.this.wsEntry.getUniqueName();
            }

            @Override
            public Serializable execute(Serializable[] args) throws Throwable {
                return Boolean.valueOf(WorkspaceResumer.this.responsibleForResuming.get());
            }
        });
        this.rpcService.registerTopologyChangeListener(this);
    }

    public void start() {
        this.registerRemoteCommands();
    }

    public void stop() {
        this.unregisterRemoteCommands();
    }

    public void onSuspend() {
        LOG.info((Object)("Suspending workspace " + this.wsEntry.getUniqueName()));
        this.responsibleForResuming.set(true);
    }

    public void onResume() {
        LOG.info((Object)("Setting workspace " + this.wsEntry.getUniqueName() + " online"));
        this.responsibleForResuming.set(false);
    }

    @Override
    public void onChange(TopologyChangeEvent event) {
        try {
            WorkspaceContainerFacade wsContainer;
            if (this.rpcService.isCoordinator() && (wsContainer = this.reposistory.getWorkspaceContainer(this.wsEntry.getName())).getState() == 3) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            List<Object> results = WorkspaceResumer.this.rpcService.executeCommandOnAllNodes(WorkspaceResumer.this.requestForResponsibleForResuming, true, new Serializable[0]);
                            for (Object result : results) {
                                if (result instanceof Throwable || !((Boolean)result).booleanValue()) continue;
                                return;
                            }
                            wsContainer.setState(1);
                        }
                        catch (SecurityException e) {
                            LOG.error((Object)"You haven't privileges to execute remote command", (Throwable)e);
                        }
                        catch (RepositoryException e) {
                            LOG.error((Object)"Can't resume workspace", (Throwable)e);
                        }
                        catch (RPCException e) {
                            LOG.error((Object)"Can't resume workspace", (Throwable)e);
                        }
                    }
                }.start();
            }
        }
        catch (RPCException e) {
            LOG.error((Object)"Exception during command execution", (Throwable)e);
        }
    }
}

