/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.itemfilters;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.core.itemfilters.PatternQPathEntry;
import org.exoplatform.services.jcr.impl.core.itemfilters.QPathEntryFilter;

public class PatternQPathEntryFilter
implements QPathEntryFilter {
    private QPathEntry entry;
    private boolean namespaceIsWildcard;
    private boolean localNameHasWildcard;
    private Pattern localNamePattern = null;

    public PatternQPathEntryFilter() {
    }

    public PatternQPathEntryFilter(QPathEntry entry) {
        this.entry = entry;
        this.namespaceIsWildcard = entry.getNamespace().equals("*");
        this.localNameHasWildcard = entry.getName().indexOf(42) != -1;
    }

    @Override
    public boolean isExactName() {
        return false;
    }

    @Override
    public QPathEntry getQPathEntry() {
        return this.entry;
    }

    @Override
    public boolean accept(ItemData item) {
        if (this.localNameHasWildcard && this.localNamePattern == null) {
            this.initializePattern();
        }
        QPathEntry itemEntry = item.getQPath().getEntries()[item.getQPath().getDepth()];
        if (this.entry.getIndex() != -1 && this.entry.getIndex() != itemEntry.getIndex()) {
            return false;
        }
        if (!this.namespaceIsWildcard && !this.entry.getNamespace().equals(itemEntry.getNamespace())) {
            return false;
        }
        if (!this.localNameHasWildcard) {
            return this.entry.getName().equals(itemEntry.getName());
        }
        return this.localNamePattern.matcher(itemEntry.getName()).matches();
    }

    @Override
    public List<? extends ItemData> accept(List<? extends ItemData> itemData) {
        ArrayList<ItemData> result = new ArrayList<ItemData>();
        for (int i = 0; i < itemData.size(); ++i) {
            if (!this.accept(itemData.get(i))) continue;
            result.add(itemData.get(i));
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof QPathEntryFilter) {
            QPathEntryFilter that = (QPathEntryFilter)o;
            return this.getQPathEntry().equals(that.getQPathEntry());
        }
        return false;
    }

    private void initializePattern() {
        StringBuilder sb = new StringBuilder();
        block4: for (char c : this.entry.getName().toCharArray()) {
            switch (c) {
                case '*': {
                    sb.append(".*");
                    continue block4;
                }
                case '!': 
                case '$': 
                case '&': 
                case '(': 
                case ')': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case ':': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '}': {
                    sb.append('\\');
                }
                default: {
                    sb.append(c);
                }
            }
        }
        this.localNamePattern = Pattern.compile(sb.toString());
    }

    public int hashCode() {
        return this.entry.hashCode();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] buf = this.entry.getNamespace().getBytes("UTF-8");
        out.writeInt(buf.length);
        out.write(buf);
        buf = this.entry.getName().getBytes("UTF-8");
        out.writeInt(buf.length);
        out.write(buf);
        out.writeInt(this.entry.getIndex());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buf = new byte[in.readInt()];
        in.readFully(buf);
        String namespace = new String(buf, "UTF-8");
        this.namespaceIsWildcard = namespace.equals("*");
        buf = new byte[in.readInt()];
        in.readFully(buf);
        String localName = new String(buf, "UTF-8");
        this.localNameHasWildcard = localName.indexOf(42) != -1;
        int index = in.readInt();
        this.entry = new PatternQPathEntry(namespace, localName, index);
    }
}

